/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.ScrollBarVisibility;

@ParametersAreNonnullByDefault
public class CodeAreaSwingUtils {
    public static final int MIN_MONOSPACE_CODE_POINT = 31;
    public static final int MAX_MONOSPACE_CODE_POINT = 451;
    public static final int INV_SPACE_CODE_POINT = 127;
    public static final int EXCEPTION1_CODE_POINT = 142;
    public static final int EXCEPTION2_CODE_POINT = 158;
    public static int MAX_COLOR_COMPONENT_VALUE = 255;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String FALLBACK_CLIPBOARD = "clipboard";
    private static Clipboard clipboard = null;

    private CodeAreaSwingUtils() {
    }

    public static boolean areSameColors(@Nullable Color color, @Nullable Color comparedColor) {
        return color == null && comparedColor == null || color != null && color.equals(comparedColor);
    }

    @Nonnull
    public static Color createOddColor(Color color) {
        return new Color(CodeAreaSwingUtils.computeOddColorComponent(color.getRed()), CodeAreaSwingUtils.computeOddColorComponent(color.getGreen()), CodeAreaSwingUtils.computeOddColorComponent(color.getBlue()));
    }

    public static int computeOddColorComponent(int colorComponent) {
        return colorComponent + (colorComponent > 64 ? -16 : 16);
    }

    @Nonnull
    public static Color createNegativeColor(Color color) {
        return new Color(MAX_COLOR_COMPONENT_VALUE - color.getRed(), MAX_COLOR_COMPONENT_VALUE - color.getGreen(), MAX_COLOR_COMPONENT_VALUE - color.getBlue());
    }

    @Nonnull
    public static Color computeGrayColor(Color color) {
        int grayLevel = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
        return new Color(grayLevel, grayLevel, grayLevel);
    }

    public static int getVerticalScrollBarPolicy(ScrollBarVisibility scrollBarVisibility) {
        switch (scrollBarVisibility) {
            case NEVER: {
                return 21;
            }
            case ALWAYS: {
                return 22;
            }
            case IF_NEEDED: {
                return 20;
            }
        }
        throw CodeAreaUtils.getInvalidTypeException((Enum)scrollBarVisibility);
    }

    public static int getHorizontalScrollBarPolicy(ScrollBarVisibility scrollBarVisibility) {
        switch (scrollBarVisibility) {
            case NEVER: {
                return 31;
            }
            case ALWAYS: {
                return 32;
            }
            case IF_NEEDED: {
                return 30;
            }
        }
        throw CodeAreaUtils.getInvalidTypeException((Enum)scrollBarVisibility);
    }

    public static boolean canPaste(Clipboard clipboard, DataFlavor binaryDataFlavor) {
        try {
            return clipboard.isDataFlavorAvailable(binaryDataFlavor) || clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }

    public static int getMetaMaskDown() {
        try {
            switch (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                case 2: {
                    return 128;
                }
                case 4: {
                    return 256;
                }
                case 1: {
                    return 64;
                }
                case 8: {
                    return 512;
                }
            }
            return 128;
        }
        catch (HeadlessException ex) {
            return 128;
        }
    }

    @Nonnull
    public static Clipboard getClipboard() {
        if (clipboard == null) {
            try {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException e) {
                clipboard = new Clipboard(FALLBACK_CLIPBOARD);
            }
        }
        return clipboard;
    }

    public static interface ClipboardData
    extends Transferable,
    ClipboardOwner {
        public void dispose();
    }

    @ParametersAreNonnullByDefault
    public static class CodeDataClipboardData
    implements ClipboardData {
        private final BinaryData data;
        private final DataFlavor binaryDataFlavor;
        private final CodeType codeType;
        private final CodeCharactersCase charactersCase;

        public CodeDataClipboardData(BinaryData data, DataFlavor binaryDataFlavor, CodeType codeType, CodeCharactersCase charactersCase) {
            this.data = data;
            this.binaryDataFlavor = binaryDataFlavor;
            this.codeType = codeType;
            this.charactersCase = charactersCase;
        }

        @Override
        @Nonnull
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.binaryDataFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.binaryDataFlavor) || flavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        @Nonnull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(this.binaryDataFlavor)) {
                return this.data;
            }
            int charsPerByte = this.codeType.getMaxDigitsForByte() + 1;
            int textLength = (int)(this.data.getDataSize() * (long)charsPerByte);
            if (textLength > 0) {
                --textLength;
            }
            char[] targetData = new char[textLength];
            Arrays.fill(targetData, ' ');
            int i = 0;
            while ((long)i < this.data.getDataSize()) {
                CodeAreaUtils.byteToCharsCode((byte)this.data.getByte((long)i), (CodeType)this.codeType, (char[])targetData, (int)(i * charsPerByte), (CodeCharactersCase)this.charactersCase);
                ++i;
            }
            return new String(targetData);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public void dispose() {
            this.data.dispose();
        }
    }

    @ParametersAreNonnullByDefault
    public static class BinaryDataClipboardData
    implements ClipboardData {
        private final BinaryData data;
        private final DataFlavor binedDataFlavor;
        private final DataFlavor binaryDataFlavor;
        @Nullable
        private final Charset charset;

        public BinaryDataClipboardData(BinaryData data, DataFlavor binedDataFlavor, @Nullable Charset charset) {
            this.data = data;
            this.binedDataFlavor = binedDataFlavor;
            this.binaryDataFlavor = null;
            this.charset = charset;
        }

        public BinaryDataClipboardData(BinaryData data, DataFlavor binedDataFlavor, @Nullable DataFlavor binaryDataFlavor, @Nullable Charset charset) {
            this.data = data;
            this.binedDataFlavor = binedDataFlavor;
            this.binaryDataFlavor = binaryDataFlavor;
            this.charset = charset;
        }

        public BinaryDataClipboardData(BinaryData data, DataFlavor binedDataFlavor) {
            this(data, binedDataFlavor, null);
        }

        @Override
        @Nonnull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray;
            if (this.binaryDataFlavor != null) {
                DataFlavor[] dataFlavorArray2 = new DataFlavor[3];
                dataFlavorArray2[0] = this.binedDataFlavor;
                dataFlavorArray2[1] = this.binaryDataFlavor;
                dataFlavorArray = dataFlavorArray2;
                dataFlavorArray2[2] = DataFlavor.stringFlavor;
            } else {
                DataFlavor[] dataFlavorArray3 = new DataFlavor[2];
                dataFlavorArray3[0] = this.binedDataFlavor;
                dataFlavorArray = dataFlavorArray3;
                dataFlavorArray3[1] = DataFlavor.stringFlavor;
            }
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.binedDataFlavor) || flavor.equals(this.binaryDataFlavor) || flavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        @Nonnull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(this.binedDataFlavor)) {
                return this.data;
            }
            if (flavor.equals(this.binaryDataFlavor)) {
                return this.data.getDataInputStream();
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                String result;
                try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                    this.data.saveToStream((OutputStream)byteArrayStream);
                    result = this.charset == null ? byteArrayStream.toString(CodeAreaSwingUtils.DEFAULT_ENCODING) : byteArrayStream.toString(this.charset.name());
                }
                return result;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public void dispose() {
            this.data.dispose();
        }
    }
}

