/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class UnsavedFilesPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(UnsavedFilesPanel.class);
    private List<FileHandler> fileHandlers;
    private Controller controller;
    private JButton cancelButton;
    private JButton discardAllButton;
    private JList<String> filesList;
    private JLabel filesListLabel;
    private JScrollPane filesListScrollPane;
    private JButton saveAllButton;
    private JButton saveButton;

    public UnsavedFilesPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.filesList.addListSelectionListener(e -> this.saveButton.setEnabled(this.filesList.getSelectedIndex() != -1));
    }

    public void assignGlobalKeys() {
        WindowUtils.assignGlobalKeyListener((Component)this, (JButton)this.cancelButton);
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void setUnsavedFiles(List<FileHandler> fileHandlers) {
        this.fileHandlers = fileHandlers;
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (FileHandler fileHandler : fileHandlers) {
            listModel.addElement(fileHandler.getTitle());
        }
        this.filesList.setModel(listModel);
        this.filesList.invalidate();
    }

    private void initComponents() {
        this.filesListLabel = new JLabel();
        this.filesListScrollPane = new JScrollPane();
        this.filesList = new JList();
        this.saveButton = new JButton();
        this.saveAllButton = new JButton();
        this.discardAllButton = new JButton();
        this.cancelButton = new JButton();
        this.setPreferredSize(new Dimension(400, 300));
        this.filesListLabel.setText(this.resourceBundle.getString("filesListLabel.text"));
        this.filesListScrollPane.setViewportView(this.filesList);
        this.saveButton.setText(this.resourceBundle.getString("saveButton.text"));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsavedFilesPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.saveAllButton.setText(this.resourceBundle.getString("saveAllButton.text"));
        this.saveAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsavedFilesPanel.this.saveAllButtonActionPerformed(evt);
            }
        });
        this.discardAllButton.setText(this.resourceBundle.getString("discardAllButton.text"));
        this.discardAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsavedFilesPanel.this.discardAllButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(this.resourceBundle.getString("cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnsavedFilesPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.filesListScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.discardAllButton, -1, -1, Short.MAX_VALUE).addComponent(this.saveButton, -1, -1, Short.MAX_VALUE).addComponent(this.saveAllButton, -1, -1, Short.MAX_VALUE).addComponent(this.cancelButton, -2, 104, -2))).addGroup(layout.createSequentialGroup().addComponent(this.filesListLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.filesListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filesListScrollPane, -1, 269, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.discardAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.controller != null) {
            int selectedIndex;
            FileHandler fileHandler;
            int[] selectedIndices = this.filesList.getSelectedIndices();
            int shift = 0;
            for (int i = 0; i < selectedIndices.length && this.controller.saveFile(fileHandler = this.fileHandlers.get((selectedIndex = selectedIndices[i]) - shift)); ++i) {
                DefaultListModel listModel = (DefaultListModel)this.filesList.getModel();
                listModel.remove(selectedIndex - shift);
                this.fileHandlers.remove(selectedIndex - shift);
                ++shift;
            }
            if (this.fileHandlers.isEmpty()) {
                this.controller.discardAll(this.fileHandlers);
            }
        }
    }

    private void saveAllButtonActionPerformed(ActionEvent evt) {
        if (this.controller != null) {
            FileHandler fileHandler;
            int shift = 0;
            int size = this.fileHandlers.size();
            for (int index = 0; index < size && this.controller.saveFile(fileHandler = this.fileHandlers.get(index - shift)); ++index) {
                DefaultListModel listModel = (DefaultListModel)this.filesList.getModel();
                listModel.remove(index - shift);
                this.fileHandlers.remove(index - shift);
                ++shift;
            }
            if (this.fileHandlers.isEmpty()) {
                this.controller.discardAll(this.fileHandlers);
            }
        }
    }

    private void discardAllButtonActionPerformed(ActionEvent evt) {
        if (this.controller != null) {
            this.controller.discardAll(this.fileHandlers);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.controller != null) {
            this.controller.cancel();
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new UnsavedFilesPanel());
    }

    @ParametersAreNonnullByDefault
    public static interface Controller {
        public boolean saveFile(FileHandler var1);

        public void discardAll(List<FileHandler> var1);

        public void cancel();
    }
}

