/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_command;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBParserState;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.core.parser.basic.wrapper.FixedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TailDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.stream.FinishableStream;
import org.exbin.xbup.core.stream.SeekableStream;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.parser_command.XBCommandBlock;
import org.exbin.xbup.parser_command.XBCommandReader;
import org.exbin.xbup.parser_command.XBReaderBlock;

@ParametersAreNonnullByDefault
public class XBReader
implements XBCommandReader,
XBPullProvider,
Closeable {
    private XBParserState parserState;
    private XBParserMode parserMode = XBParserMode.FULL;
    private FinishableStream dataWrapper;
    private final List<BlockPosition> pathPositions = new ArrayList<BlockPosition>();
    private InputStream inputStream;
    private long currentSourcePosition;
    private XBBlockDataMode currentBlockDataMode;
    private XBBlockTerminationMode currentBlockTerminationMode;
    private int attributePartSizeValue;
    private Integer dataPartSizeValue;
    private Integer currentAttributeIndex;
    private int currentChildIndex;
    private XBCommandBlock activeBlock = null;

    public XBReader() {
        this.resetParser();
    }

    public XBReader(InputStream stream) {
        this.openStream(stream);
    }

    public XBReader(InputStream stream, XBParserMode parserMode) {
        this.parserMode = parserMode;
        this.openStream(stream);
    }

    @Override
    public void open(InputStream stream) throws IOException {
        this.openStream(stream);
    }

    private void openStream(InputStream inputStream) {
        if (!(inputStream instanceof SeekableStream)) {
            throw new IllegalArgumentException("XBReader only supports seekable streams");
        }
        this.inputStream = inputStream;
        this.resetParser();
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    private void resetParser() {
        this.pathPositions.clear();
        this.currentSourcePosition = 0L;
        this.attributePartSizeValue = 0;
        this.dataPartSizeValue = null;
        this.currentChildIndex = 0;
        this.parserState = XBParserState.START;
        this.activeBlock = null;
        this.resetBlockState();
    }

    @Override
    public void resetXB() throws IOException {
        this.resetParser();
        if (this.inputStream != null) {
            ((SeekableStream)this.inputStream).seek(this.currentSourcePosition);
        }
    }

    private void resetBlock() throws IOException {
        if (this.pathPositions.isEmpty()) {
            this.currentSourcePosition = 0L;
            this.parserState = XBParserState.START;
        } else {
            BlockPosition topPosition = this.pathPositions.get(this.pathPositions.size() - 1);
            this.revertStatus(this.currentSourcePosition - topPosition.streamPosition);
            this.currentSourcePosition = topPosition.streamPosition;
            this.pathPositions.remove(this.pathPositions.size() - 1);
            this.currentChildIndex = topPosition.blockIndex;
            this.parserState = XBParserState.BLOCK_BEGIN;
        }
        this.resetBlockState();
        if (this.inputStream != null) {
            ((SeekableStream)this.inputStream).seek(this.currentSourcePosition);
        }
    }

    private void resetBlockState() {
        this.currentBlockDataMode = null;
        this.currentBlockTerminationMode = null;
        this.currentAttributeIndex = null;
        this.dataWrapper = null;
    }

    @Nonnull
    public Optional<XBBlock> getRootBlock() {
        return this.getBlock(new long[0]);
    }

    @Override
    @Nonnull
    public Optional<XBBlock> getBlock(long[] blockPath) {
        return Optional.of(new XBReaderBlock(this, blockPath));
    }

    @Nullable
    public XBCommandBlock getActiveBlock() {
        return this.activeBlock;
    }

    public void setActiveBlock(XBCommandBlock activeBlock) {
        this.activeBlock = activeBlock;
    }

    @Nonnull
    public Optional<InputStream> getTailData() {
        try {
            if (this.parserState == XBParserState.EOF) {
                this.resetXB();
            }
            while (!this.isFinishedXB()) {
                XBToken token = this.pullXBToken();
                if (this.parserState != XBParserState.TAIL_DATA) continue;
                return Optional.of(((XBDataToken)token).getData());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public long getTailDataSize() {
        try {
            Optional<InputStream> tailData = this.getTailData();
            if (tailData.isPresent()) {
                InputStream stream = tailData.get();
                if (stream instanceof TailDataInputStreamWrapper) {
                    return stream.available();
                }
                return stream.available();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    public XBBlock getBlock() {
        return this.getBlock(this.getCurrentBlockPath()).get();
    }

    public XBBlockDataMode getBlockDataMode() throws XBProcessingException, IOException {
        if (this.parserState == XBParserState.BLOCK_BEGIN || this.parserState == XBParserState.START) {
            this.resetBlock();
            this.pullXBToken();
        }
        return this.currentBlockDataMode;
    }

    public XBBlockTerminationMode getBlockTerminationMode() throws XBProcessingException, IOException {
        if (this.parserState == XBParserState.BLOCK_BEGIN || this.parserState == XBParserState.START) {
            this.resetBlock();
            this.pullXBToken();
        }
        return this.currentBlockTerminationMode;
    }

    public XBAttribute getBlockAttribute(int attributeIndex) throws XBProcessingException, IOException {
        if (this.currentAttributeIndex == null || this.currentAttributeIndex >= attributeIndex) {
            this.resetBlock();
            this.pullXBToken();
        }
        while (this.currentAttributeIndex != null && this.currentAttributeIndex < attributeIndex) {
            this.pullXBToken();
        }
        if (this.currentAttributeIndex != null && this.currentAttributeIndex == attributeIndex) {
            return ((XBAttributeToken)this.pullXBToken()).getAttribute();
        }
        return null;
    }

    public int getBlockAttributesCount() throws XBProcessingException, IOException {
        int attributesCount = 0;
        if (this.currentAttributeIndex != null) {
            attributesCount = this.currentAttributeIndex;
        } else {
            this.resetBlock();
            this.pullXBToken();
        }
        while (this.parserState == XBParserState.ATTRIBUTE_PART) {
            ++attributesCount;
            this.pullXBToken();
        }
        return attributesCount;
    }

    @Nonnull
    public InputStream getBlockData() throws XBProcessingException, IOException {
        if (this.parserState != XBParserState.BLOCK_BEGIN) {
            this.resetBlock();
            this.pullXBToken();
        }
        if (this.parserState == XBParserState.DATA_PART) {
            return ((XBDataToken)this.pullXBToken()).getData();
        }
        throw new IllegalStateException("Unexpected parser state" + this.parserState.toString());
    }

    public int getBlockChildrenCount() throws XBProcessingException, IOException {
        XBToken token;
        this.resetBlock();
        this.pullXBToken();
        if (this.currentBlockDataMode == XBBlockDataMode.DATA_BLOCK) {
            return 0;
        }
        int subDepth = 1;
        int childCount = 0;
        do {
            if ((token = this.pullXBToken()).getTokenType() == XBTokenType.BEGIN) {
                if (subDepth == 1) {
                    ++childCount;
                }
                ++subDepth;
                continue;
            }
            if (token.getTokenType() != XBTokenType.END) continue;
            --subDepth;
        } while (subDepth > 0 || token.getTokenType() != XBTokenType.END);
        return childCount;
    }

    boolean hasBlockChildAt(int childIndex) throws XBProcessingException, IOException {
        return childIndex < this.getBlockChildrenCount();
    }

    public long[] getCurrentBlockPath() {
        long[] currentPath = new long[this.pathPositions.size() - 1];
        for (int i = 1; i < currentPath.length; ++i) {
            currentPath[i - 1] = this.pathPositions.get((int)i).blockIndex;
        }
        return currentPath;
    }

    public long getCurrentBlockStreamPosition() {
        return this.pathPositions.isEmpty() ? 0L : this.pathPositions.get((int)(this.pathPositions.size() - 1)).streamPosition;
    }

    public int getLevel() {
        return this.pathPositions.size();
    }

    public void skipXB(long tokenCount) throws XBProcessingException, IOException {
        for (long i = 0L; i < tokenCount; ++i) {
            this.pullXBToken();
        }
    }

    public void skipChildXB(long childBlocksCount) throws XBProcessingException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void skipAttributesXB(long attributesCount) throws XBProcessingException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBToken pullXBToken() throws XBProcessingException, IOException {
        if (this.dataWrapper != null) {
            this.dataWrapper.finish();
            this.addProcessedSize((int)this.dataWrapper.getLength());
            this.dataWrapper = null;
        }
        if (this.parserState == XBParserState.START) {
            if (this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_HEAD) {
                this.currentSourcePosition += (long)XBHead.checkXBUPHead((InputStream)this.inputStream);
            }
            this.parserState = XBParserState.BLOCK_BEGIN;
        }
        switch (this.parserState) {
            case BLOCK_BEGIN: {
                UBNat32 attributePartSize = new UBNat32();
                int headSize = attributePartSize.fromStreamUB(this.inputStream);
                if (attributePartSize.getLong() == 0L) {
                    if (this.pathPositions.isEmpty() || this.pathPositions.get((int)(this.pathPositions.size() - 1)).sizeLimit != null) {
                        throw new XBParsingException("Unexpected terminator", XBProcessingExceptionType.UNEXPECTED_TERMINATOR);
                    }
                    this.addProcessedSize(headSize);
                    this.parserState = XBParserState.BLOCK_END;
                } else {
                    this.attributePartSizeValue = attributePartSize.getInt();
                    UBENat32 dataPartSize = new UBENat32();
                    int dataPartSizeLength = dataPartSize.fromStreamUB(this.inputStream);
                    this.dataPartSizeValue = dataPartSize.isInfinity() ? null : Integer.valueOf(dataPartSize.getInt());
                    this.pathDown();
                    this.addProcessedSize(headSize + dataPartSizeLength);
                    XBBlockTerminationMode xBBlockTerminationMode = this.currentBlockTerminationMode = dataPartSize.isInfinity() ? XBBlockTerminationMode.TERMINATED_BY_ZERO : XBBlockTerminationMode.SIZE_SPECIFIED;
                    if (this.attributePartSizeValue == dataPartSizeLength) {
                        this.currentBlockDataMode = XBBlockDataMode.DATA_BLOCK;
                        this.parserState = XBParserState.DATA_PART;
                    } else {
                        this.currentBlockDataMode = XBBlockDataMode.NODE_BLOCK;
                        this.attributePartSizeValue -= dataPartSizeLength;
                        this.currentAttributeIndex = 0;
                        this.parserState = this.attributePartSizeValue > 0 ? XBParserState.ATTRIBUTE_PART : (this.dataPartSizeValue == null || this.dataPartSizeValue > 0 ? XBParserState.BLOCK_BEGIN : XBParserState.BLOCK_END);
                    }
                    return XBBeginToken.create((XBBlockTerminationMode)(this.dataPartSizeValue == null ? XBBlockTerminationMode.TERMINATED_BY_ZERO : XBBlockTerminationMode.SIZE_SPECIFIED));
                }
            }
            case TAIL_DATA: 
            case BLOCK_END: {
                if (this.pathPositions.size() == 1) {
                    if (this.parserState == XBParserState.BLOCK_END && this.parserMode != XBParserMode.SINGLE_BLOCK && this.parserMode != XBParserMode.SKIP_TAIL) {
                        this.parserState = XBParserState.TAIL_DATA;
                        TailDataInputStreamWrapper wrapper = new TailDataInputStreamWrapper(this.inputStream);
                        if (wrapper.available() > 0) {
                            return XBDataToken.create((InputStream)wrapper);
                        }
                    }
                    this.parserState = XBParserState.EOF;
                } else {
                    this.pathUp();
                    if (this.pathPositions.get((int)(this.pathPositions.size() - 1)).sizeLimit == null || this.pathPositions.get((int)(this.pathPositions.size() - 1)).sizeLimit > 0) {
                        this.parserState = XBParserState.BLOCK_BEGIN;
                    }
                }
                return XBEndToken.create();
            }
            case ATTRIBUTE_PART: {
                UBNat32 attribute = new UBNat32();
                int attributeLength = attribute.fromStreamUB(this.inputStream);
                if (attributeLength > this.attributePartSizeValue) {
                    throw new XBParsingException("Attribute overflow", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
                }
                this.addProcessedSize(attributeLength);
                this.attributePartSizeValue -= attributeLength;
                if (this.attributePartSizeValue == 0) {
                    this.parserState = this.dataPartSizeValue == null || this.dataPartSizeValue > 0 ? XBParserState.BLOCK_BEGIN : XBParserState.BLOCK_END;
                    this.currentAttributeIndex = null;
                } else {
                    Integer n = this.currentAttributeIndex;
                    Integer n2 = this.currentAttributeIndex = Integer.valueOf(this.currentAttributeIndex + 1);
                }
                return XBAttributeToken.create((XBAttribute)attribute);
            }
            case DATA_PART: {
                this.dataWrapper = this.dataPartSizeValue == null ? new TerminatedDataInputStreamWrapper(this.inputStream) : new FixedDataInputStreamWrapper(this.inputStream, this.dataPartSizeValue.intValue());
                this.parserState = XBParserState.BLOCK_END;
                return XBDataToken.create((InputStream)((InputStream)this.dataWrapper));
            }
            case EOF: {
                throw new XBParsingException("Reading After End", XBProcessingExceptionType.READING_AFTER_END);
            }
        }
        throw new XBParsingException("Unexpected pull item type", XBProcessingExceptionType.UNKNOWN);
    }

    public boolean isFinishedXB() {
        return this.parserState == XBParserState.EOF;
    }

    public XBParserState getParseMode() {
        return this.parserState;
    }

    public long getDocumentSize() {
        return ((SeekableStream)this.inputStream).getStreamSize();
    }

    public void seekBlock(XBCommandBlock targetBlock) throws XBProcessingException, IOException {
        if (this.activeBlock != targetBlock) {
            this.seekBlockPath(targetBlock.getBlockPath());
            this.activeBlock = targetBlock;
        }
    }

    public void seekBlockPath(long[] blockPath) throws XBProcessingException, IOException {
        int depthMatch;
        if (blockPath == null) {
            throw new NullPointerException("BlockPath cannot be null.");
        }
        if (blockPath.length == 0) {
            this.resetXB();
            return;
        }
        for (depthMatch = 0; blockPath.length > depthMatch && this.pathPositions.size() > depthMatch + 1; ++depthMatch) {
            if ((long)this.pathPositions.get((int)(depthMatch + 1)).blockIndex == blockPath[depthMatch]) {
                continue;
            }
            if (this.pathPositions.size() != depthMatch || (long)this.pathPositions.get((int)(depthMatch + 1)).blockIndex >= blockPath[depthMatch]) break;
            ++depthMatch;
            break;
        }
        if (depthMatch == 0) {
            this.resetXB();
        } else {
            for (int i = this.pathPositions.size() - 1; i >= depthMatch; --i) {
                this.pathPositions.remove(i);
            }
            this.resetBlock();
        }
        this.activeBlock = null;
        do {
            XBToken token;
            if ((token = this.pullXBToken()).getTokenType() != XBTokenType.BEGIN || !this.pathMatch(blockPath)) continue;
            return;
        } while (this.pathPositions.size() >= depthMatch);
        throw new XBProcessingException("Unable to seek requested block path", XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    private boolean pathMatch(long[] blockPath) {
        if (this.pathPositions.size() != blockPath.length + 1) {
            return false;
        }
        for (int i = 1; i < this.pathPositions.size(); ++i) {
            if ((long)this.pathPositions.get((int)i).blockIndex == blockPath[i - 1]) continue;
            return false;
        }
        return true;
    }

    private void addProcessedSize(int value) {
        this.shrinkStatus(value);
        this.currentSourcePosition += (long)value;
    }

    private void shrinkStatus(int value) throws XBParsingException {
        for (int index = 0; index < this.pathPositions.size() - 1; ++index) {
            BlockPosition blockPosition = this.pathPositions.get(index);
            Integer limit = blockPosition.sizeLimit;
            if (limit == null) continue;
            if (limit < value) {
                throw new XBParsingException("Block overflow", XBProcessingExceptionType.BLOCK_OVERFLOW);
            }
            blockPosition.sizeLimit = limit - value;
        }
    }

    private void revertStatus(long value) {
        for (BlockPosition blockPosition : this.pathPositions) {
            Integer limit = blockPosition.sizeLimit;
            if (limit == null) continue;
            blockPosition.sizeLimit = (int)((long)limit.intValue() + value);
        }
    }

    private void pathDown() {
        this.pathPositions.add(new BlockPosition(this.currentSourcePosition, this.currentChildIndex, this.dataPartSizeValue));
        this.resetBlockState();
        this.currentChildIndex = 0;
        this.activeBlock = null;
    }

    private void pathUp() {
        BlockPosition removedPosition = this.pathPositions.remove(this.pathPositions.size() - 1);
        if (this.pathPositions.size() > 0) {
            this.currentChildIndex = removedPosition.blockIndex + 1;
        }
        this.activeBlock = null;
    }

    @ParametersAreNonnullByDefault
    private static class BlockPosition {
        long streamPosition;
        int blockIndex;
        Integer sizeLimit;

        BlockPosition(long streamPosition, int blockIndex, Integer sizeLimit) {
            this.streamPosition = streamPosition;
            this.blockIndex = blockIndex;
            this.sizeLimit = sizeLimit;
        }
    }
}

