/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractTreeLocation;
import bibliothek.gui.dock.common.location.CExternalizedLocation;
import bibliothek.gui.dock.common.location.CFlapIndexLocation;
import bibliothek.gui.dock.common.location.CFlapLocation;
import bibliothek.gui.dock.common.location.CLocationExpandStrategy;
import bibliothek.gui.dock.common.location.CMaximalExternalizedLocation;
import bibliothek.gui.dock.common.location.CRectangleLocation;
import bibliothek.gui.dock.common.location.CSplitLocation;
import bibliothek.gui.dock.common.location.CStackLocation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import java.util.List;

public class DefaultExpandStrategy
implements CLocationExpandStrategy {
    public static final Path STRATEGY_EXTENSION = new Path("dock.expandStrategy");
    public static final String EXTENSION_PARAM = "strategy";
    private List<CLocationExpandStrategy> extensions;

    public DefaultExpandStrategy(DockController controller) {
        this.extensions = controller.getExtensions().load(new ExtensionName(STRATEGY_EXTENSION, CLocationExpandStrategy.class, EXTENSION_PARAM, (Object)this));
    }

    public CLocation expand(CLocation location, DockableProperty property) {
        for (CLocationExpandStrategy extension : this.extensions) {
            CLocation result = extension.expand(location, property);
            if (result == null) continue;
            return result;
        }
        if (property instanceof FlapDockProperty) {
            return this.expand(location, (FlapDockProperty)property);
        }
        if (property instanceof ScreenDockProperty) {
            return this.expand(location, (ScreenDockProperty)property);
        }
        if (property instanceof SplitDockFullScreenProperty) {
            return this.expand(location, (SplitDockFullScreenProperty)property);
        }
        if (property instanceof SplitDockPathProperty) {
            return this.expand(location, (SplitDockPathProperty)property);
        }
        if (property instanceof SplitDockPlaceholderProperty) {
            return this.expand(location, (SplitDockPlaceholderProperty)property);
        }
        if (property instanceof SplitDockProperty) {
            return this.expand(location, (SplitDockProperty)property);
        }
        if (property instanceof StackDockProperty) {
            return this.expand(location, (StackDockProperty)property);
        }
        return null;
    }

    protected CLocation expand(CLocation location, FlapDockProperty property) {
        if (!(location instanceof CFlapLocation)) {
            location = new CFlapLocation(location);
        }
        return new CFlapIndexLocation((CFlapLocation)location, property.getIndex());
    }

    protected CLocation expand(CLocation location, ScreenDockProperty property) {
        if (property.isFullscreen()) {
            return new CMaximalExternalizedLocation(location, property.getX(), property.getY(), property.getWidth(), property.getHeight());
        }
        return new CExternalizedLocation(location, property.getX(), property.getY(), property.getWidth(), property.getHeight());
    }

    protected CLocation expand(CLocation location, SplitDockFullScreenProperty property) {
        return null;
    }

    protected CLocation expand(CLocation location, SplitDockPathProperty property) {
        if (!(location instanceof CSplitLocation)) {
            location = new CSplitLocation(location);
        }
        CSplitLocation split = (CSplitLocation)location;
        if (property.size() > 0) {
            AbstractTreeLocation tree = null;
            SplitDockPathProperty.Node node = property.getNode(0);
            switch (node.getLocation()) {
                case BOTTOM: {
                    tree = split.south(node.getSize(), node.getId());
                    break;
                }
                case LEFT: {
                    tree = split.west(node.getSize(), node.getId());
                    break;
                }
                case RIGHT: {
                    tree = split.east(node.getSize(), node.getId());
                    break;
                }
                case TOP: {
                    tree = split.north(node.getSize(), node.getId());
                }
            }
            int n = property.size();
            block12: for (int i = 1; i < n; ++i) {
                node = property.getNode(i);
                switch (node.getLocation()) {
                    case BOTTOM: {
                        tree = tree.south(node.getSize(), node.getId());
                        continue block12;
                    }
                    case LEFT: {
                        tree = tree.west(node.getSize(), node.getId());
                        continue block12;
                    }
                    case RIGHT: {
                        tree = tree.east(node.getSize(), node.getId());
                        continue block12;
                    }
                    case TOP: {
                        tree = tree.north(node.getSize(), node.getId());
                    }
                }
            }
            location = tree.leaf(property.getLeafId());
        } else {
            location = split.rectangle(0.0, 0.0, 1.0, 1.0);
        }
        return location;
    }

    protected CLocation expand(CLocation location, SplitDockPlaceholderProperty property) {
        return this.expand(location, property.getBackup());
    }

    protected CLocation expand(CLocation location, SplitDockProperty property) {
        if (!(location instanceof CSplitLocation)) {
            location = new CSplitLocation(location);
        }
        return new CRectangleLocation((CSplitLocation)location, property.getX(), property.getY(), property.getWidth(), property.getHeight());
    }

    protected CLocation expand(CLocation location, StackDockProperty property) {
        return new CStackLocation(location, property.getIndex());
    }
}

