/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.operation.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.operation.Operation;
import org.exbin.xbup.operation.XBTDocOperation;
import org.exbin.xbup.operation.basic.XBBasicOperationType;

@ParametersAreNonnullByDefault
public class XBTTailDataOperation
extends XBTDocOperation {
    public XBTTailDataOperation(XBTEditableDocument document, XBData data) {
        super(document);
        OutputStream dataOutputStream = data.getDataOutputStream();
        XBPSerialWriter writer = new XBPSerialWriter(dataOutputStream);
        Serializator serializator = new Serializator(data);
        writer.write((XBSerializable)serializator);
    }

    @Override
    @Nonnull
    public XBBasicOperationType getBasicType() {
        return XBBasicOperationType.MODIFY_BLOCK;
    }

    @Override
    public void execute() throws Exception {
        this.execute(false);
    }

    @Override
    @Nonnull
    public Optional<Operation> executeWithUndo() throws Exception {
        return this.execute(true);
    }

    @Nonnull
    private Optional<Operation> execute(boolean withUndo) {
        XBTTailDataOperation undoOperation = null;
        try {
            if (withUndo) {
                XBData oldData = new XBData();
                Optional tailDataStream = this.document.getTailData();
                if (tailDataStream.isPresent()) {
                    oldData.loadFromStream((InputStream)tailDataStream.get());
                }
                undoOperation = new XBTTailDataOperation(this.document, oldData);
            }
            XBData tailData = new XBData();
            InputStream dataInputStream = this.getData().getDataInputStream();
            XBPSerialReader reader = new XBPSerialReader(dataInputStream);
            Serializator serial = new Serializator(tailData);
            reader.read((XBSerializable)serial);
            this.document.setTailData(tailData.getDataInputStream());
        }
        catch (IOException | XBProcessingException ex) {
            throw new IllegalStateException("Unable to process data", ex);
        }
        return Optional.ofNullable(undoOperation);
    }

    @ParametersAreNonnullByDefault
    private class Serializator
    implements XBPSequenceSerializable {
        private final XBData data;

        private Serializator(XBData data) {
            this.data = data;
        }

        public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
            serializationHandler.begin();
            serializationHandler.matchType();
            serializationHandler.consist((XBSerializable)new XBPSequenceSerializable(){

                public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
                    serializationHandler.begin();
                    if (serializationHandler.getSerializationMode() == XBSerializationMode.PULL) {
                        if (serializationHandler.pullIfEmptyData()) {
                            Serializator.this.data.clear();
                        } else {
                            Serializator.this.data.loadFromStream(serializationHandler.pullData());
                        }
                    } else {
                        serializationHandler.putData(Serializator.this.data.getDataInputStream());
                    }
                    serializationHandler.end();
                }
            });
            serializationHandler.end();
        }
    }
}

