/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.operation.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventReader;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.convert.XBEventListenerToListener;
import org.exbin.xbup.core.parser.token.event.convert.XBListenerToEventListener;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.operation.Operation;
import org.exbin.xbup.operation.XBTDocOperation;
import org.exbin.xbup.operation.basic.XBBasicOperationType;
import org.exbin.xbup.operation.basic.XBTDeleteBlockOperation;
import org.exbin.xbup.parser_tree.XBTBlockToXBBlock;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.parser_tree.XBTreeReader;
import org.exbin.xbup.parser_tree.XBTreeWriter;

@ParametersAreNonnullByDefault
public class XBTModifyBlockOperation
extends XBTDocOperation {
    public XBTModifyBlockOperation(XBTEditableDocument document, long position, XBTEditableBlock newNode) {
        super(document);
        OutputStream dataOutputStream = this.data.getDataOutputStream();
        XBPSerialWriter writer = new XBPSerialWriter(dataOutputStream);
        Serializator serializator = new Serializator(position, newNode);
        writer.write((XBSerializable)serializator);
    }

    @Override
    public XBBasicOperationType getBasicType() {
        return XBBasicOperationType.MODIFY_BLOCK;
    }

    @Override
    public void execute() throws Exception {
        this.execute(false);
    }

    @Override
    @Nonnull
    public Optional<Operation> executeWithUndo() throws Exception {
        return this.execute(true);
    }

    @Nonnull
    private Optional<Operation> execute(boolean withUndo) {
        InputStream dataInputStream = this.getData().getDataInputStream();
        XBPSerialReader reader = new XBPSerialReader(dataInputStream);
        Serializator serial = new Serializator();
        try {
            reader.read((XBSerializable)serial);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBTDeleteBlockOperation.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalStateException("Unable to process data");
        }
        XBTEditableBlock node = (XBTEditableBlock)this.document.findBlockByIndex(serial.position).get();
        Optional optParentNode = node.getParentBlock();
        if (!optParentNode.isPresent()) {
            this.document.setRootBlock((XBTBlock)serial.newNode);
        } else {
            XBTBlock child;
            XBTEditableBlock parentNode = (XBTEditableBlock)optParentNode.get();
            int childPosition = 0;
            while ((child = parentNode.getChildAt(childPosition)) != node && ++childPosition < parentNode.getChildrenCount()) {
            }
            if (childPosition == parentNode.getChildrenCount()) {
                throw new IllegalStateException("Unexpected missing child block");
            }
            parentNode.setChildAt((XBTBlock)serial.newNode, childPosition);
            serial.newNode.setParent((XBTBlock)parentNode);
        }
        if (withUndo) {
            XBTModifyBlockOperation undoOperation = new XBTModifyBlockOperation(this.document, serial.position, node);
            return Optional.of(undoOperation);
        }
        return Optional.empty();
    }

    @ParametersAreNonnullByDefault
    private class Serializator
    implements XBPSequenceSerializable {
        private long position;
        private XBTEditableBlock newNode;

        private Serializator() {
        }

        public Serializator(long position, XBTEditableBlock newNode) {
            this.position = position;
            this.newNode = newNode;
        }

        public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
            serializationHandler.begin();
            serializationHandler.matchType();
            if (serializationHandler.getSerializationMode() == XBSerializationMode.PULL) {
                this.position = serializationHandler.pullLongAttribute();
                this.newNode = new XBTTreeNode();
                serializationHandler.consist((XBSerializable)new XBPSequenceSerializable(){

                    public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
                        serializationHandler.begin();
                        XBData data = new XBData();
                        data.loadFromStream(serializationHandler.pullData());
                        serializationHandler.end();
                        XBTreeReader treeReader = new XBTreeReader((XBEditableBlock)new XBTBlockToXBBlock((XBTBlock)Serializator.this.newNode));
                        XBEventReader reader = new XBEventReader(data.getDataInputStream(), XBParserMode.SKIP_TAIL);
                        reader.attachXBEventListener((XBEventListener)new XBListenerToEventListener((XBListener)treeReader));
                        reader.read();
                        reader.close();
                    }
                });
            } else {
                serializationHandler.putAttribute(this.position);
                serializationHandler.consist((XBSerializable)new XBPSequenceSerializable(){

                    public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
                        XBData data = new XBData();
                        XBTreeWriter treeWriter = new XBTreeWriter((XBBlock)new XBTBlockToXBBlock((XBTBlock)Serializator.this.newNode));
                        XBEventWriter writer = new XBEventWriter(data.getDataOutputStream());
                        treeWriter.attachXBListener((XBListener)new XBEventListenerToListener((XBEventListener)writer));
                        serializationHandler.begin();
                        serializationHandler.putData(data.getDataInputStream());
                        serializationHandler.end();
                    }
                });
            }
            serializationHandler.end();
        }
    }
}

