/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.gui.TextGoToPanel;
import org.exbin.framework.editor.text.gui.TextPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;

@ParametersAreNonnullByDefault
public class GoToLineAction
extends AbstractAction {
    public static final String ACTION_ID = "goToLineAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, ActionUtils.getMetaMask()));
        this.putValue("dialogMode", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        JComponent component = ((FileHandler)activeFile.get()).getComponent();
        if (component instanceof TextPanel) {
            TextPanel activePanel = (TextPanel)component;
            TextGoToPanel goToPanel = new TextGoToPanel();
            goToPanel.initFocus();
            goToPanel.setMaxLine(activePanel.getLineCount());
            goToPanel.setCharPos(1);
            DefaultControlPanel controlPanel = new DefaultControlPanel(goToPanel.getResourceBundle());
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)goToPanel, (JPanel)controlPanel);
            WindowUtils.addHeaderPanel((Window)dialog.getWindow(), goToPanel.getClass(), (ResourceBundle)goToPanel.getResourceBundle());
            frameModule.setDialogTitle(dialog, goToPanel.getResourceBundle());
            controlPanel.setHandler(actionType -> {
                if (actionType == DefaultControlHandler.ControlActionType.OK) {
                    activePanel.gotoLine(goToPanel.getLine());
                    activePanel.gotoRelative(goToPanel.getCharPos());
                }
                dialog.close();
                dialog.dispose();
            });
            dialog.showCentered((Component)frameModule.getFrame());
        }
    }
}

