/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.editor.text.TextEditor;
import org.exbin.framework.editor.text.TextFontApi;
import org.exbin.framework.editor.text.gui.TextPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileType;
import org.exbin.xbup.core.block.declaration.XBDeclaration;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.local.XBLFormatDecl;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.XBPCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.convert.XBTTypeUndeclaringFilter;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTEventListenerToListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTListenerToEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTToXBEventConvertor;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBPullReader;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullTypeDeclaringFilter;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullConvertor;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.type.XBEncodingText;

@ParametersAreNonnullByDefault
public class TextFileHandler
implements FileHandler,
TextFontApi {
    private final TextPanel textPanel = new TextPanel();
    private URI fileUri = null;
    private String title;
    private FileType fileType = null;

    public int getId() {
        return -1;
    }

    @Nonnull
    public TextPanel getComponent() {
        return this.textPanel;
    }

    public void loadFromFile(URI fileUri, @Nullable FileType fileType) {
        File file = new File(fileUri);
        switch (fileType.getFileTypeId()) {
            case "XBTextEditor.XBTFileType": {
                try {
                    XBPCatalog catalog = new XBPCatalog();
                    catalog.addFormatDecl(this.getContextFormatDecl());
                    XBLFormatDecl formatDecl = new XBLFormatDecl(XBEncodingText.XBUP_FORMATREV_CATALOGPATH);
                    XBEncodingText encodingText = new XBEncodingText();
                    XBDeclaration declaration = new XBDeclaration((XBFormatDecl)formatDecl, (XBSerializable)encodingText);
                    XBTPullTypeDeclaringFilter typeProcessing = new XBTPullTypeDeclaringFilter((XBCatalog)catalog);
                    typeProcessing.attachXBTPullProvider((XBTPullProvider)new XBToXBTPullConvertor((XBPullProvider)new XBPullReader((InputStream)new FileInputStream(file))));
                    XBPSerialReader reader = new XBPSerialReader((XBTPullProvider)typeProcessing);
                    reader.read((XBSerializable)declaration);
                    this.textPanel.changeCharset(encodingText.getCharset());
                    this.textPanel.setText(encodingText.getValue());
                    this.fileUri = fileUri;
                }
                catch (IOException | XBProcessingException ex) {
                    Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case "XBTextEditor.TXTFileType": {
                try {
                    int gotChars;
                    FileInputStream fileStream = new FileInputStream(file);
                    char[] buffer = new char[32];
                    StringBuilder data = new StringBuilder();
                    BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)fileStream, this.textPanel.getCharset()));
                    while ((gotChars = rdr.read(buffer)) != -1) {
                        data.append(buffer, 0, gotChars);
                    }
                    this.textPanel.setText(data.toString());
                    this.fileUri = fileUri;
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.textPanel.setModified(false);
    }

    public void saveFile() {
        this.saveToFile(this.fileUri, this.fileType);
    }

    /*
     * Unable to fully structure code
     */
    public void saveToFile(URI fileUri, FileType fileType) {
        file = new File(fileUri);
        var4_4 = fileType.getFileTypeId();
        var5_5 = -1;
        switch (var4_4.hashCode()) {
            case -1946312650: {
                if (!var4_4.equals("XBTextEditor.XBTFileType")) break;
                var5_5 = 0;
                break;
            }
            case 918195676: {
                if (!var4_4.equals("XBTextEditor.TXTFileType")) break;
                var5_5 = 2;
            }
        }
        switch (var5_5) {
            case 0: {
                try {
                    encodingString = new XBEncodingText();
                    encodingString.setValue(this.textPanel.getText());
                    encodingString.setCharset(this.textPanel.getCharset());
                    output = new FileOutputStream(file);
                    var8_12 = null;
                    catalog = new XBPCatalog();
                    catalog.addFormatDecl(this.getContextFormatDecl());
                    formatDecl = new XBLFormatDecl(XBEncodingText.XBUP_FORMATREV_CATALOGPATH);
                    declaration = new XBDeclaration((XBFormatDecl)formatDecl, (XBSerializable)encodingString);
                    declaration.realignReservation((XBCatalog)catalog);
                    typeProcessing = new XBTTypeUndeclaringFilter((XBCatalog)catalog);
                    typeProcessing.attachXBTListener((XBTListener)new XBTEventListenerToListener((XBTEventListener)new XBTToXBEventConvertor((XBEventListener)new XBEventWriter((OutputStream)output))));
                    writer = new XBPSerialWriter((XBTEventListener)new XBTListenerToEventListener((XBTListener)typeProcessing));
                    writer.write((XBSerializable)declaration);
                    this.fileUri = fileUri;
                    if (output == null) break;
                    if (var8_12 == null) ** GOTO lbl39
                    try {
                        output.close();
                    }
                    catch (Throwable catalog) {
                        var8_12.addSuppressed(catalog);
                    }
                    break;
lbl39:
                    // 1 sources

                    output.close();
                    ** break;
                    catch (Throwable catalog) {
                        try {
                            var8_12 = catalog;
                            throw catalog;
                        }
                        catch (Throwable var14_30) {
                            if (output != null) {
                                if (var8_12 != null) {
                                    try {
                                        output.close();
                                    }
                                    catch (Throwable var15_31) {
                                        var8_12.addSuppressed(var15_31);
                                    }
                                } else {
                                    output.close();
                                }
                            }
                            throw var14_30;
lbl56:
                            // 1 sources

                        }
                    }
                }
                catch (IOException | XBProcessingException ex) {
                    Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                try {
                    output = new FileOutputStream(file);
                    var7_11 = null;
                    text = this.textPanel.getText();
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, this.textPanel.getCharset()));
                    var10_21 = null;
                    try {
                        fileLength = text.length();
                        for (offset = 0; offset < fileLength; offset += length) {
                            length = Math.min(1024, fileLength - offset);
                            writer.write(text, offset, length);
                        }
                        this.fileUri = fileUri;
                    }
                    catch (Throwable var11_25) {
                        var10_21 = var11_25;
                        throw var11_25;
                    }
                    finally {
                        if (writer != null) {
                            if (var10_21 != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable var11_24) {
                                    var10_21.addSuppressed(var11_24);
                                }
                            } else {
                                writer.close();
                            }
                        }
                    }
                    if (output == null) break;
                    if (var7_11 == null) ** GOTO lbl98
                    try {
                        output.close();
                    }
                    catch (Throwable var8_14) {
                        var7_11.addSuppressed(var8_14);
                    }
                    break;
lbl98:
                    // 1 sources

                    output.close();
                    ** break;
                    catch (Throwable var8_15) {
                        try {
                            var7_11 = var8_15;
                            throw var8_15;
                        }
                        catch (Throwable var18_34) {
                            if (output != null) {
                                if (var7_11 != null) {
                                    try {
                                        output.close();
                                    }
                                    catch (Throwable var19_35) {
                                        var7_11.addSuppressed(var19_35);
                                    }
                                } else {
                                    output.close();
                                }
                            }
                            throw var18_34;
lbl115:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(TextEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.textPanel.setModified(false);
    }

    @Nonnull
    public Optional<URI> getFileUri() {
        return Optional.ofNullable(this.fileUri);
    }

    @Nonnull
    public String getTitle() {
        if (this.fileUri != null) {
            String path = this.fileUri.getPath();
            int lastSegment = path.lastIndexOf("/");
            String fileName = lastSegment < 0 ? path : path.substring(lastSegment + 1);
            return fileName == null ? "" : fileName;
        }
        return this.title == null ? "" : this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nonnull
    public Optional<FileType> getFileType() {
        return Optional.ofNullable(this.fileType);
    }

    public void clearFile() {
        this.textPanel.setText("");
        this.textPanel.setModified(false);
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public boolean isModified() {
        return this.textPanel.isModified();
    }

    @Override
    @Nonnull
    public Font getCurrentFont() {
        return this.textPanel.getCurrentFont();
    }

    @Override
    @Nonnull
    public Font getDefaultFont() {
        return this.textPanel.getDefaultFont();
    }

    @Override
    public void setCurrentFont(Font font) {
        this.textPanel.setCurrentFont(font);
    }

    @Nullable
    public XBLFormatDecl getContextFormatDecl() {
        XBPSerialReader reader = new XBPSerialReader(this.getClass().getResourceAsStream("/org/exbin/framework/editor/text/resources/xbt_format_decl.xb"));
        XBLFormatDecl formatDecl = new XBLFormatDecl();
        try {
            reader.read((XBSerializable)formatDecl);
        }
        catch (IOException | XBProcessingException ex) {
            return null;
        }
        return formatDecl;
    }
}

