/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRBlockRev;
import org.exbin.xbup.client.catalog.remote.XBRXBlockUi;
import org.exbin.xbup.client.catalog.remote.XBRXPlugUi;
import org.exbin.xbup.client.catalog.remote.XBRXPlugin;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;

@ParametersAreNonnullByDefault
public class XBPXUiStub
extends XBPBaseStub<XBCXBlockUi> {
    public static long[] REV_UI_PROCEDURE = new long[]{0L, 2L, 18L, 0L, 0L};
    public static long[] PLUGIN_UI_PROCEDURE = new long[]{0L, 2L, 18L, 1L, 0L};
    public static long[] PRIORITY_UI_PROCEDURE = new long[]{0L, 2L, 18L, 2L, 0L};
    public static long[] UISCOUNT_UI_PROCEDURE = new long[]{0L, 2L, 18L, 3L, 0L};
    public static long[] REVUI_UI_PROCEDURE = new long[]{0L, 2L, 18L, 4L, 0L};
    public static long[] PLUGUISCOUNT_UI_PROCEDURE = new long[]{0L, 2L, 18L, 5L, 0L};
    public static long[] PLUGUI_UI_PROCEDURE = new long[]{0L, 2L, 18L, 6L, 0L};
    public static long[] UIPLUGIN_PLUGIN_PROCEDURE = new long[]{0L, 2L, 14L, 7L, 0L};
    public static long[] METHODINDEX_PLUGIN_PROCEDURE = new long[]{0L, 2L, 14L, 8L, 0L};
    public static long[] UITYPE_PLUGIN_PROCEDURE = new long[]{0L, 2L, 14L, 9L, 0L};
    private final XBCatalogServiceClient client;

    public XBPXUiStub(XBCatalogServiceClient client) {
        super(client, XBRXBlockUi::new, null);
        this.client = client;
    }

    public XBCXPlugin getPlugin(long uiId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(UIPLUGIN_PLUGIN_PROCEDURE), uiId);
        return index == null ? null : new XBRXPlugin(this.client, index);
    }

    public long getMethodIndex(long uiId) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(METHODINDEX_PLUGIN_PROCEDURE), uiId);
    }

    public XBCXPlugUiType getUiType(long uiId) {
        final Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(UITYPE_PLUGIN_PROCEDURE), uiId);
        if (index == null) {
            return null;
        }
        XBCXPlugUiType result = new XBCXPlugUiType(){

            public String getName() {
                return XBPlugUiType.findByDbIndex((int)((int)index.longValue())).getName();
            }

            public long getId() {
                return index;
            }
        };
        return result;
    }

    public XBCBlockRev getBlockRev(long blockUiId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(REV_UI_PROCEDURE), blockUiId);
        return index == null ? null : new XBRBlockRev(this.client, index);
    }

    public XBCXPlugUi getUi(long blockUiId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(PLUGIN_UI_PROCEDURE), blockUiId);
        return index == null ? null : new XBRXPlugUi(this.client, index);
    }

    public Long getPriority(long blockUiId) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(PRIORITY_UI_PROCEDURE), blockUiId);
    }

    public Long getBlockUiCount(XBCBlockRev rev) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(UISCOUNT_UI_PROCEDURE), rev.getId());
    }

    public XBRXBlockUi findUiByPR(XBCBlockRev rev, XBPlugUiType type, long priority) {
        Long index = XBPStubUtils.threeLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(PLUGIN_UI_PROCEDURE), rev.getId(), Long.valueOf(type.getDbIndex()), priority);
        return index == null ? null : new XBRXBlockUi(this.client, index);
    }

    @Nullable
    public XBCXPlugUi getPlugUi(XBCXPlugin plugin, XBPlugUiType type, long methodIndex) {
        Long index = XBPStubUtils.threeLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(PLUGUI_UI_PROCEDURE), plugin.getId(), Long.valueOf(type.getDbIndex()), methodIndex);
        return index == null ? null : new XBRXPlugUi(this.client, index);
    }

    public long getAllPlugUisCount() {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(PLUGUISCOUNT_UI_PROCEDURE));
    }

    public String getName(long id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

