/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog.remote.manager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.catalog.remote.XBRXIcon;
import org.exbin.xbup.client.catalog.remote.XBRXIconMode;
import org.exbin.xbup.client.catalog.remote.manager.XBRDefaultManager;
import org.exbin.xbup.client.catalog.remote.manager.XBRXFileManager;
import org.exbin.xbup.client.stub.XBPXIconStub;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXIcon;
import org.exbin.xbup.core.catalog.base.manager.XBCXFileManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXIconManager;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBRXIconManager
extends XBRDefaultManager<XBCXIcon>
implements XBCXIconManager {
    private final XBPXIconStub iconStub;

    public XBRXIconManager(XBRCatalog catalog) {
        super(catalog);
        this.iconStub = new XBPXIconStub(this.client);
        this.setManagerStub(this.iconStub);
    }

    public Long[] getFileXBPath(XBCXFile file) {
        ArrayList<Long> list = new ArrayList<Long>();
        XBCNode parent = file.getNode();
        while (parent != null) {
            if (parent.getParent().isPresent()) {
                list.add(0, parent.getXBIndex());
            }
            parent = parent.getParent().orElse(null);
        }
        list.add(file.getId());
        return list.toArray(new Long[list.size()]);
    }

    public XBRXIcon getDefaultIcon(XBCItem item) {
        return this.iconStub.getDefaultIcon(item);
    }

    public List<XBCXIcon> getItemIcons(XBCItem item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBRXIconMode getIconMode(Long type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBCXIcon findById(Long id) {
        return new XBRXIcon(this.client, id);
    }

    public void initializeExtension() {
    }

    public String getExtensionName() {
        return "Icon Extension";
    }

    public ImageIcon getDefaultImageIcon(XBCItem item) {
        XBRXFileManager fileManager = (XBRXFileManager)this.catalog.getCatalogManager(XBCXFileManager.class);
        XBRXIcon icon = this.getDefaultIcon(item);
        if (icon == null) {
            return null;
        }
        XBCXFile file = icon.getIconFile();
        if (file == null) {
            return null;
        }
        return fileManager.getFileAsImageIcon(file);
    }

    public XBCXIcon getDefaultBigIcon(XBCItem item) {
        return this.iconStub.getDefaultBigIcon(item);
    }

    public XBCXIcon getDefaultSmallIcon(XBCItem item) {
        return this.iconStub.getDefaultSmallIcon(item);
    }

    public byte[] getDefaultBigIconData(XBCItem item) {
        XBRXFileManager fileManager = (XBRXFileManager)this.catalog.getCatalogManager(XBCXFileManager.class);
        XBCXIcon icon = this.getDefaultBigIcon(item);
        if (icon == null) {
            return null;
        }
        XBCXFile file = icon.getIconFile();
        if (file == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            StreamUtils.copyInputStreamToOutputStream((InputStream)fileManager.getFile(file), (OutputStream)buffer);
        }
        catch (IOException ex) {
            Logger.getLogger(XBRXIconManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return buffer.toByteArray();
    }

    public byte[] getDefaultSmallIconData(XBCItem item) {
        XBRXFileManager fileManager = (XBRXFileManager)this.catalog.getCatalogManager(XBCXFileManager.class);
        XBCXIcon icon = this.getDefaultSmallIcon(item);
        if (icon == null) {
            return null;
        }
        XBCXFile file = icon.getIconFile();
        if (file == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            StreamUtils.copyInputStreamToOutputStream((InputStream)fileManager.getFile(file), (OutputStream)buffer);
        }
        catch (IOException ex) {
            Logger.getLogger(XBRXIconManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return buffer.toByteArray();
    }
}

