/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.service;

import java.io.Serializable;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEBlockRev;
import org.exbin.xbup.catalog.entity.XBEFormatRev;
import org.exbin.xbup.catalog.entity.XBEGroupRev;
import org.exbin.xbup.catalog.entity.XBERev;
import org.exbin.xbup.catalog.entity.manager.XBERevManager;
import org.exbin.xbup.catalog.entity.service.XBEDefaultService;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.manager.XBCRevManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXDescManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXHDocManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXNameManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXStriManager;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class XBERevService
extends XBEDefaultService<XBCRev>
implements XBCRevService,
Serializable {
    @Autowired
    private XBERevManager manager;

    public XBERevService() {
    }

    public XBERevService(XBECatalog catalog) {
        super(catalog);
        this.itemManager = new XBERevManager(catalog);
        catalog.addCatalogManager(XBCRevManager.class, (XBCRevManager)this.itemManager);
    }

    @PostConstruct
    public void init() {
        this.itemManager = this.manager;
    }

    public XBERev findRevByXB(XBCSpec spec, long xbIndex) {
        return ((XBERevManager)this.itemManager).findRevByXB(spec, xbIndex);
    }

    public XBERev getRev(XBCSpec spec, long index) {
        return ((XBERevManager)this.itemManager).getRev(spec, index);
    }

    public List<XBCRev> getRevs(XBCSpec spec) {
        return ((XBERevManager)this.itemManager).getRevs(spec);
    }

    public long getRevsCount(XBCSpec spec) {
        return ((XBERevManager)this.itemManager).getRevsCount(spec);
    }

    public long findMaxRevXB(XBCSpec spec) {
        Long findMaxRevXB = ((XBERevManager)this.itemManager).findMaxRevXB(spec);
        return findMaxRevXB == null ? -1L : findMaxRevXB;
    }

    public void removeItemDepth(XBCRev rev) {
        XBCXHDocManager hdocManager;
        XBCXHDoc itemHDoc;
        XBCXNameManager nameManager = this.catalog.getCatalogManager(XBCXNameManager.class);
        List itemNames = nameManager.getItemNames((XBCItem)rev);
        for (XBCXName itemName : itemNames) {
            nameManager.removeItem((XBCBase)itemName);
        }
        XBCXDescManager descManager = this.catalog.getCatalogManager(XBCXDescManager.class);
        List itemDescs = descManager.getItemDescs((XBCItem)rev);
        for (XBCXDesc itemDesc : itemDescs) {
            descManager.removeItem((XBCBase)itemDesc);
        }
        XBCXStriManager striManager = this.catalog.getCatalogManager(XBCXStriManager.class);
        XBCXStri itemStri = striManager.getItemStringId((XBCItem)rev);
        if (itemStri != null) {
            striManager.removeItem((XBCBase)itemStri);
        }
        if ((itemHDoc = (hdocManager = this.catalog.getCatalogManager(XBCXHDocManager.class)).getDocumentation((XBCItem)rev)) != null) {
            hdocManager.removeItem((XBCBase)itemHDoc);
        }
        this.removeItem((XBCBase)rev);
    }

    public XBCRev createRev(XBCSpec spec) {
        if (spec instanceof XBCBlockSpec) {
            XBEBlockRev rev = new XBEBlockRev();
            rev.setParent(spec);
            return rev;
        }
        if (spec instanceof XBCGroupSpec) {
            XBEGroupRev rev = new XBEGroupRev();
            rev.setParent(spec);
            return rev;
        }
        if (spec instanceof XBCFormatSpec) {
            XBEFormatRev rev = new XBEFormatRev();
            rev.setParent(spec);
            return rev;
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getRevsLimitSum(XBCSpec spec, long revision) {
        return ((XBERevManager)this.itemManager).getRevsLimitSum(spec, revision);
    }
}

