/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.NoResultException;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.catalog.entity.XBEXPlugin;
import org.exbin.xbup.catalog.entity.manager.DatabaseUtils;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.manager.XBCXPlugManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBEXPlugManager
extends XBEDefaultCatalogManager<XBCXPlugin>
implements XBCXPlugManager,
Serializable {
    public XBEXPlugManager() {
    }

    public XBEXPlugManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBEXPlugin.class;
    }

    public Long getAllPluginCount() {
        try {
            return (Long)this.catalog.getEntityManager().createQuery("SELECT count(o) FROM XBXPlugin as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXPlugManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEXPlugin findById(long id) {
        try {
            return (XBEXPlugin)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXPlugin as o WHERE o.id = " + id).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXPlugManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long[] getFileXBPath(XBCXFile file) {
        ArrayList<Long> list = new ArrayList<Long>();
        XBCNode parent = file.getNode();
        while (parent != null) {
            if (parent.getParent().isPresent()) {
                list.add(0, parent.getXBIndex());
            }
            parent = parent.getParent().orElse(null);
        }
        list.add(file.getId());
        return list.toArray(new Long[list.size()]);
    }

    public void initializeExtension() {
    }

    @Nonnull
    public String getExtensionName() {
        return "Plugin Extension";
    }

    public XBEXFile findFile(XBCNode node, String fileName) {
        try {
            return (XBEXFile)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXFile as o WHERE o.parent.id = " + node.getId() + " AND o.filename = '" + DatabaseUtils.sqlEscapeString(fileName) + "'").getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXPlugManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long[] getPluginXBPath(XBCXPlugin plugin) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XBEXPlugin findPlugin(XBCNode node, Long index) {
        try {
            return (XBEXPlugin)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXPlugin as o WHERE o.owner.id = " + node.getId() + " AND o.pluginIndex = " + index).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXPlugManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Nonnull
    public List<XBCXPlugin> findPluginsForNode(XBCNode node) {
        try {
            return this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXPlugin as o WHERE o.owner.id = " + node.getId() + " ORDER BY o.pluginIndex").getResultList();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXPlugManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public InputStream getPlugin(XBCXPlugin plugin) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

