/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEBlockCons;
import org.exbin.xbup.catalog.entity.XBEBlockJoin;
import org.exbin.xbup.catalog.entity.XBEBlockListCons;
import org.exbin.xbup.catalog.entity.XBEBlockListJoin;
import org.exbin.xbup.catalog.entity.XBEBlockSpec;
import org.exbin.xbup.catalog.entity.XBEFormatCons;
import org.exbin.xbup.catalog.entity.XBEFormatJoin;
import org.exbin.xbup.catalog.entity.XBEFormatSpec;
import org.exbin.xbup.catalog.entity.XBEGroupCons;
import org.exbin.xbup.catalog.entity.XBEGroupJoin;
import org.exbin.xbup.catalog.entity.XBEGroupSpec;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBESpec;
import org.exbin.xbup.catalog.entity.XBESpecDef;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.catalog.entity.manager.XBEItemManager;
import org.exbin.xbup.core.block.definition.XBParamType;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.manager.XBCSpecManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBESpecManager
extends XBEDefaultCatalogManager<XBCSpec>
implements XBCSpecManager,
Serializable {
    public XBESpecManager() {
    }

    public XBESpecManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBESpec.class;
    }

    public Long getAllSpecsCount() {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBSpec as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long getAllFormatSpecsCount() {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBFormatSpec as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long getAllGroupSpecsCount() {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBGroupSpec as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long getAllBlockSpecsCount() {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBBlockSpec as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBESpec findById(long id) {
        try {
            return (XBESpec)this.em.createQuery("SELECT object(o) FROM XBSpec as o WHERE o.id = " + id).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long[] getSpecXBPath(XBCSpec spec) {
        ArrayList<Long> list = new ArrayList<Long>();
        XBCNode parent = spec.getParent();
        while (parent != null) {
            if (parent.getParent().isPresent()) {
                list.add(0, parent.getXBIndex());
            }
            parent = parent.getParent().orElse(null);
        }
        list.add(spec.getXBIndex());
        return list.toArray(new Long[list.size()]);
    }

    public List<XBCSpec> getSpecs(XBCNode node) {
        try {
            return this.em.createQuery("SELECT object(o) FROM XBSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBESpec getSpec(XBCNode node, long index) {
        try {
            Query query = this.em.createQuery("SELECT object(o) FROM XBSpec AS o WHERE o.parent.id = " + ((XBENode)node).getId());
            query.setFirstResult((int)index);
            query.setMaxResults(1);
            return (XBESpec)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEFormatSpec getFormatSpec(XBCNode node, long index) {
        try {
            Query query = this.em.createQuery("SELECT object(o) FROM XBFormatSpec as o WHERE o.parent.id = " + ((XBENode)node).getId());
            query.setFirstResult((int)index);
            query.setMaxResults(1);
            return (XBEFormatSpec)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCFormatSpec> getFormatSpecs(XBCNode node) {
        try {
            return this.em.createQuery("SELECT object(o) FROM XBFormatSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEBlockSpec getBlockSpec(XBCNode node, long index) {
        try {
            Query query = this.em.createQuery("SELECT object(o) FROM XBBlockSpec as o WHERE o.parent.id = " + ((XBENode)node).getId());
            query.setFirstResult((int)index);
            query.setMaxResults(1);
            return (XBEBlockSpec)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCBlockSpec> getBlockSpecs(XBCNode node) {
        try {
            return this.em.createQuery("SELECT object(o) FROM XBBlockSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEGroupSpec getGroupSpec(XBCNode node, long index) {
        try {
            Query query = this.em.createQuery("SELECT object(o) FROM XBGroupSpec as o WHERE o.parent.id = " + ((XBENode)node).getId());
            query.setFirstResult((int)index);
            query.setMaxResults(1);
            return (XBEGroupSpec)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCGroupSpec> getGroupSpecs(XBCNode node) {
        try {
            return this.em.createQuery("SELECT object(o) FROM XBGroupSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEBlockSpec findBlockSpecByXB(XBCNode node, long xbIndex) {
        if (node == null || !(node instanceof XBENode)) {
            return null;
        }
        try {
            return (XBEBlockSpec)this.em.createQuery("SELECT object(o) FROM XBBlockSpec as o WHERE o.parent.id = " + ((XBENode)node).getId() + " AND o.xbIndex = " + xbIndex).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEGroupSpec findGroupSpecByXB(XBCNode node, long xbIndex) {
        if (node == null || !(node instanceof XBENode)) {
            return null;
        }
        try {
            return (XBEGroupSpec)this.em.createQuery("SELECT object(o) FROM XBGroupSpec as o WHERE o.parent.id = " + ((XBENode)node).getId() + " AND o.xbIndex = " + xbIndex).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEFormatSpec findFormatSpecByXB(XBCNode node, long xbIndex) {
        if (node == null || !(node instanceof XBENode)) {
            return null;
        }
        try {
            return (XBEFormatSpec)this.em.createQuery("SELECT object(o) FROM XBFormatSpec as o WHERE o.parent.id = " + ((XBENode)node).getId() + " AND o.xbIndex = " + xbIndex).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long findMaxBlockSpecXB(XBCNode node) {
        if (node == null || !(node instanceof XBENode)) {
            return null;
        }
        try {
            return (Long)this.em.createQuery("SELECT max(o.xbIndex) FROM XBBlockSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long findMaxGroupSpecXB(XBCNode node) {
        if (node == null || !(node instanceof XBENode)) {
            return null;
        }
        try {
            return (Long)this.em.createQuery("SELECT max(o.xbIndex) FROM XBGroupSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long findMaxFormatSpecXB(XBCNode node) {
        if (node == null || !(node instanceof XBENode)) {
            return null;
        }
        try {
            return (Long)this.em.createQuery("SELECT max(o.xbIndex) FROM XBFormatSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public long getFormatSpecsCount(XBCNode node) {
        if (node == null) {
            return 0L;
        }
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBFormatSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public long getGroupSpecsCount(XBCNode node) {
        if (node == null) {
            return 0L;
        }
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBGroupSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public long getBlockSpecsCount(XBCNode node) {
        if (node == null) {
            return 0L;
        }
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBBlockSpec as o WHERE o.parent.id = " + ((XBENode)node).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public long getSpecsCount(XBCNode node) {
        return this.getFormatSpecsCount(node) + this.getGroupSpecsCount(node) + this.getBlockSpecsCount(node);
    }

    public XBESpecDef getSpecDefByOrder(XBCSpec spec, long index) {
        try {
            Query query = this.em.createQuery("SELECT object(o) FROM XBSpecDef as o WHERE o.parent.id = " + ((XBESpec)spec).getId());
            query.setFirstResult((int)index);
            query.setMaxResults(1);
            return (XBESpecDef)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCSpecDef> getSpecDefs(XBCSpec spec) {
        try {
            return this.em.createQuery("SELECT object(o) FROM XBSpecDef as o WHERE o.parent.id = " + ((XBESpec)spec).getId() + " ORDER BY o.xbIndex").getResultList();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public long getSpecDefsCount(XBCSpec spec) {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBSpecDef as o WHERE o.parent.id = " + ((XBESpec)spec).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public XBESpecDef findSpecDefByXB(XBCSpec spec, long xbIndex) {
        if (spec == null) {
            return null;
        }
        try {
            return (XBESpecDef)this.em.createQuery("SELECT object(o) FROM XBSpecDef as o WHERE o.parent.id = " + ((XBESpec)spec).getId() + " AND o.xbIndex = " + xbIndex).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long findMaxSpecDefXB(XBCSpec spec) {
        if (spec == null) {
            return null;
        }
        try {
            return (Long)this.em.createQuery("SELECT max(o.xbIndex) FROM XBSpecDef as o WHERE o.parent.id = " + ((XBESpec)spec).getId()).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBESpecManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public long getDefsCount() {
        try {
            return (Long)this.em.createQuery("SELECT count(o) FROM XBSpecDef as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEItemManager.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    public XBCSpecDef getSpecDef(long itemId) {
        Object result = this.em.find(XBESpecDef.class, (Object)itemId);
        return (XBESpecDef)result;
    }

    public XBESpecDef createSpecDef(XBCSpec spec, XBParamType type) {
        if (spec instanceof XBCBlockSpec) {
            switch (type) {
                case CONSIST: {
                    XBEBlockCons blockCons = XBESpecManager.newInstance(XBEBlockCons.class);
                    blockCons.setSpec(spec);
                    return blockCons;
                }
                case JOIN: {
                    XBEBlockJoin blockJoin = XBESpecManager.newInstance(XBEBlockJoin.class);
                    blockJoin.setSpec(spec);
                    return blockJoin;
                }
                case LIST_CONSIST: {
                    XBEBlockListCons listCons = XBESpecManager.newInstance(XBEBlockListCons.class);
                    listCons.setSpec(spec);
                    return listCons;
                }
                case LIST_JOIN: {
                    XBEBlockListJoin listJoin = XBESpecManager.newInstance(XBEBlockListJoin.class);
                    listJoin.setSpec(spec);
                    return listJoin;
                }
            }
            return null;
        }
        if (spec instanceof XBCGroupSpec) {
            switch (type) {
                case CONSIST: {
                    XBEGroupCons groupCons = XBESpecManager.newInstance(XBEGroupCons.class);
                    groupCons.setSpec(spec);
                    return groupCons;
                }
                case JOIN: {
                    XBEGroupJoin groupJoin = XBESpecManager.newInstance(XBEGroupJoin.class);
                    groupJoin.setSpec(spec);
                    return groupJoin;
                }
            }
            return null;
        }
        if (spec instanceof XBCFormatSpec) {
            switch (type) {
                case CONSIST: {
                    XBEFormatCons formatCons = XBESpecManager.newInstance(XBEFormatCons.class);
                    formatCons.setSpec(spec);
                    return formatCons;
                }
                case JOIN: {
                    XBEFormatJoin formatJoin = XBESpecManager.newInstance(XBEFormatJoin.class);
                    formatJoin.setSpec(spec);
                    return formatJoin;
                }
            }
            return null;
        }
        return null;
    }

    @Nonnull
    public XBEBlockSpec createBlockSpec() {
        return XBESpecManager.newInstance(XBEBlockSpec.class);
    }

    @Nonnull
    public XBCGroupSpec createGroupSpec() {
        return XBESpecManager.newInstance(XBEGroupSpec.class);
    }

    @Nonnull
    public XBCFormatSpec createFormatSpec() {
        return XBESpecManager.newInstance(XBEFormatSpec.class);
    }

    public void persistSpecDef(XBCSpecDef specDef) {
        EntityTransaction transaction = null;
        try {
            transaction = this.em.getTransaction();
            transaction.begin();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.em.persist((Object)specDef);
        if (this.em.getFlushMode() == FlushModeType.COMMIT && transaction != null) {
            this.em.flush();
            transaction.commit();
        }
    }

    public void removeSpecDef(XBCSpecDef specDef) {
        EntityTransaction transaction = null;
        try {
            transaction = this.em.getTransaction();
            transaction.begin();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        XBCSpecDef removedItem = (XBCSpecDef)this.em.merge((Object)specDef);
        this.em.remove((Object)removedItem);
        if (this.em.getFlushMode() == FlushModeType.COMMIT && transaction != null) {
            this.em.flush();
            transaction.commit();
        }
    }

    @Nonnull
    private static <T> T newInstance(Class<T> tClass) {
        try {
            return tClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException("Unable to create new item", ex);
        }
    }
}

