/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import org.exbin.xbup.catalog.entity.XBEBlockSpec;
import org.exbin.xbup.catalog.entity.XBEFormatSpec;
import org.exbin.xbup.catalog.entity.XBEGroupSpec;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBERev;
import org.exbin.xbup.catalog.entity.service.XBEItemService;
import org.exbin.xbup.catalog.entity.service.XBENodeService;
import org.exbin.xbup.catalog.entity.service.XBERevService;
import org.exbin.xbup.catalog.entity.service.XBERootService;
import org.exbin.xbup.catalog.entity.service.XBESpecService;
import org.exbin.xbup.catalog.entity.service.XBEXInfoService;
import org.exbin.xbup.client.update.XBCUpdateHandler;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclaration;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.XBGroup;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCFormatDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCGroupDecl;
import org.exbin.xbup.core.block.declaration.local.XBLGroupDecl;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCExtension;
import org.exbin.xbup.core.catalog.base.XBCFormatRev;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupRev;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.manager.XBCManager;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.exbin.xbup.core.catalog.base.service.XBCService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXInfoService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBSerializable;

@ParametersAreNonnullByDefault
public class XBECatalog
implements XBCatalog {
    private XBContext rootContext = null;
    private XBCUpdateHandler updateHandler;
    private boolean shallInit;
    @PersistenceContext
    protected EntityManager em;
    protected Map<Class, XBCManager<?>> catalogManagers;
    protected Map<Class, XBCService<?>> catalogServices;

    public XBECatalog() {
    }

    public XBECatalog(EntityManager em) {
        this.em = em;
        this.init();
    }

    @PostConstruct
    private void init() {
        this.updateHandler = null;
        this.catalogManagers = new HashMap();
        this.catalogServices = new HashMap();
        XBERootService rootService = new XBERootService(this);
        this.catalogServices.put(XBCItemService.class, new XBEItemService(this));
        this.catalogServices.put(XBCNodeService.class, new XBENodeService(this));
        this.catalogServices.put(XBCRootService.class, rootService);
        this.catalogServices.put(XBCSpecService.class, new XBESpecService(this));
        this.catalogServices.put(XBCXInfoService.class, new XBEXInfoService(this));
        this.catalogServices.put(XBCRevService.class, new XBERevService(this));
        this.shallInit = !rootService.isMainPresent();
    }

    @Nullable
    public XBEFormatSpec findFormatSpecByPath(Long[] xbCatalogPath) {
        XBENodeService nodeService = (XBENodeService)this.getCatalogService(XBCNodeService.class);
        XBESpecService specService = (XBESpecService)this.getCatalogService(XBCSpecService.class);
        XBENode node = nodeService.findOwnerByXBPath(xbCatalogPath);
        if (node == null) {
            return null;
        }
        return specService.findFormatSpecByXB(node, xbCatalogPath[xbCatalogPath.length - 1]);
    }

    @Nullable
    public XBEGroupSpec findGroupSpecByPath(Long[] xbCatalogPath) {
        XBENodeService nodeService = (XBENodeService)this.getCatalogService(XBCNodeService.class);
        XBESpecService specService = (XBESpecService)this.getCatalogService(XBCSpecService.class);
        XBENode node = nodeService.findOwnerByXBPath(xbCatalogPath);
        if (node == null) {
            return null;
        }
        return specService.findGroupSpecByXB(node, xbCatalogPath[xbCatalogPath.length - 1]);
    }

    @Nullable
    public XBEBlockSpec findBlockSpecByPath(Long[] xbCatalogPath) {
        XBENodeService nodeService = (XBENodeService)this.getCatalogService(XBCNodeService.class);
        XBESpecService specService = (XBESpecService)this.getCatalogService(XBCSpecService.class);
        XBENode node = nodeService.findOwnerByXBPath(xbCatalogPath);
        if (node == null) {
            return null;
        }
        return specService.findBlockSpecByXB(node, xbCatalogPath[xbCatalogPath.length - 1]);
    }

    @Nullable
    public XBFormatDecl findFormatTypeByPath(Long[] xbCatalogPath, int revision) {
        XBERevService revService = (XBERevService)this.getCatalogService(XBCRevService.class);
        XBEFormatSpec spec = this.findFormatSpecByPath(xbCatalogPath);
        if (spec == null) {
            return null;
        }
        XBERev rev = revService.findRevByXB(spec, revision);
        if (rev == null) {
            return null;
        }
        return new XBCFormatDecl((XBCFormatRev)rev, (XBCatalog)this);
    }

    @Nullable
    public XBGroupDecl findGroupTypeByPath(Long[] xbCatalogPath, int revision) {
        XBERevService revService = (XBERevService)this.getCatalogService(XBCRevService.class);
        XBEGroupSpec spec = this.findGroupSpecByPath(xbCatalogPath);
        if (spec == null) {
            return null;
        }
        XBERev rev = revService.findRevByXB(spec, revision);
        if (rev == null) {
            return null;
        }
        return new XBCGroupDecl((XBCGroupRev)rev, (XBCatalog)this);
    }

    @Nullable
    public XBBlockDecl findBlockTypeByPath(Long[] blockSpecCatalogPath, int revision) {
        XBERevService revService = (XBERevService)this.getCatalogService(XBCRevService.class);
        XBEBlockSpec spec = this.findBlockSpecByPath(blockSpecCatalogPath);
        if (spec == null) {
            return null;
        }
        XBERev rev = revService.findRevByXB(spec, revision);
        if (rev == null) {
            return null;
        }
        return new XBCBlockDecl((XBCBlockRev)rev, (XBCatalog)this);
    }

    @Nonnull
    public XBContext getRootContext() {
        if (this.rootContext == null) {
            XBENodeService nodeService = (XBENodeService)this.getCatalogService(XBCNodeService.class);
            XBESpecService specService = (XBESpecService)this.getCatalogService(XBCSpecService.class);
            XBERevService revService = (XBERevService)this.getCatalogService(XBCRevService.class);
            XBENode rootNode = (XBENode)nodeService.getMainRootNode().get();
            XBENode basicNode = nodeService.getSubNode(rootNode, 0L);
            XBCGroupDecl groupDecl = new XBCGroupDecl((XBCGroupRev)revService.findRevByXB(specService.findGroupSpecByXB(basicNode, 0L), 0L), (XBCatalog)this);
            this.rootContext = new XBContext();
            this.rootContext.setStartFrom(0);
            if (groupDecl.getGroupSpecRev() != null) {
                this.rootContext.getGroups().add(XBDeclaration.convertCatalogGroup((XBGroupDecl)groupDecl));
            }
        }
        return this.rootContext;
    }

    public void setRootContext(XBContext rootContext) {
        this.rootContext = rootContext;
    }

    public void initCatalog() {
        EntityTransaction tx = this.em.getTransaction();
        try {
            ArrayList todoManagers = new ArrayList(this.catalogManagers.values());
            int consecutive = 0;
            while (!todoManagers.isEmpty()) {
                XBCManager manager = (XBCManager)todoManagers.remove(0);
                tx.begin();
                boolean success = manager.initCatalog();
                tx.commit();
                if (success) {
                    consecutive = 0;
                    continue;
                }
                todoManagers.add(manager);
                if (++consecutive != todoManagers.size()) continue;
                throw new IllegalStateException("Unable to initialize catalog");
            }
            this.shallInit = false;
        }
        catch (Exception ex) {
            Logger.getLogger(XBECatalog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List<XBGroupDecl> getGroups(XBCFormatSpec spec) {
        XBESpecService specService = (XBESpecService)this.getCatalogService(XBCSpecService.class);
        List<XBCSpecDef> binds = specService.getSpecDefs((XBCSpec)spec);
        ArrayList<XBGroupDecl> result = new ArrayList<XBGroupDecl>();
        Iterator<XBCSpecDef> it = binds.iterator();
        while (it.hasNext()) {
            XBCRev revision = (XBCRev)it.next().getTargetRev().get();
            result.add((XBGroupDecl)new XBCGroupDecl((XBCGroupRev)revision, (XBCatalog)this));
        }
        return result;
    }

    public List<XBBlockDecl> getBlocks(XBCGroupSpec spec) {
        XBESpecService specService = (XBESpecService)this.getCatalogService(XBCSpecService.class);
        List<XBCSpecDef> binds = specService.getSpecDefs((XBCSpec)spec);
        ArrayList<XBBlockDecl> result = new ArrayList<XBBlockDecl>();
        Iterator<XBCSpecDef> it = binds.iterator();
        while (it.hasNext()) {
            Optional revision = it.next().getTargetRev();
            if (revision.isPresent()) {
                result.add((XBBlockDecl)new XBCBlockDecl((XBCBlockRev)revision.get(), (XBCatalog)this));
                continue;
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return result;
    }

    public <T extends XBCManager<?>> void addCatalogManager(Class<T> type, T manager) {
        this.catalogManagers.put(type, manager);
        if (this.isShallInit() && manager instanceof XBCExtension) {
            ((XBCExtension)manager).initializeExtension();
        }
    }

    public <T extends XBCService<?>> void addCatalogService(Class<T> type, T service) {
        this.catalogServices.put(type, service);
        if (this.isShallInit() && service instanceof XBCExtension) {
            ((XBCExtension)service).initializeExtension();
        }
    }

    @Nonnull
    public EntityManager getEntityManager() {
        return this.em;
    }

    @Nonnull
    public List<XBCService<?>> getCatalogServices() {
        return new ArrayList(this.catalogServices.values());
    }

    @Nonnull
    public List<XBCManager<?>> getCatalogManagers() {
        return new ArrayList(this.catalogManagers.values());
    }

    public XBCUpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public void setUpdateHandler(XBCUpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    public boolean isShallInit() {
        return this.shallInit;
    }

    @Nonnull
    public <T extends XBCManager<?>> T getCatalogManager(Class<T> managerClass) {
        return (T)this.catalogManagers.get(managerClass);
    }

    @Nonnull
    public <T extends XBCService<?>> T getCatalogService(Class<T> serviceClass) {
        return (T)this.catalogServices.get(serviceClass);
    }

    public Long findBlockIdForGroup(XBGroup group, XBBlockDecl decl) {
        List blocks = group.getBlocks();
        for (int blockId = 0; blockId < blocks.size(); ++blockId) {
            XBBlockDecl block = (XBBlockDecl)blocks.get(blockId);
            if (!block.equals(decl)) continue;
            return blockId;
        }
        return null;
    }

    public Long findBlockIdForGroup(XBGroupDecl group, XBBlockDecl decl) {
        if (group instanceof XBLGroupDecl) {
            List blocks = ((XBLGroupDecl)group).getBlockDecls();
            for (int blockId = 0; blockId < blocks.size(); ++blockId) {
                XBBlockDecl block = (XBBlockDecl)blocks.get(blockId);
                if (!block.equals(decl)) continue;
                return blockId;
            }
        } else if (group instanceof XBCGroupSpec) {
            XBCGroupRev groupRev = ((XBCGroupDecl)group).getGroupSpecRev();
            List<XBBlockDecl> blocks = this.getBlocks(groupRev.getParent());
            Long limit = groupRev.getXBLimit();
            for (int blockId = 0; blockId < blocks.size() && (long)blockId < limit; ++blockId) {
                XBBlockDecl block = blocks.get(blockId);
                if (!block.equals(decl)) continue;
                return blockId;
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return null;
    }

    public XBBlockDecl getBlockType(XBContext context, int groupId, int blockId) {
        XBGroup group = context.getGroupForId(groupId);
        if (group == null) {
            return null;
        }
        List blocks = group.getBlocks();
        return blockId < blocks.size() ? (XBBlockDecl)blocks.get(blockId) : null;
    }

    public XBContext processDeclaration(XBContext parent, XBTPullProvider blockProvider) {
        XBDeclaration declaration = new XBDeclaration((XBFormatDecl)new XBCFormatDecl(null, (XBCatalog)this));
        declaration.setHeaderMode(true);
        XBPSerialReader serialHandler = new XBPSerialReader(blockProvider);
        try {
            serialHandler.read((XBSerializable)declaration);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBECatalog.class.getName()).log(Level.SEVERE, null, ex);
        }
        XBContext context = declaration.generateContext();
        return context;
    }

    public Long[] getSpecPath(XBCSpec spec) {
        XBESpecService specService = (XBESpecService)this.getCatalogService(XBCSpecService.class);
        return specService.getSpecXBPath(spec);
    }

    public XBBlockType getBasicBlockType(XBBasicBlockType blockType) {
        Long[] catalogBlockPath = new Long[]{0L, blockType.ordinal()};
        XBBlockDecl blockDecl = this.findBlockTypeByPath(catalogBlockPath, 0);
        return blockDecl != null ? new XBDeclBlockType(blockDecl) : new XBFixedBlockType(blockType);
    }
}

