/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options.action;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.options.gui.OptionsTreePanel;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.OptionsControlPanel;

@ParametersAreNonnullByDefault
public class OptionsAction
extends AbstractAction {
    public static final String ACTION_ID = "optionsAction";
    private ResourceBundle resourceBundle;
    private XBApplication application;
    private OptionsPagesProvider optionsPagesProvider;

    public void setup(XBApplication application, ResourceBundle resourceBundle, OptionsPagesProvider optionsPagesProvider) {
        this.application = application;
        this.resourceBundle = resourceBundle;
        this.optionsPagesProvider = optionsPagesProvider;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        OptionsTreePanel optionsTreePanel = new OptionsTreePanel(frameModule.getFrameHandler());
        this.optionsPagesProvider.registerOptionsPages(optionsTreePanel);
        Dimension preferredSize = optionsTreePanel.getPreferredSize();
        optionsTreePanel.setPreferredSize(new Dimension(preferredSize.width + 200, preferredSize.height + 200));
        optionsTreePanel.setApplication(this.application);
        optionsTreePanel.setPreferences(this.application.getAppPreferences());
        optionsTreePanel.pagesFinished();
        optionsTreePanel.loadAllFromPreferences();
        OptionsControlPanel controlPanel = new OptionsControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)optionsTreePanel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, optionsTreePanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case SAVE: {
                    optionsTreePanel.saveAndApplyAll();
                    break;
                }
                case CANCEL: {
                    break;
                }
                case APPLY_ONCE: {
                    optionsTreePanel.applyPreferencesChanges();
                }
            }
            dialog.close();
        });
        dialog.showCentered((Component)frameModule.getFrame());
    }

    @ParametersAreNonnullByDefault
    public static interface OptionsPagesProvider {
        public void registerOptionsPages(OptionsTreePanel var1);
    }
}

