/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options;

import com.formdev.flatlaf.extras.FlatDesktop;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.ApplicationFrameHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.options.MainOptionsManager;
import org.exbin.framework.options.action.OptionsAction;
import org.exbin.framework.options.api.DefaultOptionsPage;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsData;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.options.api.OptionsPage;
import org.exbin.framework.options.api.OptionsPathItem;
import org.exbin.framework.options.gui.AppearanceOptionsPanel;
import org.exbin.framework.options.options.AppearanceOptions;
import org.exbin.framework.options.options.impl.AppearanceOptionsImpl;
import org.exbin.framework.options.options.impl.FrameworkOptionsImpl;
import org.exbin.framework.options.preferences.AppearancePreferences;
import org.exbin.framework.utils.ComponentResourceProvider;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class OptionsModule
implements OptionsModuleApi {
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private OptionsAction optionsAction;
    private final List<OptionsPageRecord> optionsPages = new ArrayList<OptionsPageRecord>();
    private MainOptionsManager mainOptionsManager;
    private OptionsPage<?> mainOptionsExtPage = null;
    private OptionsPage<?> appearanceOptionsExtPage = null;

    public void init(XBModuleHandler moduleHandler) {
        this.application = (XBApplication)moduleHandler;
    }

    public void unregisterModule(String moduleId) {
    }

    @Nonnull
    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(OptionsModule.class);
            OptionsPage<FrameworkOptionsImpl> mainOptionsPage = this.getMainOptionsManager().getMainOptionsPage();
            this.optionsPages.add(new OptionsPageRecord(null, mainOptionsPage));
            DefaultOptionsPage<AppearanceOptionsImpl> appearanceOptionsPage = new DefaultOptionsPage<AppearanceOptionsImpl>(){

                @Nonnull
                public OptionsComponent<AppearanceOptionsImpl> createPanel() {
                    return new AppearanceOptionsPanel();
                }

                @Nonnull
                public ResourceBundle getResourceBundle() {
                    return LanguageUtils.getResourceBundleByClass(AppearanceOptionsPanel.class);
                }

                @Nonnull
                public AppearanceOptionsImpl createOptions() {
                    return new AppearanceOptionsImpl();
                }

                public void loadFromPreferences(Preferences preferences, AppearanceOptionsImpl options) {
                    AppearancePreferences prefs = new AppearancePreferences(preferences);
                    options.loadFromPreferences(prefs);
                }

                public void saveToPreferences(Preferences preferences, AppearanceOptionsImpl options) {
                    AppearancePreferences prefs = new AppearancePreferences(preferences);
                    options.saveToParameters(prefs);
                }

                public void applyPreferencesChanges(AppearanceOptionsImpl options) {
                    FrameModuleApi frameModule = (FrameModuleApi)OptionsModule.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                    ApplicationFrameHandler frame = frameModule.getFrameHandler();
                    frame.setToolBarVisible(options.isShowToolBar());
                    frame.setToolBarCaptionsVisible(options.isShowToolBarCaptions());
                    frame.setStatusBarVisible(options.isShowStatusBar());
                    frameModule.notifyFrameUpdated();
                }
            };
            ResourceBundle optionsResourceBundle = ((ComponentResourceProvider)appearanceOptionsPage).getResourceBundle();
            ArrayList<OptionsPathItem> optionsPath = new ArrayList<OptionsPathItem>();
            optionsPath.add(new OptionsPathItem(optionsResourceBundle.getString("options.name"), optionsResourceBundle.getString("options.caption")));
            this.addOptionsPage((OptionsPage<?>)appearanceOptionsPage, (List<OptionsPathItem>)optionsPath);
        }
        return this.resourceBundle;
    }

    private void ensureSetup() {
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nonnull
    public Action getOptionsAction() {
        if (this.optionsAction == null) {
            this.ensureSetup();
            this.optionsAction = new OptionsAction();
            this.optionsAction.setup(this.application, this.resourceBundle, optionsTreePanel -> {
                this.optionsPages.forEach(record -> optionsTreePanel.addOptionsPage(record.optionsPage, record.path));
                if (this.mainOptionsExtPage != null) {
                    optionsTreePanel.extendMainOptionsPage(this.mainOptionsExtPage);
                }
                if (this.appearanceOptionsExtPage != null) {
                    optionsTreePanel.extendAppearanceOptionsPage(this.appearanceOptionsExtPage);
                }
            });
        }
        return this.optionsAction;
    }

    @Nonnull
    public MainOptionsManager getMainOptionsManager() {
        if (this.mainOptionsManager == null) {
            this.mainOptionsManager = new MainOptionsManager();
            this.mainOptionsManager.setApplication(this.application);
        }
        return this.mainOptionsManager;
    }

    public void notifyOptionsChanged() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        frameModule.notifyFrameUpdated();
    }

    public void addOptionsPage(OptionsPage<?> optionsPage, List<OptionsPathItem> path) {
        this.optionsPages.add(new OptionsPageRecord(path, optionsPage));
    }

    public void addOptionsPage(OptionsPage<?> optionsPage, String parentPath) {
        String[] pathParts;
        ArrayList<OptionsPathItem> optionsPath = new ArrayList<OptionsPathItem>();
        for (String pathPart : pathParts = parentPath.split("/")) {
            if (pathPart.isEmpty()) continue;
            optionsPath.add(new OptionsPathItem(pathPart, null));
        }
        if (optionsPage instanceof ComponentResourceProvider) {
            ResourceBundle componentResourceBundle = ((ComponentResourceProvider)optionsPage).getResourceBundle();
            String optionsDefaultName = componentResourceBundle.getString("options.name");
            String optionsDefaultCaption = componentResourceBundle.getString("options.caption");
            optionsPath.add(new OptionsPathItem(optionsDefaultName, optionsDefaultCaption));
        }
        this.addOptionsPage(optionsPage, optionsPath);
    }

    public void addOptionsPage(OptionsPage<?> optionsPage) {
        String optionsDefaultPath;
        if (optionsPage instanceof ComponentResourceProvider) {
            ResourceBundle componentResourceBundle = ((ComponentResourceProvider)optionsPage).getResourceBundle();
            optionsDefaultPath = componentResourceBundle.getString("options.path");
        } else {
            optionsDefaultPath = null;
        }
        this.addOptionsPage(optionsPage, optionsDefaultPath);
    }

    public void extendMainOptionsPage(OptionsPage<?> optionsPage) {
        this.mainOptionsExtPage = optionsPage;
    }

    public void extendAppearanceOptionsPage(OptionsPage<?> optionsPage) {
        this.appearanceOptionsExtPage = optionsPage;
    }

    public void initialLoadFromPreferences() {
        Preferences preferences = this.application.getAppPreferences();
        for (OptionsPageRecord optionsPage : this.optionsPages) {
            OptionsPage<?> page = optionsPage.optionsPage;
            OptionsData options = page.createOptions();
            page.loadFromPreferences(preferences, options);
            if (!(options instanceof AppearanceOptions)) continue;
            page.applyPreferencesChanges(options);
        }
        this.notifyOptionsChanged();
    }

    public void registerMenuAction() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        this.getOptionsAction();
        boolean optionsActionRegistered = false;
        if (DesktopUtils.detectBasicOs() == DesktopUtils.DesktopOs.MAC_OS) {
            FlatDesktop.setPreferencesHandler(() -> this.optionsAction.actionPerformed(null));
            optionsActionRegistered = true;
        }
        actionModule.registerMenuGroup(FrameModuleApi.TOOLS_MENU_ID, new MenuGroup(TOOLS_OPTIONS_MENU_GROUP_ID, new MenuPosition(PositionMode.BOTTOM_LAST), optionsActionRegistered ? SeparationMode.NONE : SeparationMode.AROUND));
        if (!optionsActionRegistered) {
            actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, (Action)this.optionsAction, new MenuPosition(TOOLS_OPTIONS_MENU_GROUP_ID));
        }
    }

    @ParametersAreNonnullByDefault
    private static class OptionsPageRecord {
        List<OptionsPathItem> path;
        OptionsPage<?> optionsPage;

        public OptionsPageRecord(@Nullable List<OptionsPathItem> path, OptionsPage<?> optionsPage) {
            this.path = path;
            this.optionsPage = optionsPage;
        }
    }
}

