/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.UIManager;
import org.exbin.bined.color.BasicCodeAreaDecorationColorType;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.extended.color.CodeAreaUnprintablesColorType;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;

@ParametersAreNonnullByDefault
public class ExtendedCodeAreaColorProfile
implements CodeAreaColorsProfile {
    private final Map<CodeAreaColorType, Color> colors = new HashMap<CodeAreaColorType, Color>();
    private boolean inheritSystemColors = true;

    @Nonnull
    public ExtendedCodeAreaColorProfile createCopy() {
        ExtendedCodeAreaColorProfile copy = new ExtendedCodeAreaColorProfile();
        copy.colors.putAll(this.colors);
        copy.inheritSystemColors = this.inheritSystemColors;
        return copy;
    }

    @Nullable
    public Color getColor(CodeAreaColorType colorType) {
        return this.colors.get(colorType);
    }

    @Nullable
    public Color getColor(CodeAreaColorType colorType, @Nullable CodeAreaBasicColors basicAltColor) {
        Color color = this.colors.get(colorType);
        return color == null ? (basicAltColor == null ? null : this.colors.get(basicAltColor)) : color;
    }

    public void setColor(CodeAreaColorType colorType, Color color) {
        this.inheritSystemColors = false;
        this.colors.put(colorType, color);
    }

    public void removeColor(CodeAreaColorType colorType) {
        this.colors.remove(colorType);
    }

    public boolean isInheritSystemColors() {
        return this.inheritSystemColors;
    }

    public void setInheritSystemColors(boolean inheritSystemColors) {
        this.inheritSystemColors = inheritSystemColors;
        if (!inheritSystemColors) {
            this.reinitialize();
        }
    }

    public void reinitialize() {
        if (this.inheritSystemColors) {
            Color textColor = UIManager.getColor("TextArea.foreground");
            if (textColor == null) {
                textColor = Color.BLACK;
            }
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR, textColor);
            Color textBackground = UIManager.getColor("TextArea.background");
            if (textBackground == null) {
                textBackground = Color.WHITE;
            }
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND, textBackground);
            Color selectionColor = UIManager.getColor("TextArea.selectionForeground");
            if (selectionColor == null) {
                selectionColor = Color.WHITE;
            }
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.SELECTION_COLOR, selectionColor);
            Color selectionBackground = UIManager.getColor("TextArea.selectionBackground");
            if (selectionBackground == null) {
                selectionBackground = new Color(96, 96, 255);
            }
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.SELECTION_BACKGROUND, selectionBackground);
            Color selectionMirrorColor = selectionColor;
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_COLOR, selectionMirrorColor);
            Color selectionMirrorBackground = CodeAreaSwingUtils.computeGrayColor((Color)selectionBackground);
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_BACKGROUND, selectionMirrorBackground);
            Color cursorColor = UIManager.getColor("TextArea.caretForeground");
            if (cursorColor == null) {
                cursorColor = Color.BLACK;
            }
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.CURSOR_COLOR, cursorColor);
            Color cursorNegativeColor = CodeAreaSwingUtils.createNegativeColor((Color)cursorColor);
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.CURSOR_NEGATIVE_COLOR, cursorNegativeColor);
            Color decorationLine = Color.GRAY;
            this.colors.put((CodeAreaColorType)BasicCodeAreaDecorationColorType.LINE, decorationLine);
            Color alternateColor = textColor;
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_COLOR, alternateColor);
            Color alternateBackground = CodeAreaSwingUtils.createOddColor((Color)textBackground);
            this.colors.put((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_BACKGROUND, alternateBackground);
            Color unprintablesColor = new Color(textColor.getRed(), textColor.getGreen(), (textColor.getBlue() + 196) % 256);
            this.colors.put((CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_COLOR, unprintablesColor);
        }
    }
}

