/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended;

import java.awt.Font;
import java.awt.Graphics;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.exbin.bined.CaretMovedListener;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.ClipboardHandlingMode;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaSelection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.EditMode;
import org.exbin.bined.EditModeChangedListener;
import org.exbin.bined.EditOperation;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.ScrollBarVisibility;
import org.exbin.bined.ScrollingListener;
import org.exbin.bined.SelectionChangedListener;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.basic.VerticalScrollUnit;
import org.exbin.bined.extended.ExtendedHorizontalScrollUnit;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.basic.AntialiasingMode;
import org.exbin.bined.swing.basic.DefaultCodeAreaCaret;
import org.exbin.bined.swing.basic.DefaultCodeAreaCommandHandler;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;
import org.exbin.bined.swing.extended.ExtendedCodeArea;
import org.exbin.bined.swing.extended.ExtendedCodeAreaPainter;
import org.exbin.bined.swing.extended.caret.CaretsProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.extended.caret.ExtendedCodeAreaCaretsProfile;
import org.exbin.bined.swing.extended.color.ColorsProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.extended.layout.LayoutProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.bined.swing.extended.theme.ThemeProfileCapableCodeAreaPainter;

@ParametersAreNonnullByDefault
public class ExtCodeArea
extends CodeAreaCore
implements ExtendedCodeArea,
CodeAreaSwingControl {
    @Nonnull
    private CodeAreaPainter painter;
    @Nonnull
    private final DefaultCodeAreaCaret caret;
    @Nonnull
    private final CodeAreaSelection selection = new CodeAreaSelection();
    @Nonnull
    private final CodeAreaScrollPosition scrollPosition = new CodeAreaScrollPosition();
    @Nonnull
    private Charset charset = Charset.defaultCharset();
    private ClipboardHandlingMode clipboardHandlingMode = ClipboardHandlingMode.PROCESS;
    @Nonnull
    private EditMode editMode = EditMode.EXPANDING;
    @Nonnull
    private EditOperation editOperation = EditOperation.OVERWRITE;
    @Nonnull
    private CodeAreaViewMode viewMode = CodeAreaViewMode.DUAL;
    @Nullable
    private Font codeFont;
    @Nonnull
    private AntialiasingMode antialiasingMode = AntialiasingMode.AUTO;
    @Nonnull
    private CodeType codeType = CodeType.HEXADECIMAL;
    private boolean showUnprintables;
    private int minRowPositionLength = 0;
    private int maxRowPositionLength = 0;
    @Nonnull
    private CodeCharactersCase codeCharactersCase = CodeCharactersCase.UPPER;
    private boolean showMirrorCursor = true;
    @Nonnull
    private PositionCodeType positionCodeType = PositionCodeType.HEXADECIMAL;
    @Nonnull
    private RowWrappingMode rowWrapping = RowWrappingMode.NO_WRAPPING;
    private int wrappingBytesGroupSize = 0;
    private int maxBytesPerRow = 16;
    @Nonnull
    private ScrollBarVisibility verticalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    @Nonnull
    private VerticalScrollUnit verticalScrollUnit = VerticalScrollUnit.ROW;
    @Nonnull
    private ScrollBarVisibility horizontalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    @Nonnull
    private ExtendedHorizontalScrollUnit horizontalScrollUnit = ExtendedHorizontalScrollUnit.PIXEL;
    private final List<CaretMovedListener> caretMovedListeners = new ArrayList<CaretMovedListener>();
    private final List<ScrollingListener> scrollingListeners = new ArrayList<ScrollingListener>();
    private final List<SelectionChangedListener> selectionChangedListeners = new ArrayList<SelectionChangedListener>();
    private final List<EditModeChangedListener> editModeChangedListeners = new ArrayList<EditModeChangedListener>();

    public ExtCodeArea() {
        this(DefaultCodeAreaCommandHandler.createDefaultCodeAreaCommandHandlerFactory());
    }

    public ExtCodeArea(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory) {
        super(commandHandlerFactory);
        this.caret = new DefaultCodeAreaCaret(this::notifyCaretChanged);
        this.painter = new ExtendedCodeAreaPainter(this);
        this.painter.attach();
        this.init();
    }

    private void init() {
        UIManager.addPropertyChangeListener(evt -> this.resetColors());
        this.caret.setSection((CodeAreaSection)BasicCodeAreaSection.CODE_MATRIX);
    }

    @Nonnull
    public CodeAreaPainter getPainter() {
        return this.painter;
    }

    public void setPainter(CodeAreaPainter painter) {
        CodeAreaUtils.requireNonNull((Object)painter);
        this.painter.detach();
        this.painter = painter;
        painter.attach();
        this.reset();
        this.repaint();
    }

    public boolean isInitialized() {
        return this.painter.isInitialized();
    }

    public void paintComponent(Graphics g) {
        this.painter.paintComponent(g);
    }

    public void updateUI() {
        super.updateUI();
        if (this.getBorder() == null) {
            super.setBorder(UIManager.getLookAndFeel().getDefaults().getBorder("TextAreaUI.border"));
        }
        this.painter.rebuildColors();
        this.painter.resetFont();
        this.painter.resetColors();
    }

    public void setBorder(@Nullable Border border) {
        super.setBorder(border);
        this.updateLayout();
    }

    @Nonnull
    public DefaultCodeAreaCaret getCaret() {
        return this.caret;
    }

    public boolean isShowMirrorCursor() {
        return this.showMirrorCursor;
    }

    public void setShowMirrorCursor(boolean showMirrorCursor) {
        this.showMirrorCursor = showMirrorCursor;
        this.updateLayout();
    }

    public int getMinRowPositionLength() {
        return this.minRowPositionLength;
    }

    public void setMinRowPositionLength(int minRowPositionLength) {
        this.minRowPositionLength = minRowPositionLength;
        this.updateLayout();
    }

    public int getMaxRowPositionLength() {
        return this.maxRowPositionLength;
    }

    public void setMaxRowPositionLength(int maxRowPositionLength) {
        this.maxRowPositionLength = maxRowPositionLength;
        this.updateLayout();
    }

    public long getDataPosition() {
        return this.caret.getDataPosition();
    }

    public int getCodeOffset() {
        return this.caret.getCodeOffset();
    }

    @Nonnull
    public CodeAreaSection getActiveSection() {
        return this.caret.getSection();
    }

    @Nonnull
    public CodeAreaCaretPosition getCaretPosition() {
        return this.caret.getCaretPosition();
    }

    public void setCaretPosition(CodeAreaCaretPosition caretPosition) {
        this.caret.setCaretPosition(caretPosition);
        this.notifyCaretMoved();
    }

    public void setCaretPosition(long dataPosition) {
        this.caret.setCaretPosition(dataPosition);
        this.notifyCaretMoved();
    }

    public void setCaretPosition(long dataPosition, int codeOffset) {
        this.caret.setCaretPosition(dataPosition, codeOffset);
        this.notifyCaretMoved();
    }

    public int getMouseCursorShape(int positionX, int positionY) {
        return this.painter.getMouseCursorShape(positionX, positionY);
    }

    @Nonnull
    public CodeCharactersCase getCodeCharactersCase() {
        return this.codeCharactersCase;
    }

    public void setCodeCharactersCase(CodeCharactersCase codeCharactersCase) {
        this.codeCharactersCase = codeCharactersCase;
        this.updateLayout();
    }

    public void resetColors() {
        this.painter.resetColors();
        this.repaint();
    }

    @Nonnull
    public CodeAreaViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(CodeAreaViewMode viewMode) {
        this.viewMode = viewMode;
        if (viewMode == CodeAreaViewMode.CODE_MATRIX) {
            this.caret.setSection((CodeAreaSection)BasicCodeAreaSection.CODE_MATRIX);
            this.notifyCaretMoved();
        } else if (viewMode == CodeAreaViewMode.TEXT_PREVIEW) {
            this.caret.setSection((CodeAreaSection)BasicCodeAreaSection.TEXT_PREVIEW);
            this.notifyCaretMoved();
        }
        this.updateLayout();
    }

    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    public void setCodeType(CodeType codeType) {
        this.codeType = codeType;
        this.validateCaret();
        this.updateLayout();
    }

    public void validateCaret() {
        boolean moved = false;
        if (this.caret.getDataPosition() > this.getDataSize()) {
            this.caret.setDataPosition(this.getDataSize());
            moved = true;
        }
        if (this.caret.getSection() == BasicCodeAreaSection.CODE_MATRIX && this.caret.getCodeOffset() >= this.codeType.getMaxDigitsForByte()) {
            this.caret.setCodeOffset(this.codeType.getMaxDigitsForByte() - 1);
            moved = true;
        }
        if (moved) {
            this.notifyCaretMoved();
        }
    }

    public void revealCursor() {
        this.revealPosition(this.caret.getCaretPosition());
    }

    public void revealPosition(CodeAreaCaretPosition caretPosition) {
        if (!this.isInitialized()) {
            return;
        }
        Optional revealScrollPosition = this.painter.computeRevealScrollPosition(caretPosition);
        revealScrollPosition.ifPresent(this::setScrollPosition);
    }

    public void revealPosition(long dataPosition, int dataOffset, CodeAreaSection section) {
        this.revealPosition((CodeAreaCaretPosition)new DefaultCodeAreaCaretPosition(dataPosition, dataOffset, section));
    }

    public void centerOnCursor() {
        this.centerOnPosition(this.caret.getCaretPosition());
    }

    public void centerOnPosition(CodeAreaCaretPosition caretPosition) {
        if (!this.isInitialized()) {
            return;
        }
        Optional centerOnScrollPosition = this.painter.computeCenterOnScrollPosition(caretPosition);
        centerOnScrollPosition.ifPresent(this::setScrollPosition);
    }

    public void centerOnPosition(long dataPosition, int dataOffset, CodeAreaSection section) {
        this.centerOnPosition((CodeAreaCaretPosition)new DefaultCodeAreaCaretPosition(dataPosition, dataOffset, section));
    }

    @Nonnull
    public CodeAreaCaretPosition mousePositionToClosestCaretPosition(int positionX, int positionY, CaretOverlapMode overflowMode) {
        return this.painter.mousePositionToClosestCaretPosition(positionX, positionY, overflowMode);
    }

    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction) {
        return this.painter.computeMovePosition(position, direction);
    }

    @Nonnull
    public CodeAreaScrollPosition computeScrolling(CodeAreaScrollPosition startPosition, ScrollingDirection scrollingShift) {
        return this.painter.computeScrolling(startPosition, scrollingShift);
    }

    protected void updateScrollBars() {
        this.painter.updateScrollBars();
        this.repaint();
    }

    @Nonnull
    public CodeAreaScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(CodeAreaScrollPosition scrollPosition) {
        if (!scrollPosition.equals((Object)this.scrollPosition)) {
            this.scrollPosition.setScrollPosition(scrollPosition);
            this.painter.scrollPositionModified();
            this.updateScrollBars();
            this.notifyScrolled();
        }
    }

    public void updateScrollPosition(CodeAreaScrollPosition scrollPosition) {
        if (!scrollPosition.equals((Object)this.scrollPosition)) {
            this.scrollPosition.setScrollPosition(scrollPosition);
            this.repaint();
            this.notifyScrolled();
        }
    }

    @Nonnull
    public ScrollBarVisibility getVerticalScrollBarVisibility() {
        return this.verticalScrollBarVisibility;
    }

    public void setVerticalScrollBarVisibility(ScrollBarVisibility verticalScrollBarVisibility) {
        this.verticalScrollBarVisibility = verticalScrollBarVisibility;
        this.resetPainter();
        this.updateScrollBars();
    }

    @Nonnull
    public VerticalScrollUnit getVerticalScrollUnit() {
        return this.verticalScrollUnit;
    }

    public void setVerticalScrollUnit(VerticalScrollUnit verticalScrollUnit) {
        this.verticalScrollUnit = verticalScrollUnit;
        long rowPosition = this.scrollPosition.getRowPosition();
        if (verticalScrollUnit == VerticalScrollUnit.ROW) {
            this.scrollPosition.setRowOffset(0);
        }
        this.resetPainter();
        this.scrollPosition.setRowPosition(rowPosition);
        this.updateScrollBars();
        this.notifyScrolled();
    }

    @Nonnull
    public ScrollBarVisibility getHorizontalScrollBarVisibility() {
        return this.horizontalScrollBarVisibility;
    }

    public void setHorizontalScrollBarVisibility(ScrollBarVisibility horizontalScrollBarVisibility) {
        this.horizontalScrollBarVisibility = horizontalScrollBarVisibility;
        this.resetPainter();
        this.updateScrollBars();
    }

    @Nonnull
    public ExtendedHorizontalScrollUnit getHorizontalScrollUnit() {
        return this.horizontalScrollUnit;
    }

    public void setHorizontalScrollUnit(ExtendedHorizontalScrollUnit horizontalScrollUnit) {
        this.horizontalScrollUnit = horizontalScrollUnit;
        int charPosition = this.scrollPosition.getCharPosition();
        if (horizontalScrollUnit == ExtendedHorizontalScrollUnit.CHARACTER) {
            this.scrollPosition.setCharOffset(0);
        }
        this.resetPainter();
        this.scrollPosition.setCharPosition(charPosition);
        this.updateScrollBars();
        this.notifyScrolled();
    }

    public void reset() {
        this.painter.reset();
    }

    public void updateLayout() {
        if (this.painter != null) {
            this.painter.resetLayout();
        }
        this.repaint();
    }

    public void repaint() {
        super.repaint();
    }

    public void resetPainter() {
        this.painter.reset();
    }

    protected void notifyCaretChanged() {
        if (this.painter != null) {
            this.painter.resetCaret();
        }
        this.repaint();
    }

    public void notifyDataChanged() {
        super.notifyDataChanged();
        this.updateLayout();
    }

    @Nonnull
    public AntialiasingMode getAntialiasingMode() {
        return this.antialiasingMode;
    }

    public void setAntialiasingMode(AntialiasingMode antialiasingMode) {
        this.antialiasingMode = antialiasingMode;
        this.reset();
        this.repaint();
    }

    @Nonnull
    public SelectionRange getSelection() {
        return this.selection.getRange();
    }

    public void setSelection(SelectionRange selectionRange) {
        this.selection.setRange((SelectionRange)CodeAreaUtils.requireNonNull((Object)selectionRange));
        this.notifySelectionChanged();
        this.repaint();
    }

    public void setSelection(long start, long end) {
        this.selection.setSelection(start, end);
        this.notifySelectionChanged();
        this.repaint();
    }

    public void clearSelection() {
        this.selection.clearSelection();
        this.notifySelectionChanged();
        this.repaint();
    }

    public boolean hasSelection() {
        return !this.selection.isEmpty();
    }

    @Nonnull
    public CodeAreaSelection getSelectionHandler() {
        return this.selection;
    }

    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        CodeAreaUtils.requireNonNull((Object)charset);
        this.charset = charset;
        this.reset();
        this.repaint();
    }

    public boolean isEditable() {
        return this.editMode != EditMode.READ_ONLY;
    }

    @Nonnull
    public EditMode getEditMode() {
        return this.editMode;
    }

    public void setEditMode(EditMode editMode) {
        boolean changed = editMode != this.editMode;
        this.editMode = editMode;
        if (changed) {
            this.editModeChangedListeners.forEach(listener -> listener.editModeChanged(editMode, this.getActiveOperation()));
            this.caret.resetBlink();
            this.notifyCaretChanged();
            this.repaint();
        }
    }

    @Nonnull
    public EditOperation getActiveOperation() {
        switch (this.editMode) {
            case READ_ONLY: {
                return EditOperation.INSERT;
            }
            case INPLACE: {
                return EditOperation.OVERWRITE;
            }
            case CAPPED: 
            case EXPANDING: {
                return this.editOperation;
            }
        }
        throw CodeAreaUtils.getInvalidTypeException((Enum)this.editMode);
    }

    @Nonnull
    public EditOperation getEditOperation() {
        return this.editOperation;
    }

    public void setEditOperation(EditOperation editOperation) {
        boolean changed;
        EditOperation previousOperation = this.getActiveOperation();
        this.editOperation = editOperation;
        EditOperation currentOperation = this.getActiveOperation();
        boolean bl = changed = previousOperation != currentOperation;
        if (changed) {
            this.editModeChangedListeners.forEach(listener -> listener.editModeChanged(this.editMode, currentOperation));
            this.caret.resetBlink();
            this.notifyCaretChanged();
            this.repaint();
        }
    }

    @Nonnull
    public ClipboardHandlingMode getClipboardHandlingMode() {
        return this.clipboardHandlingMode;
    }

    public void setClipboardHandlingMode(ClipboardHandlingMode clipboardHandlingMode) {
        this.clipboardHandlingMode = clipboardHandlingMode;
    }

    @Nonnull
    public Font getCodeFont() {
        return this.codeFont == null ? super.getFont() : this.codeFont;
    }

    public void setCodeFont(@Nullable Font codeFont) {
        this.codeFont = codeFont;
        this.painter.resetFont();
        this.repaint();
    }

    @Nonnull
    public PositionCodeType getPositionCodeType() {
        return this.positionCodeType;
    }

    public void setPositionCodeType(PositionCodeType positionCodeType) {
        this.positionCodeType = positionCodeType;
        this.updateLayout();
    }

    @Nonnull
    public RowWrappingMode getRowWrapping() {
        return this.rowWrapping;
    }

    public void setRowWrapping(RowWrappingMode rowWrapping) {
        this.rowWrapping = rowWrapping;
        this.updateLayout();
    }

    public int getWrappingBytesGroupSize() {
        return this.wrappingBytesGroupSize;
    }

    public void setWrappingBytesGroupSize(int groupSize) {
        this.wrappingBytesGroupSize = groupSize;
        this.updateLayout();
    }

    public int getMaxBytesPerRow() {
        return this.maxBytesPerRow;
    }

    public void setMaxBytesPerRow(int maxBytesPerRow) {
        this.maxBytesPerRow = maxBytesPerRow;
        this.updateLayout();
    }

    @Override
    @Nullable
    public CodeAreaColorsProfile getColorsProfile() {
        if (this.painter instanceof ColorsProfileCapableCodeAreaPainter) {
            return ((ColorsProfileCapableCodeAreaPainter)this.painter).getColorsProfile();
        }
        return null;
    }

    @Override
    public void setColorsProfile(CodeAreaColorsProfile colorsProfile) {
        if (this.painter instanceof ColorsProfileCapableCodeAreaPainter) {
            ((ColorsProfileCapableCodeAreaPainter)this.painter).setColorsProfile(colorsProfile);
        }
    }

    @Override
    @Nullable
    public ExtendedCodeAreaLayoutProfile getLayoutProfile() {
        if (this.painter instanceof LayoutProfileCapableCodeAreaPainter) {
            return ((LayoutProfileCapableCodeAreaPainter)this.painter).getLayoutProfile();
        }
        return null;
    }

    @Override
    public void setLayoutProfile(ExtendedCodeAreaLayoutProfile layoutProfile) {
        if (this.painter instanceof LayoutProfileCapableCodeAreaPainter) {
            ((LayoutProfileCapableCodeAreaPainter)this.painter).setLayoutProfile(layoutProfile);
        }
    }

    @Override
    @Nullable
    public ExtendedCodeAreaThemeProfile getThemeProfile() {
        if (this.painter instanceof ThemeProfileCapableCodeAreaPainter) {
            return ((ThemeProfileCapableCodeAreaPainter)this.painter).getThemeProfile();
        }
        return null;
    }

    @Override
    public void setThemeProfile(ExtendedCodeAreaThemeProfile themeProfile) {
        if (this.painter instanceof ThemeProfileCapableCodeAreaPainter) {
            ((ThemeProfileCapableCodeAreaPainter)this.painter).setThemeProfile(themeProfile);
        }
    }

    @Override
    @Nullable
    public ExtendedCodeAreaCaretsProfile getCaretsProfile() {
        if (this.painter instanceof CaretsProfileCapableCodeAreaPainter) {
            return ((CaretsProfileCapableCodeAreaPainter)this.painter).getCaretsProfile();
        }
        return null;
    }

    @Override
    public void setCaretsProfile(ExtendedCodeAreaCaretsProfile caretsProfile) {
        if (this.painter instanceof CaretsProfileCapableCodeAreaPainter) {
            ((CaretsProfileCapableCodeAreaPainter)this.painter).setCaretsProfile(caretsProfile);
        }
    }

    public boolean isShowUnprintables() {
        return this.showUnprintables;
    }

    public void setShowUnprintables(boolean show) {
        this.showUnprintables = show;
        this.updateLayout();
    }

    public void notifySelectionChanged() {
        this.selectionChangedListeners.forEach(SelectionChangedListener::selectionChanged);
    }

    protected void notifyCaretMoved() {
        this.caretMovedListeners.forEach(caretMovedListener -> caretMovedListener.caretMoved(this.caret.getCaretPosition()));
    }

    protected void notifyScrolled() {
        this.painter.resetLayout();
        this.scrollingListeners.forEach(ScrollingListener::scrolled);
    }

    public void addSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListeners.add(selectionChangedListener);
    }

    public void removeSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListeners.remove(selectionChangedListener);
    }

    public void addCaretMovedListener(CaretMovedListener caretMovedListener) {
        this.caretMovedListeners.add(caretMovedListener);
    }

    public void removeCaretMovedListener(CaretMovedListener caretMovedListener) {
        this.caretMovedListeners.remove(caretMovedListener);
    }

    public void addScrollingListener(ScrollingListener scrollingListener) {
        this.scrollingListeners.add(scrollingListener);
    }

    public void removeScrollingListener(ScrollingListener scrollingListener) {
        this.scrollingListeners.remove(scrollingListener);
    }

    public void addEditModeChangedListener(EditModeChangedListener editModeChangedListener) {
        this.editModeChangedListeners.add(editModeChangedListener);
    }

    public void removeEditModeChangedListener(EditModeChangedListener editModeChangedListener) {
        this.editModeChangedListeners.remove(editModeChangedListener);
    }
}

