/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.parser_tree.XBTTree;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class XBTTreeDocument
extends XBTTree
implements XBTEditableDocument {
    private boolean modified;
    @Nullable
    private String fileName;
    @Nullable
    private XBData tailData;

    public XBTTreeDocument() {
        super(null);
        this.tailData = null;
    }

    public XBTTreeDocument(@Nullable XBTTreeNode rootNode) {
        this();
        super.setRoot(rootNode);
    }

    public XBTTreeDocument(@Nullable XBCatalog catalog) {
        super(catalog);
    }

    @Override
    public int toStreamUB(OutputStream stream) throws IOException {
        int size = XBHead.writeXBUPHead((OutputStream)stream);
        size += super.toStreamUB(stream);
        if (this.tailData != null) {
            size = (int)((long)size + this.tailData.getDataSize());
            if (!this.tailData.isEmpty()) {
                this.tailData.saveToStream(stream);
            }
        }
        return size;
    }

    @Override
    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        int size = XBHead.checkXBUPHead((InputStream)stream);
        this.clear();
        if (stream.available() > 0) {
            size += super.fromStreamUB(stream);
            this.setTailData(stream);
        }
        return (int)((long)size + this.getTailDataSize());
    }

    @Override
    public int getSizeUB() {
        int size = XBHead.getXBUPHeadSize();
        size += super.getSizeUB();
        if (this.tailData != null) {
            size = (int)((long)size + this.getTailDataSize());
        }
        return size;
    }

    @Nonnull
    public Optional<InputStream> getTailData() {
        if (this.tailData == null) {
            return Optional.empty();
        }
        return Optional.of(this.tailData.getDataInputStream());
    }

    @Nullable
    public BinaryData getTailDataArray() {
        return this.tailData;
    }

    public void setTailData(@Nullable InputStream source) throws IOException {
        if (source == null) {
            this.tailData = null;
        } else {
            this.tailData = new XBData();
            this.tailData.loadFromStream(source);
        }
    }

    public long getTailDataSize() {
        if (this.tailData == null) {
            return 0L;
        }
        return this.tailData.getDataSize();
    }

    @Override
    public void clear() {
        super.clear();
        if (this.tailData != null) {
            this.tailData = null;
        }
    }

    @Override
    @Nonnull
    public Optional<XBTBlock> getRootBlock() {
        return Optional.ofNullable(this.getRoot());
    }

    public void setRootBlock(@Nullable XBTBlock block) {
        if (block != null && !(block instanceof XBTTreeNode)) {
            throw new IllegalArgumentException("Unsupported type of root block");
        }
        super.setRoot((XBTTreeNode)block);
    }

    public boolean wasModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(@Nullable String fileName) {
        this.fileName = fileName;
    }

    public int fromFileUB() throws IOException, XBProcessingException {
        int size;
        try (FileInputStream stream = new FileInputStream(this.fileName);){
            size = this.fromStreamUB(stream);
        }
        this.modified = false;
        return size;
    }

    public int toFileUB() throws IOException {
        int size;
        try (FileOutputStream stream = new FileOutputStream(this.fileName);){
            size = this.toStreamUB(stream);
        }
        this.modified = false;
        return size;
    }

    @Override
    public void processSpec() {
        super.processSpec();
    }

    @Nonnull
    public Optional<XBTBlock> findBlockByIndex(long index) {
        return super.findNodeByIndex(index);
    }

    @Nonnull
    public XBTBlock createNewBlock(@Nullable XBTBlock parent) {
        return this.newNodeInstance((XBTTreeNode)parent);
    }

    public long getDocumentSize() {
        long documentSize = this.getTailDataSize();
        XBTTreeNode rootBlock = this.getRoot();
        if (rootBlock != null) {
            documentSize += rootBlock.getBlockSize();
        }
        return documentSize;
    }
}

