/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.parser_tree.XBBlockToXBTBlock;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class XBTBlockToXBBlock
implements XBEditableBlock {
    private final XBTBlock block;
    private int typeAttributesCount = 2;

    public XBTBlockToXBBlock(XBTBlock block) {
        XBBlockType blockType;
        this.block = block;
        if (block instanceof XBTTreeNode) {
            this.typeAttributesCount = ((XBTTreeNode)block).getSingleAttributeType() ? 1 : 2;
        } else if (block != null && (blockType = block.getBlockType()) instanceof XBFixedBlockType) {
            this.typeAttributesCount = ((XBFixedBlockType)blockType).getBlockID().isZero() ? 1 : 2;
        }
    }

    public XBTBlock getBlock() {
        return this.block;
    }

    @Nonnull
    public Optional<XBBlock> getParentBlock() {
        XBTBlock parent = this.block.getParentBlock().orElse(null);
        if (parent instanceof XBBlockToXBTBlock) {
            return Optional.of(((XBBlockToXBTBlock)parent).getBlock());
        }
        return parent == null ? Optional.empty() : Optional.of(new XBTBlockToXBBlock(parent));
    }

    public XBBlockDataMode getDataMode() {
        return this.block.getDataMode();
    }

    public XBBlockTerminationMode getTerminationMode() {
        return this.block.getTerminationMode();
    }

    public XBAttribute[] getAttributes() {
        int attributesCount = this.getAttributesCount();
        XBAttribute[] result = new XBAttribute[attributesCount];
        if (attributesCount > 0) {
            result[0] = this.getAttributeAt(0);
            if (attributesCount > 1) {
                result[1] = this.getAttributeAt(1);
                if (attributesCount > 2) {
                    System.arraycopy(this.block.getAttributes(), 0, result, 2, attributesCount - 2);
                }
            }
        }
        return result;
    }

    public XBAttribute getAttributeAt(int attributeIndex) {
        if (attributeIndex < 2) {
            if (this.block instanceof XBTTreeNode) {
                XBFixedBlockType blockType = ((XBTTreeNode)this.block).getFixedBlockType();
                return attributeIndex == 0 ? blockType.getGroupID() : blockType.getBlockID();
            }
            XBBlockType blockType = this.block.getBlockType();
            if (blockType instanceof XBFixedBlockType) {
                return attributeIndex == 0 ? ((XBFixedBlockType)blockType).getGroupID() : ((XBFixedBlockType)blockType).getBlockID();
            }
            throw new IllegalStateException("Cannot convert block with no fixed block type");
        }
        return this.block.getAttributeAt(attributeIndex - 2);
    }

    public int getAttributesCount() {
        if (this.block.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
            return 0;
        }
        int attributesCount = this.block.getAttributesCount();
        if (attributesCount > 0) {
            return attributesCount + 2;
        }
        return this.typeAttributesCount;
    }

    public XBBlock[] getChildren() {
        XBBlock[] result = new XBBlock[this.getChildrenCount()];
        int i = 0;
        for (XBTBlock child : this.block.getChildren()) {
            result[i++] = new XBTBlockToXBBlock(child);
        }
        return result;
    }

    public XBBlock getChildAt(int childIndex) {
        return new XBTBlockToXBBlock(this.block.getChildAt(childIndex));
    }

    public int getChildrenCount() {
        return this.block.getChildrenCount();
    }

    @Nonnull
    public InputStream getData() {
        return this.block.getData();
    }

    @Nonnull
    public BinaryData getBlockData() {
        return this.block.getBlockData();
    }

    public void setParent(XBBlock parent) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set parent of read only block");
        }
        if (parent instanceof XBTBlockToXBBlock) {
            ((XBTEditableBlock)this.block).setParent(((XBTBlockToXBBlock)parent).block);
        } else {
            ((XBTEditableBlock)this.block).setParent((XBTBlock)(parent == null ? null : new XBBlockToXBTBlock(parent)));
        }
    }

    public void setTerminationMode(XBBlockTerminationMode terminationMode) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set termination mode of read only block");
        }
        ((XBTEditableBlock)this.block).setTerminationMode(terminationMode);
    }

    public void setDataMode(XBBlockDataMode dataMode) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set data mode of read only block");
        }
        ((XBTEditableBlock)this.block).setDataMode(dataMode);
    }

    public void setAttributes(XBAttribute[] attributes) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        if (attributes.length >= 2) {
            XBAttribute[] result = new XBAttribute[attributes.length - 2];
            System.arraycopy(this.block.getAttributes(), 0, result, 0, attributes.length - 2);
            ((XBTEditableBlock)this.block).setAttributes(result);
            this.typeAttributesCount = 2;
        } else {
            this.setAttributesCount(attributes.length);
            this.typeAttributesCount = attributes.length;
        }
        if (attributes.length > 0) {
            this.setAttributeAt(attributes[0], 0);
        }
        if (attributes.length > 1) {
            this.setAttributeAt(attributes[1], 1);
        }
    }

    public void setAttributeAt(XBAttribute attribute, int attributeIndex) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        if (attributeIndex >= 2) {
            ((XBTEditableBlock)this.block).setAttributeAt(attribute, attributeIndex - 2);
            this.typeAttributesCount = 2;
        } else {
            XBBlockType blockType = this.block.getBlockType();
            if (blockType instanceof XBFixedBlockType) {
                blockType = attributeIndex == 0 ? new XBFixedBlockType(attribute.getNaturalLong(), ((XBFixedBlockType)blockType).getBlockID().getLong()) : new XBFixedBlockType(((XBFixedBlockType)blockType).getGroupID().getLong(), attribute.getNaturalLong());
                ((XBTEditableBlock)this.block).setBlockType(blockType);
                if (attributeIndex >= this.typeAttributesCount) {
                    this.typeAttributesCount = attributeIndex + 1;
                }
                if (this.typeAttributesCount == 1 && this.block instanceof XBTTreeNode) {
                    ((XBTTreeNode)this.block).setSingleAttributeType(true);
                }
            } else {
                throw new IllegalStateException("Cannot set block type when it's not fixed");
            }
        }
    }

    public void setAttributesCount(int count) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute count of read only block");
        }
        if (count >= 2) {
            ((XBTEditableBlock)this.block).setAttributesCount(count - 2);
        } else {
            ((XBTEditableBlock)this.block).setAttributesCount(0);
            this.typeAttributesCount = 0;
            if (this.block instanceof XBTTreeNode) {
                ((XBTTreeNode)this.block).setSingleAttributeType(true);
            }
        }
    }

    public void removeAttribute(int attributeIndex) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot remove attribute count of read only block");
        }
        if (attributeIndex <= 1) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        ((XBEditableBlock)this.block).removeAttribute(attributeIndex - 2);
    }

    public void setChildren(XBBlock[] blocks) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set child of read only block");
        }
        XBTBlock[] convertedBlocks = new XBTBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            XBBlock child = blocks[i];
            if (child instanceof XBBlockToXBTBlock) continue;
            convertedBlocks[i] = new XBBlockToXBTBlock(child);
        }
        ((XBTEditableBlock)this.block).setChildren(convertedBlocks);
    }

    public void setChildAt(XBBlock child, int childIndex) {
        if (!(child instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        if (!(child instanceof XBBlockToXBTBlock)) {
            ((XBTEditableBlock)this.block).setChildAt((XBTBlock)new XBBlockToXBTBlock(child), childIndex);
        }
    }

    public void setChildrenCount(int count) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        ((XBTEditableBlock)this.block).setChildrenCount(count);
    }

    public void removeChild(int childIndex) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot remove child of read only block");
        }
        ((XBTEditableBlock)this.block).removeChild(childIndex);
    }

    public void setData(InputStream data) throws IOException {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set data of read only block");
        }
        ((XBTEditableBlock)this.block).setData(data);
    }

    public void setData(BinaryData data) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set data of read only block");
        }
        ((XBTEditableBlock)this.block).setData(data);
    }

    public void clear() {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot clear data of read only block");
        }
        ((XBTEditableBlock)this.block).clear();
        this.typeAttributesCount = 0;
    }

    public XBBlock createNewChild(int childIndex) {
        if (!(this.block instanceof XBTEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        XBTBlock childBlock = ((XBTEditableBlock)this.block).createNewChild(childIndex);
        return new XBTBlockToXBBlock(childBlock);
    }
}

