/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.window.AbstractScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.WindowConfiguration;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Workarounds;
import javax.swing.Icon;
import javax.swing.JFrame;

public class ScreenDockFrame
extends AbstractScreenDockWindow {
    private JFrame frame = new JFrame();

    public ScreenDockFrame(ScreenDockStation station, WindowConfiguration configuration, boolean undecorated) {
        super(station, configuration);
        this.init(undecorated, configuration);
    }

    private void init(boolean undecorated, WindowConfiguration configuration) {
        if (undecorated) {
            this.frame.setUndecorated(true);
            this.frame.getRootPane().setWindowDecorationStyle(0);
        }
        this.frame.setDefaultCloseOperation(0);
        this.init(this.frame, this.frame.getContentPane(), configuration, undecorated);
        if (configuration.isTransparent()) {
            Workarounds.getDefault().makeTransparent(this.frame);
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void destroy() {
        this.frame.dispose();
    }

    public void toFront() {
        this.frame.toFront();
    }

    protected void updateTitleText() {
        this.frame.setTitle(this.getTitleText());
    }

    public void setPreventFocusStealing(boolean prevent) {
        this.frame.setFocusableWindowState(!prevent);
    }

    protected void updateTitleIcon() {
        Icon icon = this.getTitleIcon();
        if (icon == null) {
            this.frame.setIconImage(null);
        } else {
            this.frame.setIconImage(DockUtilities.iconImage(icon));
        }
    }
}

