/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import java.util.ArrayList;
import java.util.List;

public class DefaultLocationEstimationMap
implements LocationEstimationMap {
    private Node root;

    public DefaultLocationEstimationMap(DockLayoutComposition root) {
        this(new Node(root, false));
    }

    private DefaultLocationEstimationMap(Node root) {
        this.root = root;
    }

    public void prepare() {
        this.root.prepare();
    }

    public DefaultLocationEstimationMap subMap(int childIndex) {
        return new DefaultLocationEstimationMap(this.root.children.get(childIndex));
    }

    public DockLayoutComposition getRoot() {
        return this.root.composition;
    }

    public void finish() {
        for (Node child : this.root.children) {
            DockableProperty newParentLocation = child.validLocation();
            for (Node leaf : child.leafs) {
                leaf.finish(newParentLocation);
            }
            for (Node grandchild : child.children) {
                grandchild.finish(newParentLocation);
            }
        }
    }

    public int getChildCount() {
        return this.root.children.size();
    }

    public DockLayoutInfo getChild(int childIndex) {
        if (childIndex < 0 || childIndex >= this.getChildCount()) {
            return null;
        }
        return this.root.children.get((int)childIndex).composition.getLayout();
    }

    public int getSubChildCount(int childIndex) {
        return this.root.children.get((int)childIndex).leafs.size();
    }

    public DockLayoutInfo getSubChild(int childIndex, int subChildIndex) {
        return this.root.children.get((int)childIndex).leafs.get((int)subChildIndex).composition.getLayout();
    }

    public void setLocation(int childIndex, DockableProperty location) {
        if (location != null) {
            this.getChild(childIndex).setLocation(location);
        }
    }

    public void setLocation(int childIndex, int subChildIndex, DockableProperty location) {
        if (location != null) {
            this.getSubChild(childIndex, subChildIndex).setLocation(location);
        }
    }

    private static class Node {
        public final DockLayoutComposition composition;
        private DockableProperty oldLocation;
        private boolean valid = true;
        public final List<Node> children = new ArrayList<Node>();
        public final List<Node> leafs;

        public Node(DockLayoutComposition composition, boolean collectLeafs) {
            this.leafs = collectLeafs ? new ArrayList<Node>() : null;
            this.composition = composition;
            for (DockLayoutComposition child : composition.getChildren()) {
                Node childNode = new Node(child, true);
                this.children.add(childNode);
                if (!collectLeafs) continue;
                if (childNode.isLeaf()) {
                    this.leafs.add(childNode);
                    continue;
                }
                this.leafs.addAll(childNode.leafs);
            }
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public void prepare() {
            if (this.valid) {
                this.oldLocation = this.composition.getLayout().getLocation();
                for (Node child : this.children) {
                    child.prepare();
                }
            }
        }

        public void finish(DockableProperty newParentLocation) {
            if (this.valid) {
                DockableProperty newLeafLocation = this.validLocation();
                if (newLeafLocation == null && newParentLocation != null) {
                    newLeafLocation = newParentLocation.copy();
                }
                if (newLeafLocation != null) {
                    newLeafLocation.setSuccessor(this.oldLocation);
                    this.composition.getLayout().setLocation(newLeafLocation);
                } else {
                    this.invalidate();
                }
            }
        }

        public void invalidate() {
            this.valid = false;
        }

        public DockableProperty validLocation() {
            DockableProperty location = this.composition.getLayout().getLocation();
            if (location != this.oldLocation) {
                return location;
            }
            return null;
        }
    }
}

