/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.control.focus.FocusStrategyRequest;
import bibliothek.gui.dock.control.focus.FocusTracker;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class DefaultFocusStrategy
implements FocusStrategy {
    private DockController controller;
    private Map<Component, Tracker> trackers = new HashMap<Component, Tracker>();
    private DockRegisterListener listener = new DockRegisterAdapter(){

        public void dockableRegistered(DockController controller, Dockable dockable) {
            DefaultFocusStrategy.this.add(dockable);
        }

        public void dockableUnregistered(DockController controller, Dockable dockable) {
            DefaultFocusStrategy.this.remove(dockable);
        }
    };

    public DefaultFocusStrategy(DockController controller) {
        this.controller = controller;
    }

    public boolean shouldFocusAfterDrop(Dockable dockable) {
        return !(dockable.getDockParent() instanceof FlapDockStation);
    }

    protected boolean focusable(Component component, FocusStrategyRequest request) {
        while (component != null) {
            if (component instanceof JComboBox) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    protected boolean excluded(Component component, FocusStrategyRequest request) {
        return request.excluded(component);
    }

    public Component getFocusComponent(FocusStrategyRequest request) {
        Component mouseClicked = request.getMouseClicked();
        Dockable dockable = request.getDockable();
        if (mouseClicked != null && (mouseClicked.isFocusable() && !this.excluded(mouseClicked, request) || this.focusable(mouseClicked, request))) {
            return mouseClicked;
        }
        Tracker tracker = this.trackers.get(dockable.getComponent());
        if (tracker == null) {
            return null;
        }
        return tracker.getLastFocused();
    }

    public void bind() {
        DockRegister register = this.controller.getRegister();
        register.addDockRegisterListener(this.listener);
        int n = register.getDockableCount();
        for (int i = 0; i < n; ++i) {
            this.add(register.getDockable(i));
        }
    }

    public void unbind() {
        this.controller.getRegister().removeDockRegisterListener(this.listener);
        for (Tracker tracker : this.trackers.values()) {
            tracker.destroy();
        }
        this.trackers.clear();
    }

    private void add(Dockable dockable) {
        Tracker tracker = new Tracker(dockable);
        for (Tracker other : this.trackers.values()) {
            if (!SwingUtilities.isDescendingFrom(dockable.getComponent(), other.dockable.getComponent())) continue;
            other.remove(dockable.getComponent());
        }
        this.trackers.put(dockable.getComponent(), tracker);
    }

    private void remove(Dockable dockable) {
        Tracker tracker = this.trackers.remove(dockable.getComponent());
        if (tracker != null) {
            tracker.destroy();
        }
    }

    private class Tracker
    extends FocusTracker {
        private Dockable dockable;

        public Tracker(Dockable dockable) {
            super(dockable.getComponent());
            this.dockable = dockable;
        }

        protected void add(Component component) {
            if (!DefaultFocusStrategy.this.trackers.containsKey(component)) {
                super.add(component);
            }
        }
    }
}

