/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.HierarchyDockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.dockable.DockHierarchyObserver;
import bibliothek.gui.dock.dockable.DockableStateListener;
import bibliothek.gui.dock.dockable.DockableStateListenerManager;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockStationIcon;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.NoStationDropOperation;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.split.DefaultSplitDividerStrategy;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.DefaultSplitNodeFactory;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDividerStrategy;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockCombinerSource;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockGrid;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockTreeFactory;
import bibliothek.gui.dock.station.split.SplitFullScreenAction;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeFactory;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitPlaceholderConverter;
import bibliothek.gui.dock.station.split.SplitPlaceholderSet;
import bibliothek.gui.dock.station.split.SplitSpanStrategy;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.split.layer.SideSnapDropLayer;
import bibliothek.gui.dock.station.split.layer.SplitOverrideDropLayer;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.ComponentDragOperation;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.gui.dock.station.support.RootPlaceholderStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.StationCombinerValue;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockStation
extends SecureContainer
implements Dockable,
DockStation {
    public static final String TITLE_ID = "split";
    public static final String DISPLAYER_ID = "split";
    public static final PropertyKey<KeyStroke> MAXIMIZE_ACCELERATOR = new PropertyKey("SplitDockStation maximize accelerator");
    public static final PropertyKey<SplitLayoutManager> LAYOUT_MANAGER = new PropertyKey<DefaultSplitLayoutManager>("SplitDockStation layout manager", new ConstantPropertyFactory<DefaultSplitLayoutManager>(new DefaultSplitLayoutManager()), true);
    public static final PropertyKey<SplitDividerStrategy> DIVIDER_STRATEGY = new PropertyKey<SplitDividerStrategy>("SplitDockStation divider strategy", new DynamicPropertyFactory<SplitDividerStrategy>(){

        @Override
        public SplitDividerStrategy getDefault(PropertyKey<SplitDividerStrategy> key, DockProperties properties) {
            return new DefaultSplitDividerStrategy();
        }

        @Override
        public SplitDividerStrategy getDefault(PropertyKey<SplitDividerStrategy> key) {
            return null;
        }
    }, true);
    private DockStation parent;
    private VisibleListener visibleListener = new VisibleListener();
    private DockController controller;
    private DockTheme theme;
    private StationCombinerValue combiner;
    private DockTitleVersion title;
    private List<DockableListener> dockableListeners = new ArrayList<DockableListener>();
    private DockableStateListenerManager dockableStateListeners;
    private DockHierarchyObserver hierarchyObserver;
    private List<SplitDockListener> splitListeners = new ArrayList<SplitDockListener>();
    private DockableShowingManager visibility;
    private List<DockTitle> titles = new LinkedList<DockTitle>();
    private HierarchyDockActionSource globalSource;
    protected DockStationListenerManager dockStationListeners = new DockStationListenerManager(this);
    private PropertyValue<String> titleText = new PropertyValue<String>(PropertyKey.DOCK_STATION_TITLE){

        @Override
        protected void valueChanged(String oldValue, String newValue) {
            if (oldValue == null) {
                oldValue = "";
            }
            if (newValue == null) {
                newValue = "";
            }
            for (DockableListener listener : SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()])) {
                listener.titleTextChanged(SplitDockStation.this, oldValue, newValue);
            }
        }
    };
    private DockIcon titleIcon;
    private PropertyValue<String> titleToolTip = new PropertyValue<String>(PropertyKey.DOCK_STATION_TOOLTIP){

        @Override
        protected void valueChanged(String oldValue, String newValue) {
            for (DockableListener listener : SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()])) {
                listener.titleToolTipChanged(SplitDockStation.this, oldValue, newValue);
            }
        }
    };
    private PropertyValue<SplitLayoutManager> layoutManager = new PropertyValue<SplitLayoutManager>(LAYOUT_MANAGER){

        @Override
        protected void valueChanged(SplitLayoutManager oldValue, SplitLayoutManager newValue) {
            if (oldValue != null) {
                oldValue.uninstall(SplitDockStation.this);
            }
            if (newValue != null) {
                newValue.install(SplitDockStation.this);
            }
        }
    };
    private PropertyValue<SplitDividerStrategy> dividerStrategy = new PropertyValue<SplitDividerStrategy>(DIVIDER_STRATEGY){

        @Override
        protected void valueChanged(SplitDividerStrategy oldValue, SplitDividerStrategy newValue) {
            if (oldValue != null) {
                oldValue.uninstall(SplitDockStation.this);
            }
            if (newValue != null && SplitDockStation.this.content != null) {
                newValue.install(SplitDockStation.this, SplitDockStation.this.getContentPane());
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategyProperty = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy oldValue, PlaceholderStrategy newValue) {
            SplitDockStation.this.placeholderStrategy.setStrategy(newValue);
        }
    };
    private PropertyValue<DisablingStrategy> disablingStrategy = new PropertyValue<DisablingStrategy>(DisablingStrategy.STRATEGY){

        @Override
        protected void valueChanged(DisablingStrategy oldValue, DisablingStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeDisablingStrategyListener(SplitDockStation.this.disablingStrategyListener);
            }
            if (newValue != null) {
                newValue.addDisablingStrategyListener(SplitDockStation.this.disablingStrategyListener);
                SplitDockStation.this.setDisabled(newValue.isDisabled(SplitDockStation.this));
            } else {
                SplitDockStation.this.setDisabled(false);
            }
        }
    };
    private DisablingStrategyListener disablingStrategyListener = new DisablingStrategyListener(){

        public void changed(DockElement item) {
            if (item == SplitDockStation.this) {
                SplitDockStation.this.setDisabled(((DisablingStrategy)SplitDockStation.this.disablingStrategy.getValue()).isDisabled(item));
            }
        }
    };
    private RootPlaceholderStrategy placeholderStrategy = new RootPlaceholderStrategy(this);
    private boolean expandOnDoubleclick = true;
    private FullScreenListener fullScreenListener = new FullScreenListener();
    private List<StationChildHandle> dockables = new ArrayList<StationChildHandle>();
    private Dockable frontDockable;
    private StationChildHandle fullScreenDockable;
    private ListeningDockAction fullScreenAction;
    private int dividerSize = 4;
    private float sideSnapSize = 0.25f;
    private int borderSideSnapSize = 25;
    private boolean allowSideSnap = true;
    private Access access = new Access();
    private Root root;
    private SplitNodeFactory nodeFactory = new DefaultSplitNodeFactory();
    private SplitPlaceholderSet placeholderSet;
    private int treeLock = 0;
    private PutInfo putInfo;
    private SplitSpanStrategy spanStrategy;
    private ComponentDragOperation dragInfo;
    private DefaultStationPaintValue paint;
    private DefaultDisplayerFactoryValue displayerFactory;
    private DisplayerCollection displayers;
    private boolean resizingEnabled = true;
    private boolean continousDisplay = false;
    private DockableDisplayerHints hints;
    private Content content;
    private Background background = new Background();
    private boolean disabled = false;
    private Dimension minimumLeafSize = new Dimension(20, 20);

    public SplitDockStation() {
        this(true);
    }

    public SplitDockStation(boolean createFullScreenAction) {
        this.content = new Content();
        this.content.setBackground(this.background);
        this.setBasePane(this.content);
        this.hierarchyObserver = new DockHierarchyObserver(this);
        this.placeholderSet = new SplitPlaceholderSet(this.access);
        this.dockableStateListeners = new DockableStateListenerManager(this);
        this.paint = new DefaultStationPaintValue("dock.paint.split", this);
        this.combiner = new StationCombinerValue("dock.combiner.split", this);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.split", this);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, "split");
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            public void discard(DockableDisplayer displayer) {
                SplitDockStation.this.discard(displayer);
            }

            public void moveableElementChanged(DockableDisplayer displayer) {
            }
        });
        if (createFullScreenAction) {
            this.fullScreenAction = this.createFullScreenAction();
        }
        this.visibility = new DockableShowingManager(this.dockStationListeners);
        SplitDividerStrategy strategy = this.dividerStrategy.getValue();
        if (strategy != null) {
            strategy.install(this, this.getContentPane());
        }
        this.globalSource = new HierarchyDockActionSource(this);
        this.globalSource.bind();
        this.spanStrategy = new SplitSpanStrategy(this);
        this.titleIcon = new DockStationIcon("dockStation.default", this){

            protected void changed(Icon oldValue, Icon newValue) {
                for (DockableListener listener : SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()])) {
                    listener.titleIconChanged(SplitDockStation.this, oldValue, newValue);
                }
            }
        };
        this.addDockStationListener(new DockStationAdapter(){

            public void dockableAdded(DockStation station, Dockable dockable) {
                SplitDockStation.this.updateConfigurableDisplayerHints();
            }

            public void dockableRemoved(DockStation station, Dockable dockable) {
                SplitDockStation.this.updateConfigurableDisplayerHints();
            }
        });
        this.placeholderStrategy.addListener(new PlaceholderStrategyListener(){

            @Override
            public void placeholderInvalidated(Set<Path> placeholders) {
                SplitDockStation.this.removePlaceholders(placeholders);
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (SplitDockStation.this.getDockParent() == null) {
                        SplitDockStation.this.dockableStateListeners.checkShowing();
                    }
                    SplitDockStation.this.visibility.fire();
                }
            }
        });
    }

    protected final Root root() {
        if (this.root == null) {
            this.root = this.access.createRoot(-1L);
        }
        return this.root;
    }

    @Override
    public String toString() {
        if (this.root == null) {
            return super.toString();
        }
        return this.root.toString();
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension base = this.getRoot().getMinimumSize();
        if (insets != null) {
            base = new Dimension(base.width + insets.left + insets.right, base.height + insets.top + insets.bottom);
        }
        return base;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension base = this.getRoot().getPreferredSize();
        if (insets != null) {
            base = new Dimension(base.width + insets.left + insets.right, base.height + insets.top + insets.bottom);
        }
        return base;
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme newTheme;
        DockController controller = this.getController();
        if (controller != null && (newTheme = controller.getTheme()) != this.theme) {
            this.theme = newTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new SplitDockStationFactory());
    }

    protected ListeningDockAction createFullScreenAction() {
        return new SplitFullScreenAction(this);
    }

    public void setFullScreenAction(ListeningDockAction fullScreenAction) {
        if (this.fullScreenAction != null) {
            throw new IllegalStateException("The fullScreenAction can only be set once");
        }
        this.fullScreenAction = fullScreenAction;
    }

    public void setExpandOnDoubleclick(boolean expandOnDoubleclick) {
        this.expandOnDoubleclick = expandOnDoubleclick;
    }

    public boolean isExpandOnDoubleclick() {
        return this.expandOnDoubleclick;
    }

    public void setResizingEnabled(boolean resizingEnabled) {
        this.resizingEnabled = resizingEnabled;
    }

    public boolean isResizingEnabled() {
        return this.resizingEnabled;
    }

    protected void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (disabled) {
            this.setCursor(null);
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDockParent(DockStation station) {
        if (this.parent != null) {
            this.parent.removeDockStationListener(this.visibleListener);
        }
        this.parent = station;
        if (station != null) {
            station.addDockStationListener(this.visibleListener);
        }
        this.hierarchyObserver.update();
    }

    @Override
    public DockStation getDockParent() {
        return this.parent;
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.getDoubleClickController().removeListener(this.fullScreenListener);
            }
            for (StationChildHandle handle : this.dockables) {
                handle.setTitleRequest(null);
            }
            this.controller = controller;
            this.getDisplayers().setController(controller);
            if (this.fullScreenAction != null) {
                this.fullScreenAction.setController(controller);
            }
            this.titleIcon.setController(controller);
            this.titleText.setProperties(controller);
            this.layoutManager.setProperties(controller);
            this.placeholderStrategyProperty.setProperties(controller);
            this.paint.setController(controller);
            this.displayerFactory.setController(controller);
            this.combiner.setController(controller);
            this.background.setController(controller);
            this.dividerStrategy.setProperties(controller);
            this.disablingStrategy.setProperties(controller);
            this.spanStrategy.setController(controller);
            if (controller != null) {
                this.title = controller.getDockTitleManager().getVersion("split", ControllerTitleFactory.INSTANCE);
                controller.getDoubleClickController().addListener(this.fullScreenListener);
            } else {
                this.title = null;
            }
            for (StationChildHandle handle : this.dockables) {
                handle.setTitleRequest(this.title);
            }
            this.hierarchyObserver.controllerChanged(controller);
            this.visibility.fire();
        }
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addDockableListener(DockableListener listener) {
        this.dockableListeners.add(listener);
    }

    @Override
    public void removeDockableListener(DockableListener listener) {
        this.dockableListeners.remove(listener);
    }

    @Override
    public void addDockHierarchyListener(DockHierarchyListener listener) {
        this.hierarchyObserver.addDockHierarchyListener(listener);
    }

    @Override
    public void removeDockHierarchyListener(DockHierarchyListener listener) {
        this.hierarchyObserver.removeDockHierarchyListener(listener);
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
    }

    @Override
    public boolean accept(DockStation station) {
        return true;
    }

    @Override
    public boolean accept(DockStation base, Dockable neighbour) {
        return true;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public DockElement getElement() {
        return this;
    }

    @Override
    public boolean isUsedAsTitle() {
        return false;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return false;
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    @Override
    public String getTitleText() {
        String text = this.titleText.getValue();
        if (text == null) {
            return "";
        }
        return text;
    }

    public void setTitleText(String titleText) {
        this.titleText.setValue(titleText);
    }

    @Override
    public String getTitleToolTip() {
        return this.titleToolTip.getValue();
    }

    public void setTitleToolTip(String text) {
        this.titleToolTip.setValue(text);
    }

    @Override
    public Icon getTitleIcon() {
        return (Icon)this.titleIcon.value();
    }

    public void setTitleIcon(Icon titleIcon) {
        this.titleIcon.setValue(titleIcon, true);
    }

    public void resetTitleIcon() {
        this.titleIcon.setValue(null);
    }

    public void setSplitLayoutManager(SplitLayoutManager manager) {
        this.layoutManager.setValue(manager);
    }

    public SplitLayoutManager getSplitLayoutManager() {
        return this.layoutManager.getOwnValue();
    }

    public SplitLayoutManager getCurrentSplitLayoutManager() {
        return this.layoutManager.getValue();
    }

    public RootPlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy;
    }

    public void setPlaceholderStrategy(PlaceholderStrategy strategy) {
        this.placeholderStrategyProperty.setValue(strategy);
    }

    public void setSideSnapSize(float sideSnapSize) {
        if (sideSnapSize < 0.0f) {
            throw new IllegalArgumentException("sideSnapSize must not be less than 0");
        }
        this.sideSnapSize = sideSnapSize;
    }

    public float getSideSnapSize() {
        return this.sideSnapSize;
    }

    public void setBorderSideSnapSize(int borderSideSnapSize) {
        if (borderSideSnapSize < 0) {
            throw new IllegalArgumentException("borderSideSnapeSize must not be less than 0");
        }
        this.borderSideSnapSize = borderSideSnapSize;
    }

    public int getBorderSideSnapSize() {
        return this.borderSideSnapSize;
    }

    public void setDividerSize(int dividerSize) {
        if (dividerSize < 0) {
            throw new IllegalArgumentException("dividerSize must not be less than 0");
        }
        this.dividerSize = dividerSize;
        this.doLayout();
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public SplitDividerStrategy getDividerStrategy() {
        return this.dividerStrategy.getValue();
    }

    public void setDividerStrategy(SplitDividerStrategy strategy) {
        this.dividerStrategy.setValue(strategy);
    }

    protected SplitSpanStrategy getSpanStrategy() {
        return this.spanStrategy;
    }

    public void setNodeFactory(SplitNodeFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.nodeFactory = factory;
    }

    public SplitNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setContinousDisplay(boolean continousDisplay) {
        this.continousDisplay = continousDisplay;
    }

    public boolean isContinousDisplay() {
        return this.continousDisplay;
    }

    public void setMinimumLeafSize(Dimension minimumLeafSize) {
        if (minimumLeafSize == null) {
            throw new IllegalArgumentException("minimumLeafSize must not be null");
        }
        this.minimumLeafSize = minimumLeafSize;
        this.revalidate();
    }

    public Dimension getMinimumLeafSize() {
        return this.minimumLeafSize;
    }

    public void setAllowSideSnap(boolean allowSideSnap) {
        this.allowSideSnap = allowSideSnap;
    }

    public boolean isAllowSideSnap() {
        return this.allowSideSnap;
    }

    @Override
    public void requestDockTitle(DockTitleRequest request) {
    }

    @Override
    public void requestDisplayer(DisplayerRequest request) {
    }

    @Override
    public void changed(Dockable dockable, DockTitle title, boolean active) {
        title.changed(new ActivityDockTitleEvent(this, dockable, active));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest request) {
    }

    @Override
    public void requestChildDisplayer(DisplayerRequest request) {
    }

    @Override
    public void bind(DockTitle title) {
        if (this.titles.contains(title)) {
            throw new IllegalArgumentException("Title is already bound");
        }
        this.titles.add(title);
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleBound(this, title);
        }
    }

    @Override
    public void unbind(DockTitle title) {
        if (!this.titles.contains(title)) {
            throw new IllegalArgumentException("Title is unknown");
        }
        this.titles.remove(title);
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleUnbound(this, title);
        }
    }

    @Override
    public DockTitle[] listBoundTitles() {
        return this.titles.toArray(new DockTitle[this.titles.size()]);
    }

    @Override
    public DockActionSource getLocalActionOffers() {
        return null;
    }

    @Override
    public DockActionSource getGlobalActionOffers() {
        return this.globalSource;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints hints) {
        this.hints = hints;
        this.updateConfigurableDisplayerHints();
    }

    protected DockableDisplayerHints getConfigurableDisplayerHints() {
        return this.hints;
    }

    protected void updateConfigurableDisplayerHints() {
        if (this.hints != null) {
            if (this.getDockableCount() == 0) {
                this.hints.setShowBorderHint(Boolean.TRUE);
            } else {
                this.hints.setShowBorderHint(Boolean.FALSE);
            }
        }
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public DefaultDockActionSource getDirectActionOffers(Dockable dockable) {
        if (this.fullScreenAction == null) {
            return null;
        }
        DefaultDockActionSource source = new DefaultDockActionSource(new LocationHint(LocationHint.DIRECT_ACTION, LocationHint.VERY_RIGHT), new DockAction[0]);
        source.add(this.fullScreenAction);
        return source;
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        if (this.fullScreenAction == null) {
            return null;
        }
        DockStation parent = dockable.getDockParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof SplitDockStation) {
            return null;
        }
        dockable = parent.asDockable();
        if (dockable == null) {
            return null;
        }
        parent = dockable.getDockParent();
        if (parent != this) {
            return null;
        }
        DefaultDockActionSource source = new DefaultDockActionSource(this.fullScreenAction);
        source.setHint(new LocationHint(LocationHint.INDIRECT_ACTION, LocationHint.VERY_RIGHT));
        return source;
    }

    @Override
    public void addDockStationListener(DockStationListener listener) {
        this.dockStationListeners.addListener(listener);
    }

    @Override
    public void removeDockStationListener(DockStationListener listener) {
        this.dockStationListeners.removeListener(listener);
    }

    @Override
    public void addDockableStateListener(DockableStateListener listener) {
        this.dockableStateListeners.addListener(listener);
    }

    @Override
    public void removeDockableStateListener(DockableStateListener listener) {
        this.dockableStateListeners.removeListener(listener);
    }

    public void addSplitDockStationListener(SplitDockListener listener) {
        this.splitListeners.add(listener);
    }

    public void removeSplitDockStationListener(SplitDockListener listener) {
        this.splitListeners.remove(listener);
    }

    @Override
    public boolean isChildShowing(Dockable dockable) {
        return this.isVisible(dockable);
    }

    @Override
    @Deprecated
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && (!this.isFullScreen() || dockable == this.getFullScreen());
    }

    @Override
    public boolean isStationShowing() {
        return this.isStationVisible();
    }

    @Override
    @Deprecated
    public boolean isStationVisible() {
        return this.isDockableVisible();
    }

    @Override
    public boolean isDockableShowing() {
        return this.isDockableVisible();
    }

    @Override
    @Deprecated
    public boolean isDockableVisible() {
        DockController controller = this.getController();
        if (controller == null) {
            return false;
        }
        DockStation parent = this.getDockParent();
        if (parent != null) {
            return parent.isChildShowing(this);
        }
        return this.isShowing();
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Dockable getDockable(int index) {
        return this.dockables.get(index).getDockable();
    }

    @Override
    public DockableProperty getDockableProperty(Dockable child, Dockable target) {
        AbstractDockableProperty result = this.getDockablePlaceholderProperty(child, target);
        if (result == null) {
            result = this.getDockablePathProperty(child);
        }
        return result;
    }

    public SplitDockPathProperty getDockablePathProperty(final Dockable dockable) {
        final SplitDockPathProperty path = new SplitDockPathProperty();
        this.root().submit(new SplitTreeFactory<Object>(){

            @Override
            public Object leaf(Dockable check, long id, Path[] placeholders, PlaceholderMap placeholderMap) {
                if (dockable == check) {
                    path.setLeafId(id);
                    return this;
                }
                return null;
            }

            @Override
            public Object placeholder(long id, Path[] placeholders, PlaceholderMap placeholderMap) {
                return null;
            }

            @Override
            public Object root(Object root, long id) {
                return root;
            }

            @Override
            public Object horizontal(Object left, Object right, double divider, long id, Path[] placeholders, PlaceholderMap placeholderMap, boolean visible) {
                if (left != null) {
                    if (visible) {
                        path.insert(SplitDockPathProperty.Location.LEFT, divider, 0, id);
                    }
                    return left;
                }
                if (right != null) {
                    if (visible) {
                        path.insert(SplitDockPathProperty.Location.RIGHT, 1.0 - divider, 0, id);
                    }
                    return right;
                }
                return null;
            }

            @Override
            public Object vertical(Object top, Object bottom, double divider, long id, Path[] placeholders, PlaceholderMap placeholderMap, boolean visible) {
                if (top != null) {
                    if (visible) {
                        path.insert(SplitDockPathProperty.Location.TOP, divider, 0, id);
                    }
                    return top;
                }
                if (bottom != null) {
                    if (visible) {
                        path.insert(SplitDockPathProperty.Location.BOTTOM, 1.0 - divider, 0, id);
                    }
                    return bottom;
                }
                return null;
            }
        });
        return path;
    }

    public SplitDockProperty getDockableLocationProperty(Dockable dockable) {
        Leaf leaf = this.getRoot().getLeaf(dockable);
        return new SplitDockProperty(leaf.getX(), leaf.getY(), leaf.getWidth(), leaf.getHeight());
    }

    public SplitDockPlaceholderProperty getDockablePlaceholderProperty(Dockable dockable, Dockable target) {
        Leaf leaf = this.getRoot().getLeaf(dockable);
        if (leaf == null) {
            throw new IllegalArgumentException("dockable not known to this station");
        }
        Path placeholder = this.getPlaceholderStrategy().getPlaceholderFor(target == null ? dockable : target);
        if (placeholder == null) {
            return null;
        }
        this.placeholderSet.set((SplitNode)leaf, placeholder, new SplitNode[0]);
        return new SplitDockPlaceholderProperty(placeholder, this.getDockablePathProperty(dockable));
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.isFullScreen()) {
            return this.getFullScreen();
        }
        if (this.frontDockable == null && this.dockables.size() > 0) {
            this.frontDockable = this.dockables.get(0).getDockable();
        }
        return this.frontDockable;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable old = this.getFrontDockable();
        this.frontDockable = dockable;
        if (this.isFullScreen() && dockable != null) {
            this.setFullScreen(dockable);
        }
        if (old != dockable) {
            this.access.dockableSelected(old);
        }
    }

    public boolean isFullScreen() {
        return this.fullScreenDockable != null;
    }

    public Dockable getFullScreen() {
        return this.fullScreenDockable == null ? null : this.fullScreenDockable.getDockable();
    }

    public boolean hasFullScreenAction() {
        return this.fullScreenAction != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFullScreen(Dockable dockable) {
        try {
            this.access.arm();
            dockable = this.layoutManager.getValue().willMakeFullscreen(this, dockable);
            Dockable oldFullScreen = this.getFullScreen();
            if (oldFullScreen != dockable) {
                if (dockable != null) {
                    this.access.repositioned.add(dockable);
                    Leaf leaf = this.getRoot().getLeaf(dockable);
                    if (leaf == null) {
                        throw new IllegalArgumentException("Dockable not child of this station");
                    }
                    this.fullScreenDockable = leaf.getDockableHandle();
                    this.updateVisibility();
                } else {
                    this.fullScreenDockable = null;
                    this.updateVisibility();
                }
                if (oldFullScreen != null) {
                    this.access.repositioned.add(oldFullScreen);
                }
                this.revalidate();
                this.fireFullScreenChanged(oldFullScreen, this.getFullScreen());
                this.visibility.fire();
            }
        }
        finally {
            this.access.fire();
        }
    }

    protected void updateVisibility() {
        StationChildHandle fullscreenHandle = this.fullScreenDockable;
        if (fullscreenHandle == null) {
            for (StationChildHandle handle : this.dockables) {
                handle.getDisplayer().getComponent().setVisible(true);
            }
        } else {
            for (StationChildHandle handle : this.dockables) {
                handle.getDisplayer().getComponent().setVisible(handle == fullscreenHandle);
            }
        }
    }

    public void setNextFullScreen() {
        if (this.dockables.size() > 0) {
            if (this.fullScreenDockable == null) {
                this.setFullScreen(this.getDockable(0));
            } else {
                int index = this.indexOfDockable(this.fullScreenDockable.getDockable());
                ++index;
                this.setFullScreen(this.getDockable(index %= this.getDockableCount()));
            }
        }
    }

    @Override
    public boolean accept(Dockable child) {
        return true;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.createPlaceholderConverter().getPlaceholders();
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
        this.createPlaceholderConverter().setPlaceholders(placeholders);
    }

    protected SplitPlaceholderConverter createPlaceholderConverter() {
        return new SplitPlaceholderConverter(this);
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new DefaultDropLayer(this), new SplitOverrideDropLayer(this), new SideSnapDropLayer(this)};
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem item) {
        boolean move;
        PutInfo putInfo = null;
        boolean bl = move = item.getDockable().getDockParent() == this;
        if (move) {
            putInfo = this.layoutManager.getValue().prepareMove(this, item);
            if (putInfo != null) {
                if (putInfo.getNode() == null) {
                    return new NoStationDropOperation(this, item.getDockable());
                }
                this.prepareCombine(putInfo, move, item);
            }
        } else {
            putInfo = SwingUtilities.isDescendingFrom(this.getComponent(), item.getDockable().getComponent()) ? null : this.layoutManager.getValue().prepareDrop(this, item);
            if (putInfo != null) {
                this.prepareCombine(putInfo, move, item);
            }
        }
        if (putInfo == null) {
            return null;
        }
        return new SplitDropOperation(putInfo, item, move);
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        this.dragInfo = new ComponentDragOperation(dockable, this){

            protected void destroy() {
                SplitDockStation.this.dragInfo = null;
            }
        };
        return this.dragInfo;
    }

    public PutInfo getDropInfo() {
        return this.putInfo;
    }

    private void prepareCombine(PutInfo putInfo, boolean move, StationDropItem item) {
        if (putInfo.getCombinerSource() == null && putInfo.getCombinerTarget() == null && putInfo.getNode() instanceof Leaf) {
            DockController controller;
            Point mouseOnStation = new Point(item.getMouseX(), item.getMouseY());
            SwingUtilities.convertPointFromScreen(mouseOnStation, this.getComponent());
            SplitDockCombinerSource source = new SplitDockCombinerSource(putInfo, this, mouseOnStation);
            Enforcement force = putInfo.getPut() == PutInfo.Put.CENTER ? Enforcement.EXPECTED : (putInfo.getPut() == PutInfo.Put.TITLE ? Enforcement.HARD : Enforcement.WHISHED);
            CombinerTarget target = this.getCombiner().prepare(source, force);
            if (target == null && putInfo.isCombining() && putInfo.getDockable().asDockStation() != null && (controller = this.getController()) != null) {
                Merger merger = controller.getRelocator().getMerger();
                target = this.getCombiner().prepare(source, Enforcement.HARD);
                putInfo.setCombination(source, target);
                if (!merger.canMerge(new SplitDropOperation(putInfo, item, move), this, putInfo.getDockable().asDockStation())) {
                    putInfo.setCombination(null, null);
                }
            }
            putInfo.setCombination(source, target);
        }
    }

    @Override
    public void drop(Dockable dockable) {
        this.addDockable(dockable, null);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty property) {
        if (property instanceof SplitDockProperty) {
            return this.drop(dockable, (SplitDockProperty)property);
        }
        if (property instanceof SplitDockPathProperty) {
            return this.drop(dockable, (SplitDockPathProperty)property);
        }
        if (property instanceof SplitDockPlaceholderProperty) {
            return this.drop(dockable, (SplitDockPlaceholderProperty)property);
        }
        if (property instanceof SplitDockFullScreenProperty) {
            return this.drop(dockable, (SplitDockFullScreenProperty)property);
        }
        return false;
    }

    public boolean drop(Dockable dockable, SplitDockProperty property) {
        return this.drop(dockable, property, this.root());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drop(final Dockable dockable, final SplitDockProperty property, SplitNode root) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (this.getDockableCount() == 0) {
                if (!DockUtilities.acceptable(this, dockable)) {
                    boolean bl = false;
                    return bl;
                }
                this.drop(dockable);
                boolean bl = true;
                return bl;
            }
            this.updateBounds();
            class DropInfo {
                public Leaf bestLeaf;
                public double bestLeafIntersection;
                public SplitNode bestNode;
                public double bestNodeIntersection = Double.POSITIVE_INFINITY;
                public PutInfo.Put bestNodePut;

                DropInfo() {
                }
            }
            final DropInfo info = new DropInfo();
            root.visit(new SplitNodeVisitor(){
                {
                }

                public void handleLeaf(Leaf leaf) {
                    double intersection = leaf.intersection(property);
                    if (intersection > info.bestLeafIntersection) {
                        info.bestLeafIntersection = intersection;
                        info.bestLeaf = leaf;
                    }
                    this.handleNeighbour(leaf);
                }

                public void handleNode(Node node) {
                    if (node.isVisible()) {
                        this.handleNeighbour(node);
                    }
                }

                public void handleRoot(Root root) {
                }

                public void handlePlaceholder(Placeholder placeholder) {
                }

                private void handleNeighbour(SplitNode node) {
                    if (DockUtilities.acceptable(SplitDockStation.this, dockable)) {
                        double py;
                        double px;
                        double ky;
                        double x = node.getX();
                        double y = node.getY();
                        double width = node.getWidth();
                        double height = node.getHeight();
                        double left = Math.abs(x - property.getX());
                        double right = Math.abs(x + width - property.getX() - property.getWidth());
                        double top = Math.abs(y - property.getY());
                        double bottom = Math.abs(y + height - property.getY() - property.getHeight());
                        double value = left + right + top + bottom;
                        value -= Math.max(Math.max(left, right), Math.max(top, bottom));
                        double kx = property.getX() + property.getWidth() / 2.0;
                        PutInfo.Put put = node.relativeSidePut(kx, ky = property.getY() + property.getHeight() / 2.0);
                        if (put == PutInfo.Put.TOP) {
                            px = x + 0.5 * width;
                            py = y + 0.25 * height;
                        } else if (put == PutInfo.Put.BOTTOM) {
                            px = x + 0.5 * width;
                            py = y + 0.75 * height;
                        } else if (put == PutInfo.Put.LEFT) {
                            px = x + 0.25 * width;
                            py = y + 0.5 * height;
                        } else {
                            px = x + 0.5 * width;
                            py = y + 0.75 * height;
                        }
                        double distance = Math.pow((kx - px) * (kx - px) + (ky - py) * (ky - py), 0.25);
                        value *= distance;
                        if (value < info.bestNodeIntersection) {
                            info.bestNodeIntersection = value;
                            info.bestNode = node;
                            info.bestNodePut = put;
                        }
                    }
                }
            });
            if (info.bestLeaf != null) {
                DockStation station = info.bestLeaf.getDockable().asDockStation();
                DockableProperty successor = property.getSuccessor();
                if (station != null && successor != null && station.drop(dockable, successor)) {
                    this.validate();
                    boolean bl = true;
                    return bl;
                }
                if (info.bestLeafIntersection > 0.75) {
                    if (station != null && DockUtilities.acceptable(station, dockable)) {
                        station.drop(dockable);
                        this.validate();
                        boolean bl = true;
                        return bl;
                    }
                    boolean result = this.dropOver(info.bestLeaf, dockable, property.getSuccessor(), null, null);
                    this.validate();
                    boolean bl = result;
                    return bl;
                }
            }
            if (info.bestNode != null) {
                if (!DockUtilities.acceptable(this, dockable)) {
                    boolean station = false;
                    return station;
                }
                double divider = 0.5;
                if (info.bestNodePut == PutInfo.Put.LEFT) {
                    divider = property.getWidth() / info.bestNode.getWidth();
                } else if (info.bestNodePut == PutInfo.Put.RIGHT) {
                    divider = 1.0 - property.getWidth() / info.bestNode.getWidth();
                } else if (info.bestNodePut == PutInfo.Put.TOP) {
                    divider = property.getHeight() / info.bestNode.getHeight();
                } else if (info.bestNodePut == PutInfo.Put.BOTTOM) {
                    divider = 1.0 - property.getHeight() / info.bestNode.getHeight();
                }
                divider = Math.max(0.0, Math.min(1.0, divider));
                boolean bl = this.dropAside(info.bestNode, info.bestNodePut, dockable, null, divider, null);
                return bl;
            }
            this.repaint();
            boolean bl = false;
            return bl;
        }
        finally {
            this.access.fire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Dockable dockable, SplitDockPathProperty property) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            int index = 0;
            SplitNode start = null;
            long leafId = property.getLeafId();
            if (leafId != -1L && (start = this.getNode(leafId)) != null) {
                index = property.size();
            }
            if (start == null) {
                SplitDockPathProperty.Node node;
                long id;
                for (index = property.size() - 1; index >= 0 && ((id = (node = property.getNode(index)).getId()) == -1L || (start = this.getNode(id)) == null); --index) {
                }
            }
            if (start == null || index < 0) {
                start = this.root();
                index = 0;
            }
            this.updateBounds();
            boolean done = start.insert(property, index, dockable);
            if (done) {
                this.revalidate();
            }
            boolean bl = done;
            return bl;
        }
        finally {
            this.access.fire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Dockable dockable, SplitDockPlaceholderProperty property) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            this.validate();
            boolean bl = this.root().insert(property, dockable);
            return bl;
        }
        finally {
            this.access.fire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Dockable dockable, SplitDockFullScreenProperty property) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            DockableProperty successor = property.getSuccessor();
            if (dockable.getDockParent() == this) {
                this.setFullScreen(dockable);
                boolean bl = true;
                return bl;
            }
            Dockable currentFullScreen = this.getFullScreen();
            if (currentFullScreen == null) {
                boolean bl = false;
                return bl;
            }
            DockStation currentFullScreenStation = currentFullScreen.asDockStation();
            if (currentFullScreenStation != null) {
                if (successor != null && currentFullScreenStation.drop(dockable, successor)) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            Leaf leaf = this.getRoot().getLeaf(currentFullScreen);
            this.setFullScreen(null);
            if (!this.dropOver(leaf, dockable, successor, null, null)) {
                boolean bl = false;
                return bl;
            }
            Dockable last = dockable;
            while (dockable != null && dockable != this) {
                last = dockable;
                DockStation station = dockable.getDockParent();
                dockable = station == null ? null : station.asDockable();
            }
            if (last != null) {
                this.setFullScreen(last);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.access.fire();
        }
    }

    protected boolean dropOver(Leaf leaf, Dockable dockable, CombinerSource source, CombinerTarget target) {
        return this.dropOver(leaf, dockable, null, source, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dropOver(Leaf leaf, Dockable dockable, DockableProperty property, CombinerSource source, CombinerTarget target) {
        if (!DockUtilities.acceptable(this, leaf.getDockable(), dockable)) {
            return false;
        }
        try {
            DockStation combinedStation;
            DockHierarchyLock.Token token;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            DockUtilities.ensureTreeValidity(this, dockable);
            if (source == null || target == null) {
                PutInfo info = new PutInfo(leaf, PutInfo.Put.TITLE, dockable, true);
                source = new SplitDockCombinerSource(info, this, null);
                target = this.combiner.prepare(source, Enforcement.HARD);
            }
            if (leaf.getDockable() != null) {
                Dockable oldDockable = leaf.getDockable();
                token = DockHierarchyLock.acquireUnlinking(this, oldDockable);
                try {
                    this.dockStationListeners.fireDockableRemoving(oldDockable);
                    leaf.setDockable(null, token);
                    this.dockStationListeners.fireDockableRemoved(oldDockable);
                }
                finally {
                    token.release();
                }
            }
            Dockable combination = this.combiner.combine(source, target);
            leaf.setPlaceholderMap(null);
            if (property != null && (combinedStation = combination.asDockStation()) != null && dockable.getDockParent() == combinedStation) {
                combinedStation.move(dockable, property);
            }
            token = DockHierarchyLock.acquireLinking(this, combination);
            try {
                this.dockStationListeners.fireDockableAdding(combination);
                leaf.setDockable(combination, token);
                this.dockStationListeners.fireDockableAdded(combination);
            }
            finally {
                token.release();
            }
            this.revalidate();
            this.repaint();
            boolean bl = true;
            return bl;
        }
        finally {
            this.access.fire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dropAside(SplitNode neighbor, PutInfo.Put put, Dockable dockable, Leaf leaf, double divider, DockHierarchyLock.Token token) {
        if (!DockUtilities.acceptable(this, dockable)) {
            return false;
        }
        try {
            boolean fire = token == null;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (fire) {
                DockUtilities.ensureTreeValidity(this, dockable);
                token = DockHierarchyLock.acquireLinking(this, dockable);
            }
            try {
                if (fire) {
                    this.dockStationListeners.fireDockableAdding(dockable);
                }
                boolean leafSet = false;
                if (leaf == null) {
                    leaf = this.access.createLeaf(-1L);
                    leafSet = true;
                }
                SplitNode parent = neighbor.getParent();
                Node node = null;
                this.updateBounds();
                int location = parent.getChildLocation(neighbor);
                node = this.access.createNode(-1L);
                if (put == PutInfo.Put.TOP) {
                    node.setLeft(leaf);
                    node.setRight(neighbor);
                    node.setOrientation(Orientation.VERTICAL);
                } else if (put == PutInfo.Put.BOTTOM) {
                    node.setLeft(neighbor);
                    node.setRight(leaf);
                    node.setOrientation(Orientation.VERTICAL);
                } else if (put == PutInfo.Put.LEFT) {
                    node.setLeft(leaf);
                    node.setRight(neighbor);
                    node.setOrientation(Orientation.HORIZONTAL);
                } else {
                    node.setLeft(neighbor);
                    node.setRight(leaf);
                    node.setOrientation(Orientation.HORIZONTAL);
                }
                node.setDivider(divider);
                parent.setChild(node, location);
                if (leafSet) {
                    leaf.setDockable(dockable, token);
                }
                if (fire) {
                    this.dockStationListeners.fireDockableAdded(dockable);
                }
                this.revalidate();
                this.repaint();
            }
            finally {
                if (fire) {
                    token.release();
                }
            }
        }
        finally {
            this.access.fire();
        }
        return true;
    }

    @Override
    public void move(Dockable dockable, DockableProperty property) {
    }

    public void dropGrid(SplitDockGrid grid) {
        this.dropTree(grid.toTree());
    }

    public void dropTree(SplitDockTree<Dockable> tree) {
        this.dropTree(tree, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTree(SplitDockTree<Dockable> tree, boolean checkValidity) {
        if (tree == null) {
            throw new IllegalArgumentException("Tree must not be null");
        }
        DockUtilities.checkLayoutLocked();
        DockController controller = this.getController();
        try {
            this.access.arm();
            ++this.treeLock;
            if (controller != null) {
                controller.freezeLayout();
            }
            this.setFullScreen(null);
            this.removeAllDockables();
            for (Dockable dockable : tree.getDockables()) {
                DockUtilities.ensureTreeValidity(this, dockable);
            }
            SplitDockTree.Key rootKey = tree.getRoot();
            if (rootKey != null) {
                HashMap<Leaf, Dockable> linksToSet = new HashMap<Leaf, Dockable>();
                this.root().evolve(rootKey, checkValidity, linksToSet);
                for (Map.Entry entry : linksToSet.entrySet()) {
                    ((Leaf)entry.getKey()).setDockable((Dockable)entry.getValue(), null);
                }
                this.updateBounds();
            }
        }
        finally {
            --this.treeLock;
            if (controller != null) {
                controller.meltLayout();
            }
            this.access.fire();
        }
    }

    public DockableSplitDockTree createTree() {
        DockableSplitDockTree tree = new DockableSplitDockTree();
        this.createTree(new SplitDockTreeFactory(tree));
        return tree;
    }

    public void createTree(SplitDockTreeFactory factory) {
        this.root().submit(factory);
    }

    public <N> N visit(SplitTreeFactory<N> factory) {
        return this.root().submit(factory);
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable cannot be dragged, it is not child of this station.");
        }
        this.removeDockable(dockable);
    }

    protected void fireFullScreenChanged(Dockable oldDockable, Dockable newDockable) {
        for (SplitDockListener listener : this.splitListeners.toArray(new SplitDockListener[this.splitListeners.size()])) {
            listener.fullScreenDockableChanged(this, oldDockable, newDockable);
        }
    }

    protected void fireTitleExchanged(DockTitle title) {
        for (DockableListener listener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            listener.titleExchanged(this, title);
        }
    }

    protected void fireTitleExchanged() {
        DockTitle[] bound;
        for (DockTitle title : bound = this.listBoundTitles()) {
            this.fireTitleExchanged(title);
        }
        this.fireTitleExchanged(null);
    }

    @Override
    public Dockable asDockable() {
        return this;
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    public DefaultDisplayerFactoryValue getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public StationCombinerValue getCombiner() {
        return this.combiner;
    }

    @Override
    protected void paintOverlay(Graphics g) {
        Rectangle bounds;
        if (this.putInfo != null && !this.putInfo.willHaveNoEffect()) {
            DefaultStationPaintValue paint = this.getPaint();
            if (this.putInfo.getNode() == null) {
                Rectangle bounds2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                paint.drawInsertion(g, bounds2, bounds2);
            } else {
                CombinerTarget target = this.putInfo.getCombinerTarget();
                if (target == null) {
                    SplitNode node = this.putInfo.getNode();
                    if (node.getParent() == this.getRoot()) {
                        node = this.getRoot();
                    }
                    Rectangle bounds3 = node.getBounds();
                    if (this.putInfo.getPut() == PutInfo.Put.LEFT) {
                        bounds3.width = (int)((double)bounds3.width * this.putInfo.getDivider() + 0.5);
                    } else if (this.putInfo.getPut() == PutInfo.Put.RIGHT) {
                        int width = bounds3.width;
                        bounds3.width = (int)((double)bounds3.width * (1.0 - this.putInfo.getDivider()) + 0.5);
                        bounds3.x += width - bounds3.width;
                    } else if (this.putInfo.getPut() == PutInfo.Put.TOP) {
                        bounds3.height = (int)((double)bounds3.height * this.putInfo.getDivider() + 0.5);
                    } else if (this.putInfo.getPut() == PutInfo.Put.BOTTOM) {
                        int height = bounds3.height;
                        bounds3.height = (int)((double)bounds3.height * (1.0 - this.putInfo.getDivider()) + 0.5);
                        bounds3.y += height - bounds3.height;
                    }
                    paint.drawInsertion(g, this.putInfo.getNode().getBounds(), bounds3);
                } else {
                    bounds = this.putInfo.getNode().getBounds();
                    StationPaint stationPaint = (StationPaint)paint.get();
                    if (stationPaint != null) {
                        target.paint(g, this.getComponent(), stationPaint, bounds, bounds);
                    }
                }
            }
        }
        this.dividerStrategy.getValue().paint(this, g);
        if (this.dragInfo != null && this.dragInfo.getDockable() != null) {
            Leaf leaf = this.getRoot().getLeaf(this.dragInfo.getDockable());
            StationPaint stationPaint = (StationPaint)this.paint.get();
            if (stationPaint != null && leaf != null) {
                bounds = leaf.getBounds();
                stationPaint.drawRemoval(g, this, bounds, bounds);
            }
        }
    }

    public void addDockable(Dockable dockable) {
        this.addDockable(dockable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDockable(Dockable dockable, DockHierarchyLock.Token token) {
        try {
            boolean fire = token == null;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (fire) {
                DockUtilities.ensureTreeValidity(this, dockable);
                token = DockHierarchyLock.acquireLinking(this, dockable);
            }
            try {
                if (fire) {
                    this.dockStationListeners.fireDockableAdding(dockable);
                }
                Leaf leaf = this.access.createLeaf(-1L);
                Root root = this.root();
                if (root.getChild() == null) {
                    root.setChild(leaf);
                } else {
                    SplitNode child = root.getChild();
                    root.setChild(null);
                    Node node = this.access.createNode(-1L);
                    node.setLeft(leaf);
                    node.setRight(child);
                    root.setChild(node);
                }
                leaf.setDockable(dockable, token);
                if (fire) {
                    this.dockStationListeners.fireDockableAdded(dockable);
                }
                this.revalidate();
            }
            finally {
                if (fire) {
                    token.release();
                }
            }
        }
        finally {
            this.access.fire();
        }
    }

    @Override
    public boolean canReplace(Dockable old, Dockable next) {
        return true;
    }

    @Override
    public void replace(DockStation old, Dockable next) {
        this.replace(old.asDockable(), next, true);
    }

    @Override
    public void replace(Dockable previous, Dockable next) {
        this.replace(previous, next, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(Dockable previous, Dockable next, boolean station) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (previous == null) {
                throw new NullPointerException("previous must not be null");
            }
            if (next == null) {
                throw new NullPointerException("next must not be null");
            }
            if (previous != next) {
                Leaf leaf = this.root().getLeaf(previous);
                if (leaf == null) {
                    throw new IllegalArgumentException("Previous is not child of this station");
                }
                DockUtilities.ensureTreeValidity(this, next);
                boolean wasFullScreen = this.isFullScreen() && this.getFullScreen() == previous;
                leaf.setDockable(next, null, true, station);
                if (wasFullScreen) {
                    this.setFullScreen(next);
                }
                this.revalidate();
                this.repaint();
            }
        }
        finally {
            this.access.fire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHandle(StationChildHandle handle, DockHierarchyLock.Token token) {
        boolean fire;
        Dockable dockable = handle.getDockable();
        DockUtilities.ensureTreeValidity(this, dockable);
        boolean bl = fire = token == null;
        if (fire) {
            token = DockHierarchyLock.acquireLinking(this, dockable);
        }
        try {
            if (fire) {
                this.dockStationListeners.fireDockableAdding(dockable);
            }
            this.dockables.add(handle);
            dockable.setDockParent(this);
            handle.updateDisplayer();
            DockableDisplayer displayer = handle.getDisplayer();
            this.getContentPane().add(displayer.getComponent());
            displayer.getComponent().setVisible(!this.isFullScreen());
            if (fire) {
                this.dockStationListeners.fireDockableAdded(dockable);
            }
        }
        finally {
            if (fire) {
                token.release();
            }
        }
    }

    protected void discard(DockableDisplayer displayer) {
        int index = this.indexOfDockable(displayer.getDockable());
        if (index < 0) {
            throw new IllegalArgumentException("displayer unknown to this station: " + displayer);
        }
        Dockable dockable = displayer.getDockable();
        boolean visible = displayer.getComponent().isVisible();
        Leaf leaf = this.root().getLeaf(dockable);
        this.getContentPane().remove(displayer.getComponent());
        StationChildHandle handle = leaf.getDockableHandle();
        handle.updateDisplayer();
        displayer = handle.getDisplayer();
        this.getContentPane().add(displayer.getComponent());
        displayer.getComponent().setVisible(visible);
        this.revalidate();
    }

    public int indexOfDockable(Dockable dockable) {
        int n = this.dockables.size();
        for (int i = 0; i < n; ++i) {
            if (this.dockables.get(i).getDockable() != dockable) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDockables() {
        DockController controller = this.getController();
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (controller != null) {
                controller.freezeLayout();
            }
            for (int i = this.getDockableCount() - 1; i >= 0; --i) {
                this.removeDisplayer(i, null);
            }
            this.root().setChild(null);
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
            this.access.fire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDockable(Dockable dockable) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            Leaf leaf = this.root().getLeaf(dockable);
            if (leaf != null) {
                leaf.setDockable(null, null, true, dockable.asDockStation() != null);
                leaf.placehold(true);
            }
        }
        finally {
            this.access.fire();
        }
    }

    public void removePlaceholder(Path placeholder) {
        HashSet<Path> placeholders = new HashSet<Path>();
        placeholders.add(placeholder);
        this.removePlaceholders(placeholders);
    }

    public void removePlaceholders(final Set<Path> placeholders) {
        if (placeholders.isEmpty()) {
            return;
        }
        final ArrayList nodesToDelete = new ArrayList();
        this.root().visit(new SplitNodeVisitor(){

            public void handleRoot(Root root) {
                this.handle(root);
            }

            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(SplitDockStation.this.root);
            }

            public void handleNode(Node node) {
                this.handle(SplitDockStation.this.root);
            }

            public void handleLeaf(Leaf leaf) {
                this.handle(SplitDockStation.this.root);
            }

            private void handle(SplitNode node) {
                node.removePlaceholders(placeholders);
                if (!node.isOfUse()) {
                    nodesToDelete.add(node);
                }
            }
        });
        for (SplitNode node : nodesToDelete) {
            node.delete(true);
        }
    }

    private void removeHandle(StationChildHandle handle, DockHierarchyLock.Token token) {
        int index = this.dockables.indexOf(handle);
        if (index >= 0) {
            this.removeDisplayer(index, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDisplayer(int index, DockHierarchyLock.Token token) {
        boolean fire;
        StationChildHandle handle = this.dockables.get(index);
        if (handle == this.fullScreenDockable) {
            this.setNextFullScreen();
            if (handle == this.fullScreenDockable) {
                this.setFullScreen(null);
            }
        }
        Dockable dockable = handle.getDockable();
        boolean bl = fire = token == null;
        if (fire) {
            token = DockHierarchyLock.acquireUnlinking(this, dockable);
        }
        try {
            if (fire) {
                this.dockStationListeners.fireDockableRemoving(dockable);
            }
            this.dockables.remove(index);
            DockableDisplayer displayer = handle.getDisplayer();
            displayer.getComponent().setVisible(true);
            this.getContentPane().remove(displayer.getComponent());
            handle.destroy();
            if (dockable == this.frontDockable) {
                this.setFrontDockable(null);
            }
            dockable.setDockParent(null);
            if (fire) {
                this.dockStationListeners.fireDockableRemoved(dockable);
            }
        }
        finally {
            if (fire) {
                token.release();
            }
        }
    }

    public Root getRoot() {
        return this.root();
    }

    public SplitNode getNode(final long id) {
        if (this.root == null) {
            return null;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Visitor
        implements SplitNodeVisitor {
            private SplitNode result;

            Visitor() {
            }

            @Override
            public void handleRoot(Root root) {
                if (root.getId() == id) {
                    this.result = root;
                }
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                if (leaf.getId() == id) {
                    this.result = leaf;
                }
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                if (placeholder.getId() == id) {
                    this.result = placeholder;
                }
            }

            @Override
            public void handleNode(Node node) {
                if (node.getId() == id) {
                    this.result = node;
                }
            }
        }
        Visitor visitor = new Visitor();
        this.getRoot().visit(visitor);
        return visitor.result;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockStationFactory";
    }

    public void updateBounds() {
        Insets insets = this.getContentPane().getInsets();
        double factorW = this.getWidth() - insets.left - insets.right;
        double factorH = this.getHeight() - insets.top - insets.bottom;
        SplitLayoutManager manager = this.layoutManager.getValue();
        if (factorW <= 0.0 || factorH <= 0.0) {
            manager.updateBounds(this.root(), 0.0, 0.0, 0.0, 0.0);
        } else {
            manager.updateBounds(this.root(), (double)insets.left / factorW, (double)insets.top / factorH, factorW, factorH);
        }
    }

    protected void setPut(PutInfo info) {
        this.spanStrategy.setPut(info);
    }

    protected void unsetPut() {
        this.spanStrategy.unsetPut();
    }

    static /* synthetic */ void access$1700(SplitDockStation x0, Dockable x1, DockHierarchyLock.Token x2) {
        x0.addDockable(x1, x2);
    }

    private class Access
    implements SplitDockAccess {
        private long lastUniqueId = -1L;
        private int repositionedArm = 0;
        private Set<Dockable> repositioned = new HashSet<Dockable>();
        private Dockable dockableSelected = null;

        private Access() {
        }

        public StationChildHandle getFullScreenDockable() {
            return SplitDockStation.this.fullScreenDockable;
        }

        public DockTitleVersion getTitleVersion() {
            return SplitDockStation.this.title;
        }

        public SplitDockStation getOwner() {
            return SplitDockStation.this;
        }

        public double validateDivider(double divider, Node node) {
            return ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validateDivider(SplitDockStation.this, divider, node);
        }

        public StationChildHandle newHandle(Dockable dockable) {
            return new StationChildHandle(SplitDockStation.this, SplitDockStation.this.getDisplayers(), dockable, SplitDockStation.this.title);
        }

        public void addHandle(StationChildHandle dockable, DockHierarchyLock.Token token) {
            SplitDockStation.this.addHandle(dockable, token);
        }

        public void removeHandle(StationChildHandle handle, DockHierarchyLock.Token token) {
            SplitDockStation.this.removeHandle(handle, token);
        }

        public boolean drop(Dockable dockable, SplitDockProperty property, SplitNode root) {
            return SplitDockStation.this.drop(dockable, property, root);
        }

        public PutInfo validatePutInfo(PutInfo putInfo) {
            return ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validatePutInfo(SplitDockStation.this, putInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repositioned(SplitNode node) {
            this.arm();
            try {
                node.visit(new SplitNodeVisitor(){

                    public void handleRoot(Root root) {
                    }

                    public void handlePlaceholder(Placeholder placeholder) {
                    }

                    public void handleNode(Node node) {
                    }

                    public void handleLeaf(Leaf leaf) {
                        Dockable dockable = leaf.getDockable();
                        if (dockable != null) {
                            Access.this.repositioned.add(dockable);
                        }
                    }
                });
            }
            finally {
                this.fire();
            }
        }

        public void dockableSelected(Dockable dockable) {
            this.arm();
            if (this.dockableSelected == null) {
                this.dockableSelected = dockable;
            }
            this.fire();
        }

        public void arm() {
            ++this.repositionedArm;
        }

        public void fire() {
            --this.repositionedArm;
            if (this.repositionedArm == 0) {
                ArrayList<Dockable> dockables = new ArrayList<Dockable>();
                for (Dockable dockable : this.repositioned) {
                    if (dockable.getDockParent() != SplitDockStation.this) continue;
                    dockables.add(dockable);
                }
                this.repositioned.clear();
                if (dockables.size() > 0) {
                    SplitDockStation.this.dockStationListeners.fireDockablesRepositioned(dockables.toArray(new Dockable[dockables.size()]));
                }
                if (this.dockableSelected != null) {
                    Dockable newDockable = SplitDockStation.this.getFrontDockable();
                    if (this.dockableSelected != newDockable) {
                        SplitDockStation.this.dockStationListeners.fireDockableSelected(this.dockableSelected, newDockable);
                    }
                    this.dockableSelected = null;
                }
            }
        }

        public long uniqueID() {
            long id = System.currentTimeMillis();
            if (id <= this.lastUniqueId) {
                ++this.lastUniqueId;
                id = this.lastUniqueId + 1L;
            }
            while (SplitDockStation.this.getNode(id) != null) {
                ++id;
            }
            this.lastUniqueId = id;
            return id;
        }

        public boolean isTreeAutoCleanupEnabled() {
            return SplitDockStation.this.treeLock == 0;
        }

        public SplitPlaceholderSet getPlaceholderSet() {
            return SplitDockStation.this.placeholderSet;
        }

        public SplitSpanStrategy getSpanStrategy() {
            return SplitDockStation.this.spanStrategy;
        }

        public Leaf createLeaf(long id) {
            return SplitDockStation.this.nodeFactory.createLeaf(this, id);
        }

        public Node createNode(long id) {
            return SplitDockStation.this.nodeFactory.createNode(this, id);
        }

        public Placeholder createPlaceholder(long id) {
            return SplitDockStation.this.nodeFactory.createPlaceholder(this, id);
        }

        public Root createRoot(long id) {
            return SplitDockStation.this.nodeFactory.createRoot(this, id);
        }
    }

    protected class SplitDropOperation
    implements StationDropOperation {
        private PutInfo putInfo;
        private StationDropItem item;
        private boolean move;

        public SplitDropOperation(PutInfo putInfo, StationDropItem item, boolean move) {
            this.putInfo = putInfo;
            this.item = item;
            this.move = move;
        }

        public boolean isMove() {
            return this.move;
        }

        public void draw() {
            SplitDockStation.this.putInfo = this.putInfo;
            SplitDockStation.this.setPut(this.putInfo);
            SplitDockStation.this.repaint();
        }

        public void destroy(StationDropOperation next) {
            if (SplitDockStation.this.putInfo == this.putInfo) {
                SplitDockStation.this.putInfo = null;
                if (next == null || !(next instanceof SplitDropOperation) || next.getTarget() != this.getTarget()) {
                    SplitDockStation.this.setPut(null);
                }
                SplitDockStation.this.repaint();
            }
        }

        public DockStation getTarget() {
            return SplitDockStation.this;
        }

        public Dockable getItem() {
            return this.putInfo.getDockable();
        }

        public CombinerTarget getCombination() {
            return this.putInfo.getCombinerTarget();
        }

        public DisplayerCombinerTarget getDisplayerCombination() {
            CombinerTarget target = this.getCombination();
            if (target == null) {
                return null;
            }
            return target.getDisplayerCombination();
        }

        public void execute() {
            SplitDockStation.this.unsetPut();
            if (this.isMove()) {
                this.move();
            } else {
                this.drop(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move() {
            try {
                SplitNode parent;
                SplitDockStation.this.access.arm();
                DockUtilities.checkLayoutLocked();
                Root root = SplitDockStation.this.root();
                Leaf leaf = root.getLeaf(this.putInfo.getDockable());
                if (leaf.getParent() == parent) {
                    for (parent = this.putInfo.getNode(); parent != null; parent = parent.getParent()) {
                        if (parent == root) {
                            return;
                        }
                        Node node = (Node)parent;
                        SplitNode next = node.getLeft() == leaf ? node.getRight() : node.getLeft();
                        if (!next.isVisible()) continue;
                        this.putInfo.setNode(next);
                        break;
                    }
                }
                this.putInfo.setLeaf(leaf);
                if (this.putInfo.getPut() == PutInfo.Put.CENTER) {
                    leaf.placehold(false);
                } else {
                    leaf.delete(true);
                }
                this.drop(DockHierarchyLock.acquireFake());
            }
            finally {
                SplitDockStation.this.access.fire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void drop(DockHierarchyLock.Token token) {
            try {
                fire = token == null;
                SplitDockStation.access$1600(SplitDockStation.this).arm();
                DockUtilities.checkLayoutLocked();
                if (this.putInfo.getNode() == null) {
                    if (fire) {
                        DockUtilities.ensureTreeValidity(SplitDockStation.this, this.putInfo.getDockable());
                        token = DockHierarchyLock.acquireLinking(SplitDockStation.this, this.putInfo.getDockable());
                    }
                    try {
                        if (fire) {
                            SplitDockStation.this.dockStationListeners.fireDockableAdding(this.putInfo.getDockable());
                        }
                        SplitDockStation.access$1700(SplitDockStation.this, this.putInfo.getDockable(), token);
                        if (!fire) ** GOTO lbl44
                        SplitDockStation.this.dockStationListeners.fireDockableAdded(this.putInfo.getDockable());
                    }
                    finally {
                        if (fire) {
                            token.release();
                        }
                    }
                } else {
                    finish = false;
                    if (this.putInfo.getCombinerTarget() != null) {
                        if (this.putInfo.getNode() instanceof Leaf) {
                            if (this.putInfo.getLeaf() != null) {
                                if (fire) {
                                    token = DockHierarchyLock.acquireUnlinking(SplitDockStation.this, this.putInfo.getLeaf().getDockable());
                                }
                                try {
                                    this.putInfo.getLeaf().setDockable(null, token);
                                    this.putInfo.setLeaf(null);
                                }
                                finally {
                                    if (fire) {
                                        token.release();
                                    }
                                }
                            }
                            if (SplitDockStation.this.dropOver((Leaf)this.putInfo.getNode(), this.putInfo.getDockable(), this.putInfo.getCombinerSource(), this.putInfo.getCombinerTarget())) {
                                finish = true;
                            }
                        } else {
                            this.putInfo.setPut(PutInfo.Put.TOP);
                        }
                    }
                    if (!finish) {
                        SplitDockStation.this.updateBounds();
                        ((SplitLayoutManager)SplitDockStation.access$1800(SplitDockStation.this).getValue()).calculateDivider(SplitDockStation.this, this.putInfo, SplitDockStation.this.root().getLeaf(this.putInfo.getDockable()), this.item);
                        SplitDockStation.this.dropAside(this.putInfo.getNode(), this.putInfo.getPut(), this.putInfo.getDockable(), this.putInfo.getLeaf(), this.putInfo.getDivider(), token);
                    }
                }
lbl44:
                // 5 sources

                SplitDockStation.this.revalidate();
            }
            finally {
                SplitDockStation.access$1600(SplitDockStation.this).fire();
            }
        }
    }

    private class FullScreenListener
    implements DoubleClickListener {
        private FullScreenListener() {
        }

        public DockElement getTreeLocation() {
            return SplitDockStation.this;
        }

        public boolean process(Dockable dockable, MouseEvent event) {
            if (event.isConsumed() || !SplitDockStation.this.isExpandOnDoubleclick()) {
                return false;
            }
            if (dockable == SplitDockStation.this) {
                return false;
            }
            if ((dockable = this.unwrap(dockable)) != null) {
                if (SplitDockStation.this.isFullScreen()) {
                    if (SplitDockStation.this.getFullScreen() == dockable) {
                        SplitDockStation.this.setFullScreen(null);
                        event.consume();
                    }
                } else {
                    SplitDockStation.this.setFullScreen(dockable);
                    event.consume();
                }
                return true;
            }
            return false;
        }

        private Dockable unwrap(Dockable dockable) {
            while (dockable.getDockParent() != SplitDockStation.this) {
                DockStation parent = dockable.getDockParent();
                if (parent == null) {
                    return null;
                }
                dockable = parent.asDockable();
                if (dockable != null) continue;
                return null;
            }
            return dockable;
        }
    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        public void dockableShowingChanged(DockStation station, Dockable dockable, boolean visible) {
            SplitDockStation.this.visibility.fire();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    private class Content
    extends ConfiguredBackgroundPanel {
        public Content() {
            super(Transparency.DEFAULT);
        }

        public void doLayout() {
            SplitDockStation.this.updateBounds();
            Insets insets = this.getInsets();
            if (SplitDockStation.this.fullScreenDockable != null) {
                SplitDockStation.this.fullScreenDockable.getDisplayer().getComponent().setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.bottom - insets.top);
            }
        }

        public void setTransparency(Transparency transparency) {
            super.setTransparency(transparency);
            SplitDockStation.this.setSolid(transparency == Transparency.SOLID);
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background() {
            super(StationBackgroundComponent.KIND, "dock.background.station.split");
        }

        public Component getComponent() {
            return SplitDockStation.this.getComponent();
        }

        public DockStation getStation() {
            return SplitDockStation.this;
        }
    }
}

