/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import java.awt.EventQueue;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

public class DockHierarchyLock {
    private volatile Token token = null;
    private boolean hardExceptions = false;
    private volatile int concurrent = 0;
    private Queue<Runnable> onRelease = new LinkedList<Runnable>();
    private boolean onReleaseRunning = false;

    public void setHardExceptions(boolean hardExceptions) {
        this.hardExceptions = hardExceptions;
    }

    public boolean isHardExceptions() {
        return this.hardExceptions;
    }

    public synchronized void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent ? ++this.concurrent : --this.concurrent;
    }

    public boolean isConcurrent() {
        return this.concurrent > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRelease(Runnable run) {
        if (run == null) {
            throw new IllegalArgumentException("run must not be null");
        }
        Queue<Runnable> queue = this.onRelease;
        synchronized (queue) {
            this.onRelease.add(run);
        }
        this.runOnRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runOnRelease() {
        if (EventQueue.isDispatchThread()) {
            if (this.onReleaseRunning) return;
            DockHierarchyLock dockHierarchyLock = this;
            // MONITORENTER : dockHierarchyLock
            if (this.token != null) {
                // MONITOREXIT : dockHierarchyLock
                return;
            }
            // MONITOREXIT : dockHierarchyLock
            try {
                this.onReleaseRunning = true;
                while (true) {
                    Runnable run = null;
                    Queue<Runnable> queue = this.onRelease;
                    // MONITORENTER : queue
                    run = this.onRelease.poll();
                    // MONITOREXIT : queue
                    if (run == null) {
                        return;
                    }
                    run.run();
                }
            }
            finally {
                this.onReleaseRunning = false;
            }
        }
        final AtomicBoolean blocking = new AtomicBoolean(true);
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DockHierarchyLock.this.runOnRelease();
                AtomicBoolean atomicBoolean = blocking;
                synchronized (atomicBoolean) {
                    blocking.set(false);
                    blocking.notifyAll();
                }
            }
        });
        long timeout = System.currentTimeMillis() + 1000L;
        AtomicBoolean atomicBoolean = blocking;
        // MONITORENTER : atomicBoolean
        while (true) {
            if (!blocking.get()) {
                // MONITOREXIT : atomicBoolean
                return;
            }
            long now = System.currentTimeMillis();
            if (timeout <= now) {
                return;
            }
            try {
                blocking.wait(timeout - now);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public static Token acquireLinking(DockStation station, Dockable dockable) {
        DockController controller = station.getController();
        if (controller == null) {
            return new Token(null, station, dockable, true);
        }
        return controller.getHierarchyLock().acquireLink(station, dockable);
    }

    public static Token acquireUnlinking(DockStation station, Dockable dockable) {
        DockController controller = station.getController();
        if (controller == null) {
            return new Token(null, station, dockable, true);
        }
        return controller.getHierarchyLock().acquireUnlink(station, dockable);
    }

    public static Token acquiring(DockStation station) {
        DockController controller = station.getController();
        if (controller == null) {
            return new Token(null, station);
        }
        return controller.getHierarchyLock().acquire(station);
    }

    public static Token acquireFake() {
        return new Token(null, null, null, false);
    }

    private String defaultMessage() {
        return "During an operation the framework attempted to acquire the same lock twice. There are two possible explanations:\n1. In a multi-threaded application one or both operations are not executed in the EventDispatchThread, or\n2. The operations are calling each other, which should not happen.\nPlease verify that this application is not accessing the framework from different threads, and fill a bugreport if you feel that this exception is not caused by your application.";
    }

    public synchronized Token acquireLink(DockStation station, Dockable dockable) {
        if (station == null) {
            throw new IllegalArgumentException("station is null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        this.ensureUnlinked(station, dockable);
        if (this.isConcurrent()) {
            return new Token(this, station, dockable, true);
        }
        if (this.token != null) {
            this.throwException(new IllegalStateException(this.defaultMessage()));
        }
        this.token = new Token(this, station, dockable, true);
        return this.token;
    }

    public synchronized Token acquireUnlink(DockStation station, Dockable dockable) {
        if (station == null) {
            throw new IllegalArgumentException("station is null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        this.ensureLinked(station, dockable);
        if (this.isConcurrent()) {
            return new Token(this, station, dockable, false);
        }
        if (this.token != null) {
            this.throwException(new IllegalStateException(this.defaultMessage()));
        }
        this.token = new Token(this, station, dockable, false);
        return this.token;
    }

    public synchronized Token acquire(DockStation station) {
        if (this.isConcurrent()) {
            return new Token(this, station);
        }
        if (this.token != null) {
            this.throwException(new IllegalStateException(this.defaultMessage()));
        }
        this.token = new Token(this, station);
        return this.token;
    }

    private void ensureLinked(DockStation station, Dockable dockable) {
        if (dockable.getDockParent() != station) {
            this.throwException(new IllegalStateException("the parent of '" + dockable + "' is not '" + station + "' but '" + dockable.getDockParent() + "'"));
            return;
        }
        boolean found = false;
        int n = station.getDockableCount();
        for (int i = 0; i < n && !found; ++i) {
            if (station.getDockable(i) != dockable) continue;
            found = true;
        }
        if (!found) {
            this.throwException(new IllegalStateException("the station '" + station + "' does not know '" + dockable + "'"));
            return;
        }
    }

    private void ensureUnlinked(DockStation station, Dockable dockable) {
        if (dockable.getDockParent() != null) {
            this.throwException(new IllegalStateException("The parent of '" + dockable + "' is not null but '" + dockable.getDockParent() + "'"));
            return;
        }
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            if (station.getDockable(i) != dockable) continue;
            this.throwException(new IllegalStateException("The station '" + station + "' knows of '" + dockable + "'"));
            return;
        }
    }

    private void throwException(RuntimeException exception) {
        if (this.hardExceptions) {
            throw exception;
        }
        exception.printStackTrace();
    }

    public static class Token {
        private DockHierarchyLock lock;
        private DockStation station;
        private Dockable dockable;
        private boolean link;

        private Token(DockHierarchyLock lock, DockStation station) {
            this.lock = lock;
            this.station = station;
        }

        private Token(DockHierarchyLock lock, DockStation station, Dockable dockable, boolean link) {
            this.lock = lock;
            this.station = station;
            this.dockable = dockable;
            this.link = link;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Token token = this;
            synchronized (token) {
                if (this.lock != null) {
                    boolean release;
                    boolean bl = release = this.lock.token == this;
                    if (release) {
                        this.lock.token = null;
                    }
                    if (this.dockable != null) {
                        if (this.link) {
                            this.lock.ensureLinked(this.station, this.dockable);
                        } else {
                            this.lock.ensureUnlinked(this.station, this.dockable);
                        }
                    }
                    if (release) {
                        this.lock.runOnRelease();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseNoCheck() {
            Token token = this;
            synchronized (token) {
                if (this.lock != null) {
                    this.lock.token = null;
                }
            }
        }
    }
}

