/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.EclipseBasicDockableDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.EclipseDockableDisplayer2;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.NoTitleBarDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexSystemColor;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class EclipseDisplayerFactory
implements DisplayerFactory {
    private EclipseTheme theme;

    public EclipseDisplayerFactory(EclipseTheme theme) {
        this.theme = theme;
    }

    public void request(DisplayerRequest request) {
        DockTitle title;
        Dockable dockable = request.getTarget();
        DockStation station = request.getParent();
        DockableDisplayer displayer = this.create(station, dockable, title = request.getTitle());
        if (displayer != null) {
            request.answer(displayer);
        }
    }

    protected DockableDisplayer create(DockStation station, Dockable dockable, DockTitle title) {
        EclipseThemeConnector.TitleBar bar = this.theme.getThemeConnector(station.getController()).getTitleBarKind(station, dockable);
        switch (bar) {
            case NONE: 
            case NONE_BORDERED: 
            case NONE_HINTED: 
            case NONE_HINTED_BORDERED: {
                return new NoTitleBarDisplayer(station, dockable, title, bar);
            }
            case ECLIPSE: {
                return new EclipseDockableDisplayer2(this.theme, station, dockable, title);
            }
            case BASIC_BORDERED: {
                return this.create(station, dockable, title, true, bar);
            }
        }
        return this.create(station, dockable, title, false, bar);
    }

    protected BasicDockableDisplayer create(DockStation station, Dockable dockable, DockTitle title, boolean border, EclipseThemeConnector.TitleBar bar) {
        DockableDisplayer.Location location = DockableDisplayer.Location.TOP;
        if (dockable.asDockStation() != null) {
            location = DockableDisplayer.Location.LEFT;
        }
        EclipseBasicDockableDisplayer displayer = border ? new EclipseBasicDockableDisplayer(station, dockable, title, location, bar){

            protected Border getDefaultBorder() {
                return new LineBorder(RexSystemColor.getBorderColor());
            }
        } : new EclipseBasicDockableDisplayer(station, dockable, title, location, bar){

            protected Border getDefaultBorder() {
                return null;
            }
        };
        return displayer;
    }
}

