/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.NoResultException;
import javax.swing.ImageIcon;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.catalog.entity.manager.DatabaseUtils;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.manager.XBCXFileManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBEXFileManager
extends XBEDefaultCatalogManager<XBCXFile>
implements XBCXFileManager,
Serializable {
    public XBEXFileManager() {
    }

    public XBEXFileManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBEXFile.class;
    }

    public Long getAllFilesCount() {
        try {
            return (Long)this.catalog.getEntityManager().createQuery("SELECT count(o) FROM XBXFile as o").getSingleResult();
        }
        catch (NoResultException ex) {
            return 0L;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXFileManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBEXFile findById(long id) {
        try {
            return (XBEXFile)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXFile as o WHERE o.id = " + id).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXFileManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Long[] getFileXBPath(XBCXFile file) {
        ArrayList<Long> list = new ArrayList<Long>();
        XBCNode parent = file.getNode();
        while (parent != null) {
            if (parent.getParent().isPresent()) {
                list.add(0, parent.getXBIndex());
            }
            parent = parent.getParent().orElse(null);
        }
        list.add(file.getId());
        return list.toArray(new Long[list.size()]);
    }

    public void initializeExtension() {
    }

    public String getExtensionName() {
        return "File Repository Extension";
    }

    public XBEXFile findFile(XBCNode node, String fileName) {
        try {
            return (XBEXFile)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXFile as o WHERE o.node.id = " + node.getId() + " AND o.filename = '" + DatabaseUtils.sqlEscapeString(fileName) + "'").getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXFileManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ImageIcon getFileAsImageIcon(XBCXFile iconFile) {
        if (iconFile.getContent() == null) {
            return new ImageIcon();
        }
        return new ImageIcon(iconFile.getContent());
    }

    public InputStream getFile(XBCXFile file) {
        if (file.getContent() == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(file.getContent());
    }

    public OutputStream setFile(XBCXFile file) {
        return new OutputStreamImpl(file);
    }

    public List<XBCXFile> findFilesForNode(XBCNode node) {
        try {
            return this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXFile as o WHERE o.node.id = " + node.getId()).getResultList();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXFileManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static class OutputStreamImpl
    extends OutputStream {
        private final XBCXFile file;
        private final ByteArrayOutputStream outputStream;

        public OutputStreamImpl(XBCXFile file) {
            this.file = file;
            this.outputStream = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            ((XBEXFile)this.file).setContent(this.outputStream.toByteArray());
        }
    }
}

