/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.component.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.component.ComponentModule;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActions;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandlerEmpty;
import org.exbin.framework.component.api.toolbar.MoveItemActions;
import org.exbin.framework.component.api.toolbar.MoveItemActionsHandler;
import org.exbin.framework.component.api.toolbar.MoveItemActionsHandlerEmpty;
import org.exbin.framework.component.api.toolbar.SideToolBar;
import org.exbin.framework.utils.TestApplication;
import org.exbin.framework.utils.UtilsModule;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ToolBarSidePanel
extends JPanel
implements SideToolBar {
    private JToolBar toolBar = null;
    private ToolBarPosition toolBarPosition = ToolBarPosition.LEFT;

    public ToolBarSidePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        TestApplication testApplication = UtilsModule.getDefaultAppEditor();
        ComponentModule guiComponentModule = new ComponentModule();
        testApplication.addModule(ComponentModule.MODULE_ID, (XBApplicationModule)guiComponentModule);
        ToolBarSidePanel toolBarSidePanel = new ToolBarSidePanel();
        MoveItemActionsHandlerEmpty moveItemActionsHandler = new MoveItemActionsHandlerEmpty();
        MoveItemActions moveItemActions = guiComponentModule.createMoveItemActions((MoveItemActionsHandler)moveItemActionsHandler);
        toolBarSidePanel.addActions((ActionsProvider)moveItemActions);
        toolBarSidePanel.addSeparator();
        EditItemActionsHandlerEmpty editItemActionsHandler = new EditItemActionsHandlerEmpty();
        EditItemActions editItemActions = guiComponentModule.createEditItemActions((EditItemActionsHandler)editItemActionsHandler);
        toolBarSidePanel.addActions((ActionsProvider)editItemActions);
        WindowUtils.invokeDialog((JComponent)toolBarSidePanel);
    }

    public void addAction(Action action) {
        this.initToolBar();
        this.toolBar.add(action);
    }

    public void addActions(ActionsProvider actionsProvider) {
        actionsProvider.registerActions((SideToolBar)this);
    }

    public void addSeparator() {
        this.initToolBar();
        this.toolBar.addSeparator();
    }

    private void initToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.setOrientation(1);
            this.toolBar.setFloatable(false);
            this.add((Component)this.toolBar, this.toolBarPosition == ToolBarPosition.LEFT ? "West" : "East");
        }
    }

    @Nonnull
    public ToolBarPosition getToolBarPosition() {
        return this.toolBarPosition;
    }

    public void setToolBarPosition(ToolBarPosition toolBarPosition) {
        this.toolBarPosition = toolBarPosition;
    }

    public static enum ToolBarPosition {
        LEFT,
        RIGHT;

    }
}

