/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRBlockRev;
import org.exbin.xbup.client.catalog.remote.XBRFormatRev;
import org.exbin.xbup.client.catalog.remote.XBRGroupRev;
import org.exbin.xbup.client.catalog.remote.XBRRev;
import org.exbin.xbup.client.stub.XBPBaseProcedureType;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBPRevStub
extends XBPBaseStub<XBCRev> {
    public static long[] FINDREV_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 4L, 0L};
    public static long[] REVSCOUNT_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 9L, 0L};
    public static long[] REV_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 10L, 0L};
    public static long[] REVS_SPEC_PROCEDURE = new long[]{0L, 2L, 5L, 11L, 0L};
    public static long[] XBLIMIT_REV_PROCEDURE = new long[]{0L, 2L, 7L, 0L, 0L};
    public static long[] REVSCOUNT_REV_PROCEDURE = new long[]{0L, 2L, 7L, 1L, 0L};
    private final XBCatalogServiceClient client;

    public XBPRevStub(XBCatalogServiceClient client) {
        super(client, XBRRev::new, new XBPBaseProcedureType(null, null, null, null, (XBBlockType)new XBDeclBlockType(REVSCOUNT_REV_PROCEDURE)));
        this.client = client;
    }

    public Long getXBLimit(long revId) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(XBLIMIT_REV_PROCEDURE), revId);
    }

    public XBRRev findRevByXB(XBCSpec spec, long xbIndex) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(FINDREV_SPEC_PROCEDURE));
            serialInput.putAttribute(spec.getId());
            serialInput.putAttribute(xbIndex);
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            UBNat32 index = new UBNat32();
            serialOutput.process((XBSerializable)index);
            procedureCall.execute();
            long rev = index.getLong();
            if (spec instanceof XBCBlockSpec) {
                return new XBRBlockRev(this.client, rev);
            }
            if (spec instanceof XBCGroupSpec) {
                return new XBRGroupRev(this.client, rev);
            }
            if (spec instanceof XBCFormatSpec) {
                return new XBRFormatRev(this.client, rev);
            }
            return new XBRRev(this.client, rev);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPRevStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBRRev getRev(XBCSpec spec, long orderIndex) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(REV_SPEC_PROCEDURE));
            serialInput.putAttribute(spec.getId());
            serialInput.putAttribute(orderIndex);
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            UBNat32 index = new UBNat32();
            serialOutput.process((XBSerializable)index);
            procedureCall.execute();
            long rev = index.getLong();
            if (spec instanceof XBCBlockSpec) {
                return new XBRBlockRev(this.client, rev);
            }
            if (spec instanceof XBCGroupSpec) {
                return new XBRGroupRev(this.client, rev);
            }
            if (spec instanceof XBCFormatSpec) {
                return new XBRFormatRev(this.client, rev);
            }
            return new XBRRev(this.client, rev);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPRevStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCRev> getRevs(XBCSpec spec) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(REVS_SPEC_PROCEDURE));
            serialInput.putAttribute(spec.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCRev> result = new ArrayList<XBCRev>();
                int i = 0;
                while ((long)i < count) {
                    long rev = serialOutput.pullLongAttribute();
                    if (spec instanceof XBCBlockSpec) {
                        result.add(new XBRBlockRev(this.client, rev));
                    } else if (spec instanceof XBCGroupSpec) {
                        result.add(new XBRGroupRev(this.client, rev));
                    } else if (spec instanceof XBCFormatSpec) {
                        result.add(new XBRFormatRev(this.client, rev));
                    } else {
                        result.add(new XBRRev(this.client, rev));
                    }
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBRRev findRevById(long id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getRevsCount(XBCSpec spec) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(REVSCOUNT_REV_PROCEDURE), spec.getId());
    }
}

