/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRNode;
import org.exbin.xbup.client.stub.XBPXFileStub;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.util.StreamUtils;

public class XBRXFile
implements XBCXFile {
    private final long id;
    protected XBCatalogServiceClient client;
    private final XBPXFileStub fileStub;

    public XBRXFile(XBCatalogServiceClient client, long id) {
        this.id = id;
        this.client = client;
        this.fileStub = new XBPXFileStub(client);
    }

    public XBRNode getNode() {
        return this.fileStub.getNode(this.id);
    }

    public String getFilename() {
        return this.fileStub.getFilename(this.id);
    }

    public byte[] getContent() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StreamUtils.copyInputStreamToOutputStream((InputStream)this.fileStub.getFile(this), (OutputStream)byteArrayOutputStream);
        }
        catch (IOException ex) {
            Logger.getLogger(XBRXFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public long getId() {
        return this.id;
    }
}

