/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRBlockSpec;
import org.exbin.xbup.client.catalog.remote.XBRFormatSpec;
import org.exbin.xbup.client.catalog.remote.XBRGroupSpec;
import org.exbin.xbup.client.catalog.remote.XBRNode;
import org.exbin.xbup.client.catalog.remote.XBRSpecDef;
import org.exbin.xbup.client.catalog.remote.service.XBRInfoService;
import org.exbin.xbup.client.catalog.remote.service.XBRItemService;
import org.exbin.xbup.client.catalog.remote.service.XBRNodeService;
import org.exbin.xbup.client.catalog.remote.service.XBRRevService;
import org.exbin.xbup.client.catalog.remote.service.XBRRootService;
import org.exbin.xbup.client.catalog.remote.service.XBRSpecService;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.XBGroup;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCFormatDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCGroupDecl;
import org.exbin.xbup.core.block.declaration.local.XBLGroupDecl;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCExtension;
import org.exbin.xbup.core.catalog.base.XBCFormatRev;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupRev;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.manager.XBCManager;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.exbin.xbup.core.catalog.base.service.XBCService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXInfoService;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;

public class XBRCatalog
implements XBCatalog {
    private XBCatalogServiceClient client;
    protected Map<Class, XBCManager<?>> catalogManagers;
    protected Map<Class, XBCService<?>> catalogServices;

    public XBRCatalog(XBCatalogServiceClient client) {
        this.client = client;
        this.catalogManagers = new HashMap();
        this.catalogServices = new HashMap();
        this.catalogServices.put(XBCItemService.class, new XBRItemService(this));
        this.catalogServices.put(XBCRootService.class, new XBRRootService(this));
        this.catalogServices.put(XBCNodeService.class, new XBRNodeService(this));
        this.catalogServices.put(XBCSpecService.class, new XBRSpecService(this));
        this.catalogServices.put(XBCXInfoService.class, new XBRInfoService(this));
        this.catalogServices.put(XBCRevService.class, new XBRRevService(this));
    }

    public XBContext getRootContext() {
        XBRNode node;
        XBRNodeService nodeService = (XBRNodeService)this.getCatalogService(XBCNodeService.class);
        XBRSpecService specService = (XBRSpecService)this.getCatalogService(XBCSpecService.class);
        XBRFormatSpec spec = specService.findFormatSpecByXB(node = (XBRNode)nodeService.getMainRootNode().get(), 0L);
        if (spec == null) {
            return null;
        }
        return new XBContext();
    }

    public XBRFormatSpec findFormatSpecByPath(Long[] xbCatalogPath) {
        XBRNodeService nodeService = (XBRNodeService)this.getCatalogService(XBCNodeService.class);
        XBRSpecService specService = (XBRSpecService)this.getCatalogService(XBCSpecService.class);
        XBRNode node = nodeService.findOwnerByXBPath(xbCatalogPath);
        if (node == null) {
            return null;
        }
        return specService.findFormatSpecByXB(node, xbCatalogPath[xbCatalogPath.length - 1]);
    }

    public XBRGroupSpec findGroupSpecByPath(Long[] xbCatalogPath) {
        XBRNodeService nodeService = (XBRNodeService)this.getCatalogService(XBCNodeService.class);
        XBRSpecService specService = (XBRSpecService)this.getCatalogService(XBCSpecService.class);
        XBRNode node = nodeService.findOwnerByXBPath(xbCatalogPath);
        if (node == null) {
            return null;
        }
        return specService.findGroupSpecByXB(node, xbCatalogPath[xbCatalogPath.length - 1]);
    }

    public XBRBlockSpec findBlockSpecByPath(Long[] xbCatalogPath) {
        XBRNodeService nodeService = (XBRNodeService)this.getCatalogService(XBCNodeService.class);
        XBRSpecService specService = (XBRSpecService)this.getCatalogService(XBCSpecService.class);
        XBRNode node = nodeService.findOwnerByXBPath(xbCatalogPath);
        if (node == null) {
            return null;
        }
        return specService.findBlockSpecByXB(node, xbCatalogPath[xbCatalogPath.length - 1]);
    }

    public XBBlockDecl findBlockTypeByPath(Long[] xbCatalogPath, int revision) {
        XBRRevService revService = (XBRRevService)this.getCatalogService(XBCRevService.class);
        XBRBlockSpec spec = this.findBlockSpecByPath(xbCatalogPath);
        if (spec == null) {
            return null;
        }
        XBCBlockRev rev = (XBCBlockRev)revService.findRevByXB(spec, revision);
        if (rev == null) {
            return null;
        }
        return new XBCBlockDecl(rev, (XBCatalog)this);
    }

    public XBGroupDecl findGroupTypeByPath(Long[] xbCatalogPath, int revision) {
        XBRRevService revService = (XBRRevService)this.getCatalogService(XBCRevService.class);
        XBRGroupSpec spec = this.findGroupSpecByPath(xbCatalogPath);
        if (spec == null) {
            return null;
        }
        XBCGroupRev rev = (XBCGroupRev)revService.findRevByXB(spec, revision);
        if (rev == null) {
            return null;
        }
        return new XBCGroupDecl(rev, (XBCatalog)this);
    }

    public XBFormatDecl findFormatTypeByPath(Long[] xbCatalogPath, int revision) {
        XBRRevService revService = (XBRRevService)this.getCatalogService(XBCRevService.class);
        XBRFormatSpec spec = this.findFormatSpecByPath(xbCatalogPath);
        if (spec == null) {
            return null;
        }
        XBCFormatRev rev = (XBCFormatRev)revService.findRevByXB(spec, revision);
        if (rev == null) {
            return null;
        }
        return new XBCFormatDecl(rev, (XBCatalog)this);
    }

    public List<XBGroupDecl> getGroups(XBCFormatSpec spec) {
        XBRSpecService specService = (XBRSpecService)this.getCatalogService(XBCSpecService.class);
        List<XBCSpecDef> binds = specService.getSpecDefs((XBCSpec)spec);
        ArrayList<XBGroupDecl> result = new ArrayList<XBGroupDecl>();
        Iterator<XBCSpecDef> it = binds.iterator();
        while (it.hasNext()) {
            result.add((XBGroupDecl)new XBCGroupDecl((XBCGroupRev)((XBRSpecDef)it.next()).getTargetRev().get(), (XBCatalog)this));
        }
        return result;
    }

    public List<XBBlockDecl> getBlocks(XBCGroupSpec spec) {
        XBRSpecService specService = (XBRSpecService)this.getCatalogService(XBCSpecService.class);
        List<XBCSpecDef> binds = specService.getSpecDefs((XBCSpec)spec);
        ArrayList<XBBlockDecl> result = new ArrayList<XBBlockDecl>();
        Iterator<XBCSpecDef> it = binds.iterator();
        while (it.hasNext()) {
            result.add((XBBlockDecl)new XBCBlockDecl((XBCBlockRev)((XBRSpecDef)it.next()).getTargetRev().get(), (XBCatalog)this));
        }
        return result;
    }

    public List<XBCService<?>> getCatalogServices() {
        return new ArrayList(this.catalogServices.values());
    }

    public List<XBCManager<?>> getCatalogManagers() {
        return new ArrayList(this.catalogManagers.values());
    }

    public <T extends XBCManager<?>> void addCatalogManager(Class<T> type, T manager) {
        this.catalogManagers.put(type, manager);
        if (manager instanceof XBCExtension) {
            ((XBCExtension)manager).initializeExtension();
        }
    }

    public <T extends XBCService<?>> void addCatalogService(Class<T> type, T service) {
        this.catalogServices.put(type, service);
        if (service instanceof XBCExtension) {
            ((XBCExtension)service).initializeExtension();
        }
    }

    public XBCatalogServiceClient getCatalogServiceClient() {
        return this.client;
    }

    public void setCatalogServiceClient(XBCatalogServiceClient client) {
        this.client = client;
    }

    @Nonnull
    public <T extends XBCManager<?>> T getCatalogManager(@Nonnull Class<T> managerClass) {
        return (T)this.catalogManagers.get(managerClass);
    }

    @Nonnull
    public <T extends XBCService<?>> T getCatalogService(@Nonnull Class<T> serviceClass) {
        return (T)this.catalogServices.get(serviceClass);
    }

    public Long findBlockIdForGroup(XBGroup group, XBBlockDecl decl) {
        List blocks = group.getBlocks();
        for (int blockId = 0; blockId < blocks.size(); ++blockId) {
            XBBlockDecl block = (XBBlockDecl)blocks.get(blockId);
            if (!block.equals(decl)) continue;
            return blockId;
        }
        return null;
    }

    public Long findBlockIdForGroup(XBGroupDecl group, XBBlockDecl decl) {
        if (group instanceof XBLGroupDecl) {
            List blocks = ((XBLGroupDecl)group).getBlockDecls();
            for (int blockId = 0; blockId < blocks.size(); ++blockId) {
                XBBlockDecl block = (XBBlockDecl)blocks.get(blockId);
                if (!block.equals(decl)) continue;
                return blockId;
            }
        } else if (group instanceof XBCGroupSpec) {
            XBCGroupRev groupRev = ((XBCGroupDecl)group).getGroupSpecRev();
            List<XBBlockDecl> blocks = this.getBlocks(groupRev.getParent());
            Long limit = groupRev.getXBLimit();
            for (int blockId = 0; blockId < blocks.size() && (long)blockId < limit; ++blockId) {
                XBBlockDecl block = blocks.get(blockId);
                if (!block.equals(decl)) continue;
                return blockId;
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return null;
    }

    public XBContext processDeclaration(XBContext parent, XBTPullProvider blockProvider) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Long[] getSpecPath(XBCSpec spec) {
        XBRSpecService specService = (XBRSpecService)this.getCatalogService(XBCSpecService.class);
        return specService.getSpecXBPath(spec);
    }

    public XBBlockType getBasicBlockType(XBBasicBlockType blockType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

