/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.exbin.xbup.core.type.XBData;

public class XBLoggingInputStream
extends InputStream {
    @Nonnull
    private final XBData data = new XBData();
    @Nonnull
    private final InputStream sourceInputStream;

    public XBLoggingInputStream(@Nonnull InputStream sourceInputStream) {
        this.sourceInputStream = sourceInputStream;
    }

    @Override
    public int read() throws IOException {
        int result = this.sourceInputStream.read();
        if (result >= 0) {
            this.data.setByte(this.data.getDataSize(), (byte)result);
        }
        return result;
    }

    @Override
    public int read(@Nonnull byte[] bufferData, int offset, int length) throws IOException {
        int read = this.sourceInputStream.read(bufferData, offset, length);
        if (read >= 0) {
            this.data.insert(this.data.getDataSize(), bufferData, offset, length);
        }
        return read;
    }

    @Override
    public int read(@Nonnull byte[] bufferData) throws IOException {
        int read = this.sourceInputStream.read(bufferData);
        if (read >= 0) {
            this.data.insert(this.data.getDataSize(), bufferData);
        }
        return read;
    }

    @Nonnull
    public XBData getData() {
        return this.data;
    }
}

