/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.ubnumber.type;

import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.ubnumber.UBInteger;
import org.exbin.xbup.core.ubnumber.UBReal;
import org.exbin.xbup.core.ubnumber.exception.UBOverFlowException;
import org.exbin.xbup.core.ubnumber.type.UBInt32;

@ParametersAreNonnullByDefault
public class UBRea
implements UBReal,
XBPSequenceSerializable {
    private UBInteger value;
    private UBInteger mantissa;

    public UBRea() {
        this.value = new UBInt32();
        this.mantissa = new UBInt32();
    }

    public UBRea(float srcValue) {
        this.setFloatValue(srcValue);
    }

    public UBRea(UBReal real) {
        this.value = real.getBase();
        this.mantissa = real.getMantissa();
    }

    @Override
    public int getInt() throws UBOverFlowException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getLong() throws UBOverFlowException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getFloat() throws UBOverFlowException {
        if (this.mantissa.isZero()) {
            if (this.value.isZero()) {
                return 0.0f;
            }
            long valueLong = this.value.getLong();
            return valueLong > 0L ? (float)(valueLong * 2L - 1L) : (float)(valueLong * 2L + 1L);
        }
        long valueLong = this.value.getLong();
        long mantissaLong = this.mantissa.getLong();
        if (mantissaLong > 0L) {
            return (float)(((double)valueLong * 2.0 + 1.0) * (double)(1 << (int)mantissaLong));
        }
        return (float)(((double)valueLong * 2.0 + 1.0) / (double)(1 << (int)(-mantissaLong)));
    }

    @Override
    public double getDouble() throws UBOverFlowException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UBInteger getBase() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UBInteger getMantissa() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isZero() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setValue(int value) throws UBOverFlowException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setValue(long value) throws UBOverFlowException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setValue(float value) throws UBOverFlowException {
        this.setFloatValue(value);
    }

    @Override
    public void setValue(double value) throws UBOverFlowException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void setFloatValue(float srcValue) {
        long valueLong = 0L;
        long mantissaLong = 0L;
        if (srcValue > 0.0f) {
            if ((double)srcValue - Math.floor(srcValue) > 0.0) {
                boolean hasTail;
                do {
                    float nextValue;
                    boolean bl = hasTail = (double)(nextValue = srcValue * 2.0f) - Math.floor(nextValue) > 0.0;
                    if (!hasTail) continue;
                    srcValue = nextValue;
                } while (hasTail && --mantissaLong > -32L);
                valueLong = (long)Math.floor(srcValue);
            } else {
                boolean hasTail;
                do {
                    float nextValue;
                    boolean bl = hasTail = (double)(nextValue = srcValue / 2.0f) - Math.floor(nextValue) > 0.0;
                    if (!hasTail) {
                        ++mantissaLong;
                    }
                    srcValue = nextValue;
                } while (!hasTail && mantissaLong < 32L);
                valueLong = (long)Math.floor(srcValue) + (long)(mantissaLong == 0L ? 1 : 0);
            }
        } else if (srcValue < 0.0f) {
            if ((double)srcValue - Math.ceil(srcValue) < 0.0) {
                boolean hasTail;
                do {
                    float nextValue;
                    boolean bl = hasTail = (double)(nextValue = srcValue * 2.0f) - Math.ceil(nextValue) < 0.0;
                    if (!hasTail) continue;
                    srcValue = nextValue;
                } while (hasTail && --mantissaLong > -32L);
                valueLong = (long)Math.floor(srcValue);
            } else {
                boolean hasTail;
                do {
                    float nextValue;
                    boolean bl = hasTail = (double)(nextValue = srcValue / 2.0f) - Math.ceil(nextValue) < 0.0;
                    if (!hasTail) {
                        ++mantissaLong;
                    }
                    srcValue = nextValue;
                } while (!hasTail && mantissaLong < 32L);
                valueLong = (long)Math.floor(srcValue);
            }
        }
        this.value = new UBInt32(valueLong);
        this.mantissa = new UBInt32(mantissaLong);
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.mantissa.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UBRea other = (UBRea)obj;
        return this.value.equals(other.value) && this.mantissa.equals(other.mantissa);
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        serial.attribute(this.value);
        serial.attribute(this.mantissa);
        serial.end();
    }
}

