/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.ubnumber.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.ubnumber.UBENatural;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.exception.UBOverFlowException;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class UBENat32
implements UBENatural {
    private static long MAX_VALUE = 0xFFFFFFFFL;
    private long value;
    private boolean infinity;

    public UBENat32() {
        this.value = 0L;
        this.infinity = false;
    }

    public UBENat32(int value) {
        this.value = value;
        this.infinity = false;
    }

    public UBENat32(long value) {
        this.value = value;
        this.infinity = false;
    }

    private UBENat32(UBENat32 value) {
        this.infinity = value.isInfinity();
        this.value = value.getLong();
    }

    @Override
    public void setValue(int value) throws UBOverFlowException {
        if (value < 0) {
            throw new UBOverFlowException("Can't set negative value to natural number");
        }
        this.infinity = false;
        this.value = value;
    }

    @Override
    public void setValue(long value) throws UBOverFlowException {
        if (value < 0L) {
            throw new UBOverFlowException("Can't set negative value to natural number");
        }
        if (value > MAX_VALUE) {
            throw new UBOverFlowException("Value too big");
        }
        this.value = value;
        this.infinity = false;
    }

    @Override
    public boolean isInfinity() {
        return this.infinity;
    }

    @Override
    public void setInfinity() {
        this.infinity = true;
    }

    @Override
    public int getInt() throws UBOverFlowException {
        if (this.infinity) {
            throw new UBOverFlowException("Infinity value cannot be converted to int");
        }
        return (int)this.value;
    }

    @Override
    public long getLong() throws UBOverFlowException {
        if (this.infinity) {
            throw new UBOverFlowException("Infinity value cannot be converted to long");
        }
        return this.value;
    }

    @Override
    public boolean isZero() {
        return !this.infinity && this.value == 0L;
    }

    @Override
    public long getSegmentCount() {
        return 1L;
    }

    @Override
    public long getValueSegment(long segmentIndex) {
        if (segmentIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.value;
    }

    @Override
    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        this.infinity = false;
        byte[] buffer = new byte[1];
        this.readBuf(stream, buffer);
        long input = (char)buffer[0] & 0xFF;
        if (input < 127L) {
            this.value = buffer[0];
            return 1;
        }
        if (input == 127L) {
            this.infinity = true;
            return 1;
        }
        if (input < 192L) {
            this.value = (input & 0x7FL) << 8;
            this.readBuf(stream, buffer);
            this.value += (long)(((char)buffer[0] & 0xFF) + 127);
            return 2;
        }
        if (input < 224L) {
            this.value = (input & 0x3FL) << 16;
            this.readBuf(stream, buffer);
            this.value += (long)(((char)buffer[0] & 0xFF) << 8);
            this.readBuf(stream, buffer);
            this.value += (long)(((char)buffer[0] & 0xFF) + 16511);
            return 3;
        }
        if (input < 240L) {
            this.value = (input & 0x1FL) << 24;
            this.readBuf(stream, buffer);
            this.value += (long)(((char)buffer[0] & 0xFF) << 16);
            this.readBuf(stream, buffer);
            this.value += (long)(((char)buffer[0] & 0xFF) << 8);
            this.readBuf(stream, buffer);
            this.value += (long)(((char)buffer[0] & 0xFF) + 2113663);
            return 4;
        }
        if (input < 248L) {
            this.value = (input & 0xFL) << 32;
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 24);
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 16);
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 8);
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) + 270549119);
            if (this.value >= 270549119L) {
                return 5;
            }
        }
        throw new XBProcessingException("Value is too big for 32-bit value", XBProcessingExceptionType.UNSUPPORTED);
    }

    private void readBuf(InputStream stream, byte[] buf) throws IOException {
        if (stream.read(buf) < 0) {
            throw new XBProcessingException("End of data reached", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
    }

    @Override
    public int toStreamUB(OutputStream stream) throws IOException {
        if (this.infinity) {
            int output = 127;
            stream.write(output);
            return 1;
        }
        if (this.value < 127L) {
            stream.write((char)this.value);
            return 1;
        }
        if (this.value < 16511L) {
            long pom = (this.value - 127L >> 8) + 128L;
            stream.write((char)pom);
            pom = this.value - 127L & 0xFFL;
            stream.write((char)pom);
            return 2;
        }
        if (this.value < 2113663L) {
            long pom = (this.value - 16511L >> 16) + 192L;
            stream.write((char)pom);
            pom = this.value - 16511L >> 8 & 0xFFL;
            stream.write((char)pom);
            pom = this.value - 16511L & 0xFFL;
            stream.write((char)pom);
            return 3;
        }
        if (this.value < 270549119L) {
            long pom = (this.value - 2113663L >> 24) + 224L;
            stream.write((char)pom);
            pom = this.value - 2113663L >> 16 & 0xFFL;
            stream.write((char)pom);
            pom = this.value - 2113663L >> 8 & 0xFFL;
            stream.write((char)pom);
            pom = this.value - 2113663L & 0xFFL;
            stream.write((char)pom);
            return 4;
        }
        long outValue = this.value - 270549119L;
        byte[] out = new byte[]{(byte)((outValue >> 32) + 240L), (byte)(outValue >> 24 & 0xFFL), (byte)(outValue >> 16 & 0xFFL), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
        stream.write(out);
        return 5;
    }

    @Override
    public int getSizeUB() {
        if (this.infinity) {
            return 1;
        }
        if (this.value < 127L) {
            return 1;
        }
        if (this.value < 16511L) {
            return 2;
        }
        if (this.value < 2113663L) {
            return 3;
        }
        if (this.value < 270549119L) {
            return 4;
        }
        return 5;
    }

    @Nonnull
    public static UBENat32 getInfinity() {
        UBENat32 value = new UBENat32();
        value.infinity = true;
        return value;
    }

    @Override
    public void setNaturalZero() {
        this.setNaturalLong(0L);
    }

    @Override
    public void setNaturalInt(int intValue) throws UBOverFlowException {
        this.setNaturalLong(this.value);
    }

    @Override
    public void setNaturalLong(long longValue) throws UBOverFlowException {
        if (longValue < 127L) {
            this.value = longValue;
        } else if (longValue == 127L) {
            this.setInfinity();
        } else {
            this.value = longValue - 1L;
        }
    }

    @Override
    public boolean isNaturalZero() {
        return this.value == 0L;
    }

    @Override
    public int getNaturalInt() throws UBOverFlowException {
        return (int)this.getNaturalLong();
    }

    @Override
    public long getNaturalLong() throws UBOverFlowException {
        if (this.infinity) {
            return 127L;
        }
        if (this.value < 127L) {
            return this.value;
        }
        return this.value + 1L;
    }

    @Override
    public void convertFromNatural(UBNatural nat) {
        this.setNaturalLong(nat.getLong());
    }

    @Override
    @Nonnull
    public UBNatural convertToNatural() {
        return new UBNat32(this.getNaturalLong());
    }
}

