/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.child.XBChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerializable;
import org.exbin.xbup.core.serial.child.XBTChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.type.XBCharset;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBEncodingString
implements XBPSequenceSerializable {
    private String value;
    private XBCharset charset;
    static long[] XBUP_FORMATREV_CATALOGPATH = new long[]{1L, 3L, 1L, 2L, 0L, 0L};
    static long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{1L, 3L, 1L, 2L, 0L, 0L};

    public XBEncodingString() {
        this.value = "";
        this.charset = new XBCharset();
    }

    public XBEncodingString(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Charset getCharset() {
        return this.charset.getCharset();
    }

    public void setCharset(Charset charset) {
        this.charset.setCharset(charset);
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        serial.join(this.charset);
        serial.consist(new DataBlockSerializator());
        serial.end();
    }

    @ParametersAreNonnullByDefault
    public class DataBlockSerializator
    implements XBChildSerializable,
    XBTChildSerializable {
        @Override
        public void serializeFromXB(XBChildInputSerialHandler serial) throws XBProcessingException, IOException {
            serial.begin();
            InputStream source = serial.nextData();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                StreamUtils.copyInputStreamToOutputStream(source, stream);
            }
            catch (IOException ex) {
                Logger.getLogger(XBEncodingString.class.getName()).log(Level.SEVERE, null, ex);
            }
            XBEncodingString.this.setValue(new String(stream.toByteArray(), XBEncodingString.this.charset.getCharset()));
            serial.end();
        }

        @Override
        public void serializeToXB(XBChildOutputSerialHandler serial) throws XBProcessingException, IOException {
            serial.begin(XBBlockTerminationMode.SIZE_SPECIFIED);
            if (XBEncodingString.this.getValue() != null) {
                serial.addData(new ByteArrayInputStream(XBEncodingString.this.getValue().getBytes(XBEncodingString.this.charset.getCharset())));
            } else {
                serial.addData(new ByteArrayInputStream(new byte[0]));
            }
            serial.end();
        }

        @Override
        public void serializeFromXB(XBTChildInputSerialHandler serial) throws XBProcessingException, IOException {
            serial.pullBegin();
            InputStream source = serial.pullData();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                StreamUtils.copyInputStreamToOutputStream(source, stream);
            }
            catch (IOException ex) {
                Logger.getLogger(XBEncodingString.class.getName()).log(Level.SEVERE, null, ex);
            }
            XBEncodingString.this.setValue(new String(stream.toByteArray(), XBEncodingString.this.charset.getCharset()));
            serial.pullEnd();
        }

        @Override
        public void serializeToXB(XBTChildOutputSerialHandler serial) throws XBProcessingException, IOException {
            serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
            if (XBEncodingString.this.getValue() != null) {
                serial.putData(new ByteArrayInputStream(XBEncodingString.this.getValue().getBytes(XBEncodingString.this.charset.getCharset())));
            } else {
                serial.putData(new ByteArrayInputStream(new byte[0]));
            }
            serial.putEnd();
        }
    }
}

