/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial.child;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.serial.XBSerialException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.XBWriteSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildOutputSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerialState;
import org.exbin.xbup.core.serial.child.XBChildSerializable;
import org.exbin.xbup.core.serial.token.XBTokenOutputSerialHandler;
import org.exbin.xbup.core.ubnumber.UBNatural;

@ParametersAreNonnullByDefault
public class XBChildListenerSerialHandler
implements XBChildOutputSerialHandler,
XBTokenOutputSerialHandler {
    private XBEventListener eventListener;
    private XBChildSerialState state = XBChildSerialState.BLOCK_BEGIN;
    private XBWriteSerialHandler childHandler = null;
    private int depth = 0;

    public XBChildListenerSerialHandler() {
    }

    public XBChildListenerSerialHandler(XBWriteSerialHandler childHandler) {
        this();
        this.childHandler = childHandler;
    }

    @Override
    public void attachXBEventListener(XBEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public void begin(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state != XBChildSerialState.BLOCK_BEGIN) {
            throw new XBSerialException("Unable to set block terminated mode", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        ++this.depth;
        this.eventListener.putXBToken(XBBeginToken.create(terminationMode));
        this.state = XBChildSerialState.ATTRIBUTE_PART;
    }

    @Override
    public void addAttribute(UBNatural attribute) throws XBSerialException, XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_END) {
            throw new XBSerialException("Unable to add attributes after data or child blocks", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN) {
            this.eventListener.putXBToken(XBBeginToken.create(XBBlockTerminationMode.SIZE_SPECIFIED));
        }
        this.eventListener.putXBToken(XBAttributeToken.create(attribute));
        this.state = XBChildSerialState.ATTRIBUTES;
    }

    @Override
    public void addChild(XBSerializable child) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN) {
            throw new XBSerialException("At least one attribute is needed before child", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_END) {
            throw new XBSerialException("Unable to add child after data", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (child instanceof XBChildSerializable) {
            XBChildListenerSerialHandler childOutput = new XBChildListenerSerialHandler();
            childOutput.attachXBEventListener(this.eventListener);
            ((XBChildSerializable)child).serializeToXB(childOutput);
        } else if (this.childHandler != null) {
            this.childHandler.write(child);
        } else {
            throw new XBProcessingException("Unsupported child serialization", XBProcessingExceptionType.UNKNOWN);
        }
        this.state = XBChildSerialState.CHILDREN;
    }

    @Override
    public void addData(InputStream data) throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.depth == 1 && this.state != XBChildSerialState.BLOCK_BEGIN && this.state != XBChildSerialState.BLOCK_END) {
            this.eventListener.putXBToken(XBDataToken.create(data));
            this.state = XBChildSerialState.BLOCK_END;
            return;
        }
        if (this.state == XBChildSerialState.ATTRIBUTES) {
            throw new XBSerialException("Data block is not allowed after attributes", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.DATA) {
            throw new XBSerialException("Data event is not allowed after another data event", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.CHILDREN) {
            throw new XBSerialException("Data block is not allowed after children", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN) {
            this.eventListener.putXBToken(XBBeginToken.create(XBBlockTerminationMode.SIZE_SPECIFIED));
        }
        this.eventListener.putXBToken(XBDataToken.create(data));
        this.state = XBChildSerialState.DATA;
    }

    @Override
    public void end() throws XBProcessingException, IOException {
        if (this.state == XBChildSerialState.EOF) {
            throw new XBSerialException("Unexpected method after block already finished", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        if (this.state == XBChildSerialState.BLOCK_BEGIN || this.state == XBChildSerialState.ATTRIBUTE_PART) {
            throw new XBSerialException("At least one attribute or data required", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        --this.depth;
        this.eventListener.putXBToken(XBEndToken.create());
    }
}

