/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventProducer;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;

@ParametersAreNonnullByDefault
public class XBTToXBEventDropper
implements XBTEventListener,
XBEventProducer {
    @Nonnull
    private XBEventListener target;
    private boolean typeProcessed;

    public XBTToXBEventDropper(XBEventListener target) {
        this.target = target;
    }

    @Override
    public void attachXBEventListener(XBEventListener eventListener) {
        this.target = eventListener;
        this.typeProcessed = false;
    }

    @Override
    public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
        if (this.typeProcessed && token.getTokenType() != XBTTokenType.ATTRIBUTE) {
            this.target.putXBToken(XBAttributeToken.createZeroToken());
            this.typeProcessed = false;
        }
        switch (token.getTokenType()) {
            case BEGIN: {
                this.target.putXBToken(XBBeginToken.create(((XBTBeginToken)token).getTerminationMode()));
                break;
            }
            case TYPE: {
                this.typeProcessed = true;
                break;
            }
            case ATTRIBUTE: {
                this.target.putXBToken(XBAttributeToken.create(((XBTAttributeToken)token).getAttribute()));
                break;
            }
            case DATA: {
                this.target.putXBToken(XBDataToken.create(((XBTDataToken)token).getData()));
                break;
            }
            case END: {
                this.target.putXBToken(XBEndToken.create());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected token type " + token.getTokenType().toString());
            }
        }
    }
}

