/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.event.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.event.XBTEventFilter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;

@ParametersAreNonnullByDefault
public class XBTPrintEventFilter
implements XBTEventFilter {
    @Nonnull
    private XBTEventListener eventListener;
    @Nonnull
    private String prefix = "";

    public XBTPrintEventFilter(String prefix, XBTEventListener eventListener) {
        this(eventListener);
        this.prefix = prefix;
    }

    public XBTPrintEventFilter(XBTEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
        switch (token.getTokenType()) {
            case BEGIN: {
                System.out.println(this.prefix + "> Begin (" + ((XBTBeginToken)token).getTerminationMode().toString() + "):");
                break;
            }
            case TYPE: {
                XBBlockType blockType = ((XBTTypeToken)token).getBlockType();
                System.out.println(this.prefix + "  Type: " + (blockType instanceof XBFixedBlockType ? "(" + ((XBFixedBlockType)blockType).getGroupID().getInt() + "," + ((XBFixedBlockType)blockType).getBlockID().getInt() + ")" : blockType.getClass().getCanonicalName()));
                break;
            }
            case ATTRIBUTE: {
                System.out.println(this.prefix + "  Attribute: " + ((XBTAttributeToken)token).getAttribute().getNaturalLong());
                break;
            }
            case DATA: {
                System.out.println(this.prefix + "  Data:" + ((XBTDataToken)token).getData().available());
                break;
            }
            case END: {
                System.out.println(this.prefix + "< End.");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected token type " + token.getTokenType().toString());
            }
        }
        if (this.eventListener != null) {
            this.eventListener.putXBTToken(token);
        }
    }

    @Override
    public void attachXBTEventListener(XBTEventListener eventListener) {
        this.eventListener = eventListener;
    }
}

