/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.convert;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.XBTSListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTSBeginToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.ubnumber.UBNatural;

@ParametersAreNonnullByDefault
public class XBTListenerToToken
implements XBTListener,
XBTSListener {
    @Nullable
    private XBTToken token = null;

    @Nullable
    public XBTToken getToken() {
        return this.token;
    }

    public void setToken(@Nullable XBTToken token) {
        this.token = token;
    }

    @Override
    public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        this.token = XBTBeginToken.create(terminationMode);
    }

    @Override
    public void beginXBT(XBBlockTerminationMode terminationMode, @Nullable UBNatural blockSize) throws XBProcessingException, IOException {
        this.token = XBTSBeginToken.create(terminationMode, blockSize);
    }

    @Override
    public void typeXBT(XBBlockType blockType) throws XBProcessingException, IOException {
        this.token = XBTTypeToken.create(blockType);
    }

    @Override
    public void attribXBT(XBAttribute value) throws XBProcessingException, IOException {
        this.token = XBTAttributeToken.create(value);
    }

    @Override
    public void dataXBT(InputStream data) throws XBProcessingException, IOException {
        this.token = XBTDataToken.create(data);
    }

    @Override
    public void endXBT() throws XBProcessingException, IOException {
        this.token = XBTEndToken.create();
    }

    public static void tokenToListener(XBTToken token, XBTListener listener) throws XBProcessingException, IOException {
        switch (token.getTokenType()) {
            case BEGIN: {
                if (token instanceof XBTSBeginToken && listener instanceof XBTSListener) {
                    ((XBTSListener)listener).beginXBT(((XBTSBeginToken)token).getTerminationMode(), ((XBTSBeginToken)token).getBlockSize());
                    break;
                }
                listener.beginXBT(((XBTBeginToken)token).getTerminationMode());
                break;
            }
            case TYPE: {
                listener.typeXBT(((XBTTypeToken)token).getBlockType());
                break;
            }
            case ATTRIBUTE: {
                listener.attribXBT(((XBTAttributeToken)token).getAttribute());
                break;
            }
            case DATA: {
                listener.dataXBT(((XBTDataToken)token).getData());
                break;
            }
            case END: {
                listener.endXBT();
            }
        }
    }
}

