/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.XBProducer;
import org.exbin.xbup.core.parser.basic.XBProvider;
import org.exbin.xbup.core.parser.basic.XBSListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBEndToken;
import org.exbin.xbup.core.parser.token.XBSBeginToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.convert.XBListenerToToken;
import org.exbin.xbup.core.ubnumber.UBNatural;

public class XBProducerToProvider
implements XBProvider {
    private List<XBToken> tokens = new ArrayList<XBToken>();

    public XBProducerToProvider(XBProducer producer) {
        producer.attachXBListener(new XBSListener(){

            @Override
            public void beginXB(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
                XBProducerToProvider.this.tokens.add(XBBeginToken.create(terminationMode));
            }

            @Override
            public void beginXB(XBBlockTerminationMode terminationMode, UBNatural blockSize) throws XBProcessingException, IOException {
                XBProducerToProvider.this.tokens.add(XBSBeginToken.create(terminationMode, blockSize));
            }

            @Override
            public void attribXB(XBAttribute value) throws XBProcessingException, IOException {
                XBProducerToProvider.this.tokens.add(XBAttributeToken.create(value));
            }

            @Override
            public void dataXB(InputStream data) throws XBProcessingException, IOException {
                XBProducerToProvider.this.tokens.add(XBDataToken.create(data));
            }

            @Override
            public void endXB() throws XBProcessingException, IOException {
                XBProducerToProvider.this.tokens.add(XBEndToken.create());
            }
        });
    }

    @Override
    public void produceXB(XBListener listener) throws XBProcessingException, IOException {
        if (!this.tokens.isEmpty()) {
            throw new XBProcessingException("End of data reached", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
        XBToken token = this.tokens.get(0);
        XBListenerToToken.tokenToListener(token, listener);
    }
}

