/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.declaration.catalog;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.declaration.local.XBLGroupDecl;
import org.exbin.xbup.core.block.definition.XBGroupDef;
import org.exbin.xbup.core.block.definition.catalog.XBCGroupDef;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCGroupRev;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBCGroupDecl
implements XBGroupDecl,
XBPSequenceSerializable {
    private XBCGroupRev groupSpecRev;
    private final XBCatalog catalog;

    public XBCGroupDecl(XBCGroupRev groupSpec, XBCatalog catalog) {
        this.groupSpecRev = groupSpec;
        this.catalog = catalog;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof XBCGroupDecl) {
            XBCGroupDecl other = (XBCGroupDecl)obj;
            if (this.groupSpecRev == null || !this.groupSpecRev.equals(other.groupSpecRev)) {
                return false;
            }
            return this.groupSpecRev.getId() == other.groupSpecRev.getId();
        }
        if (obj instanceof XBLGroupDecl) {
            Long[] catalogPath = this.catalog.getSpecPath(this.groupSpecRev.getParent());
            long[] objCatalogPath = ((XBLGroupDecl)obj).getCatalogPath();
            if (objCatalogPath.length != catalogPath.length) {
                return false;
            }
            for (int pathIndex = 0; pathIndex < catalogPath.length; ++pathIndex) {
                if (catalogPath[pathIndex] == objCatalogPath[pathIndex]) continue;
                return false;
            }
            return this.groupSpecRev.getXBIndex() == ((XBLGroupDecl)obj).getRevision();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.groupSpecRev != null ? this.groupSpecRev.hashCode() : 0);
        return hash;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
        serializationHandler.begin();
        serializationHandler.matchType(new XBFixedBlockType(XBBasicBlockType.GROUP_DECLARATION));
        if (serializationHandler.getSerializationMode() == XBSerializationMode.PULL) {
            Long[] catalogPath = new Long[serializationHandler.pullIntAttribute()];
            for (int pathPosition = 0; pathPosition < catalogPath.length; ++pathPosition) {
                catalogPath[pathPosition] = serializationHandler.pullLongAttribute();
            }
            long revision = serializationHandler.pullLongAttribute();
            XBCGroupDecl groupDecl = (XBCGroupDecl)this.catalog.findGroupTypeByPath(catalogPath, (int)revision);
            this.groupSpecRev = groupDecl == null ? null : groupDecl.getGroupSpecRev();
        } else {
            Long[] path = this.catalog.getSpecPath(this.groupSpecRev.getParent());
            serializationHandler.putAttribute(path.length - 1);
            for (Long pathIndex : path) {
                serializationHandler.putAttribute(pathIndex);
            }
            serializationHandler.putAttribute(new UBNat32(this.groupSpecRev.getXBIndex()));
        }
        serializationHandler.end();
    }

    public XBCGroupRev getGroupSpecRev() {
        return this.groupSpecRev;
    }

    public void setGroupSpecRev(XBCGroupRev groupSpecRev) {
        this.groupSpecRev = groupSpecRev;
    }

    @Override
    public List<XBBlockDecl> getBlockDecls() {
        return this.catalog.getBlocks(this.groupSpecRev.getParent());
    }

    @Override
    public XBGroupDef getGroupDef() {
        return new XBCGroupDef(this.catalog, this.groupSpecRev.getParent());
    }

    @Override
    public long getRevision() {
        return this.groupSpecRev.getXBIndex();
    }
}

