/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBDocument;
import org.exbin.xbup.core.type.XBData;

@ParametersAreNonnullByDefault
public class XBDefaultDocument
implements XBDocument {
    @Nonnull
    private final XBBlock rootBlock;
    @Nullable
    private final BinaryData tailData;

    public XBDefaultDocument(XBBlock rootBlock) {
        this(rootBlock, (BinaryData)null);
    }

    public XBDefaultDocument(XBBlock rootBlock, @Nullable BinaryData tailData) {
        this.rootBlock = rootBlock;
        this.tailData = tailData;
    }

    public XBDefaultDocument(XBBlock rootBlock, InputStream tailDataStream) throws IOException {
        this.rootBlock = rootBlock;
        XBData data = new XBData();
        data.loadFromStream(tailDataStream);
        this.tailData = data;
    }

    @Override
    @Nonnull
    public Optional<XBBlock> getRootBlock() {
        return Optional.of(this.rootBlock);
    }

    @Override
    @Nonnull
    public Optional<InputStream> getTailData() {
        return this.tailData == null ? Optional.empty() : Optional.of(this.tailData.getDataInputStream());
    }

    @Override
    public long getTailDataSize() {
        return this.tailData == null ? 0L : this.tailData.getDataSize();
    }

    @Override
    public long getDocumentSize() {
        return -1L;
    }
}

