/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.tool.xbteditor;

import java.awt.Component;
import java.awt.Dimension;
import java.security.AccessControlException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.exbin.framework.XBBaseApplication;
import org.exbin.framework.about.api.AboutModuleApi;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplicationModuleRepository;
import org.exbin.framework.editor.api.EditorModuleApi;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.EditorTextModule;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.frame.api.ApplicationFrameHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.operation.undo.api.OperationUndoModuleApi;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.parser.basic.XBHead;

@ParametersAreNonnullByDefault
public class XBTEditor {
    private static boolean verboseMode = false;
    private static boolean devMode = false;
    private static ResourceBundle bundle;

    private XBTEditor() {
    }

    public static void main(String[] args) {
        block6: {
            try {
                bundle = LanguageUtils.getResourceBundleByClass(XBTEditor.class);
                Options opt = new Options();
                opt.addOption("h", "help", false, bundle.getString("cl_option_help"));
                opt.addOption("v", false, bundle.getString("cl_option_verbose"));
                opt.addOption("dev", false, bundle.getString("cl_option_dev"));
                BasicParser parser = new BasicParser();
                CommandLine cl = parser.parse(opt, args);
                if (cl.hasOption('h')) {
                    HelpFormatter f = new HelpFormatter();
                    f.printHelp(bundle.getString("cl_syntax"), opt);
                    break block6;
                }
                verboseMode = cl.hasOption("v");
                devMode = cl.hasOption("dev");
                Logger logger = Logger.getLogger("");
                try {
                    logger.setLevel(Level.ALL);
                    logger.addHandler((Handler)new XBHead.XBLogHandler(verboseMode));
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                XBBaseApplication app = new XBBaseApplication();
                app.setAppDirectory(XBTEditor.class);
                Preferences preferences = app.createPreferences(XBTEditor.class);
                app.setAppBundle(bundle, LanguageUtils.getResourceBaseNameBundleByClass(XBTEditor.class));
                XBApplicationModuleRepository moduleRepository = app.getModuleRepository();
                moduleRepository.addClassPathModules();
                moduleRepository.addModulesFromManifest(XBTEditor.class);
                moduleRepository.initModules();
                app.init();
                FrameModuleApi frameModule = (FrameModuleApi)moduleRepository.getModuleByInterface(FrameModuleApi.class);
                EditorModuleApi editorModule = (EditorModuleApi)moduleRepository.getModuleByInterface(EditorModuleApi.class);
                ActionModuleApi actionModule = (ActionModuleApi)moduleRepository.getModuleByInterface(ActionModuleApi.class);
                AboutModuleApi aboutModule = (AboutModuleApi)moduleRepository.getModuleByInterface(AboutModuleApi.class);
                OperationUndoModuleApi undoModule = (OperationUndoModuleApi)moduleRepository.getModuleByInterface(OperationUndoModuleApi.class);
                FileModuleApi fileModule = (FileModuleApi)moduleRepository.getModuleByInterface(FileModuleApi.class);
                OptionsModuleApi optionsModule = (OptionsModuleApi)moduleRepository.getModuleByInterface(OptionsModuleApi.class);
                EditorTextModule textEditorModule = (EditorTextModule)moduleRepository.getModuleByInterface(EditorTextModule.class);
                frameModule.createMainMenu();
                aboutModule.registerDefaultMenuItem();
                frameModule.registerExitAction();
                frameModule.registerBarsVisibilityActions();
                fileModule.registerMenuFileHandlingActions();
                fileModule.registerToolBarFileHandlingActions();
                fileModule.registerRecenFilesMenuActions();
                fileModule.registerCloseListener();
                undoModule.registerMainMenu();
                undoModule.registerMainToolBar();
                actionModule.registerMenuClipboardActions();
                actionModule.registerToolBarClipboardActions();
                optionsModule.registerMenuAction();
                textEditorModule.registerFileTypes();
                textEditorModule.registerEditFindMenuActions();
                textEditorModule.registerEditFindToolBarActions();
                textEditorModule.registerToolsOptionsMenuActions();
                textEditorModule.registerOptionsMenuPanels();
                textEditorModule.registerWordWrapping();
                textEditorModule.registerGoToLine();
                textEditorModule.registerPropertiesMenu();
                textEditorModule.registerPrintMenu();
                ApplicationFrameHandler frameHandler = frameModule.getFrameHandler();
                EditorProvider editorProvider = textEditorModule.getEditorProvider();
                editorModule.registerEditor("text", editorProvider);
                editorModule.registerUndoHandler();
                textEditorModule.registerStatusBar();
                textEditorModule.registerOptionsPanels();
                textEditorModule.loadFromPreferences(preferences);
                frameHandler.setMainPanel((Component)editorModule.getEditorComponent());
                frameHandler.setDefaultSize(new Dimension(600, 400));
                optionsModule.initialLoadFromPreferences();
                frameHandler.showFrame();
                List fileArgs = cl.getArgList();
                if (!fileArgs.isEmpty()) {
                    fileModule.loadFromFile((String)fileArgs.get(0));
                }
            }
            catch (RuntimeException | ParseException ex) {
                Logger.getLogger(XBTEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

