/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.action.predefined.CMaximizeAction;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CModeArea;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.mode.KeyedLocationModeActionProvider;
import bibliothek.gui.dock.common.perspective.mode.CMaximizedModePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMaximizedMode
extends MaximizedMode<CMaximizedModeArea>
implements CLocationMode {
    private CControl control;

    public CMaximizedMode(CControl control) {
        this.control = control;
        this.setActionProvider(new KeyedLocationModeActionProvider("cdockable.maximize", new CMaximizeAction(control)));
    }

    @Override
    public CLocation getCLocation(Dockable dockable) {
        CMaximizedModeArea area = (CMaximizedModeArea)this.get(dockable);
        if (area == null) {
            return null;
        }
        return area.getCLocation(dockable);
    }

    @Override
    public CLocation getCLocation(Dockable dockable, Location location) {
        CModeArea area = (CModeArea)this.get(location.getRoot());
        if (area == null) {
            return null;
        }
        return area.getCLocation(dockable, location);
    }

    @Override
    public boolean isBasicMode() {
        return false;
    }

    @Override
    public boolean respectWorkingAreas(DockStation station) {
        CModeArea area = (CModeArea)this.get(station);
        if (area == null) {
            return true;
        }
        return area.respectWorkingAreas();
    }

    @Override
    public LocationModePerspective createPerspective() {
        return new CMaximizedModePerspective();
    }

    @Override
    public MaximizedModeArea getMaximizeArea(Dockable dockable, Location history) {
        MaximizedModeArea area = super.getMaximizeArea(dockable, history);
        if (area == null) {
            DockStation parent = dockable.getDockParent();
            while (parent != null) {
                CStation<?> result;
                CStationContainer container;
                CStation<?> station = this.control.getStation(parent);
                if (station != null && (container = this.control.getRegister().getContainer(station)) != null && (result = container.getDefaultStation(ExtendedMode.MAXIMIZED)) != null) {
                    return this.getMaximizeArea((DockStation)result.getStation());
                }
                Dockable temp = parent.asDockable();
                if (temp == null) {
                    parent = null;
                    continue;
                }
                parent = temp.getDockParent();
            }
        }
        return area;
    }
}

