/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.font;

import bibliothek.gui.dock.common.FontMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.font.FontTransmitter;
import bibliothek.gui.dock.util.font.DockFont;
import bibliothek.gui.dock.util.font.FontManager;
import bibliothek.gui.dock.util.font.FontModifier;

public abstract class ListFontTransmitter
extends FontTransmitter {
    private String[] source;
    private String[] destination;

    public ListFontTransmitter(FontManager manager, String[] sourceKeys, String[] destinationKeys) {
        super(manager, destinationKeys);
        this.source = sourceKeys;
        this.destination = destinationKeys;
    }

    protected FontModifier get(FontModifier value, String id, DockFont observer) {
        CDockable dockable = this.getDockable(observer);
        if (dockable == null) {
            return value;
        }
        return this.get(value, id, dockable);
    }

    protected boolean isObservedMapKey(String key) {
        for (String observer : this.source) {
            if (!observer.equals(key)) continue;
            return true;
        }
        return false;
    }

    private FontModifier getFirstNonNull(FontMap fonts, int index) {
        int n = this.source.length;
        for (int i = index; i < n; ++i) {
            FontModifier font = fonts.getFont(this.source[i]);
            if (font == null) continue;
            return font;
        }
        return null;
    }

    protected FontModifier get(FontModifier value, String id, CDockable dockable) {
        FontModifier result = null;
        int n = this.destination.length;
        for (int i = 0; i < n; ++i) {
            if (!this.destination[i].equals(id)) continue;
            result = this.getFirstNonNull(dockable.getFonts(), i);
            break;
        }
        if (result == null) {
            result = value;
        }
        return result;
    }
}

