/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.visual.xbplugins;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPInputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPOutputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSerializable;
import org.exbin.xbup.visual.picture.XBBufferedImage;
import org.exbin.xbup.visual.xbplugins.ImageFileFilter;

public class XBPictureViewerPanel
extends JPanel
implements XBPSerializable {
    private static final int BLOCK_WIDTH = 24;
    private static final int BLOCK_HEIGHT = 24;
    private final JFileChooser saveFC;
    private ChangeListener changeListener = null;
    private JMenuItem exportMenuItem;
    private JLabel imageLabel;
    private JPanel imagePanel;
    private JPopupMenu imagePopupMenu;
    private JScrollPane imageScrollPane;

    public XBPictureViewerPanel() {
        String[] formats;
        this.initComponents();
        this.saveFC = new JFileChooser();
        for (String ext : formats = ImageIO.getReaderFormatNames()) {
            if (!ext.toLowerCase().equals(ext)) continue;
            ImageFileFilter filter = new ImageFileFilter(ext);
            this.saveFC.addChoosableFileFilter(filter);
        }
        this.saveFC.setAcceptAllFileFilterUsed(true);
        this.imageLabel.setIcon(new ImageIcon());
    }

    private void initComponents() {
        this.imagePopupMenu = new JPopupMenu();
        this.exportMenuItem = new JMenuItem();
        this.imageScrollPane = new JScrollPane();
        this.imagePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Dimension size = this.getSize();
                int hBlocks = (size.width + 24 - 1) / 24;
                int vBlocks = (size.height + 24 - 1) / 24;
                g.setColor(new Color(240, 240, 240));
                for (int x = 0; x < hBlocks; ++x) {
                    for (int y = 0; y < vBlocks; ++y) {
                        if ((x & 1) == (y & 1)) continue;
                        g.fillRect(x * 24, y * 24, 24, 24);
                    }
                }
            }
        };
        this.imageLabel = new JLabel();
        this.exportMenuItem.setText("Export...");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBPictureViewerPanel.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.imagePopupMenu.add(this.exportMenuItem);
        this.setLayout(new BorderLayout());
        this.imagePanel.setBackground(new Color(255, 255, 255));
        this.imagePanel.setLayout(new BorderLayout());
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setAutoscrolls(true);
        this.imageLabel.setDoubleBuffered(true);
        this.imagePanel.add((Component)this.imageLabel, "Center");
        this.imageScrollPane.setViewportView(this.imagePanel);
        this.add((Component)this.imageScrollPane, "Center");
    }

    private void exportMenuItemActionPerformed(ActionEvent evt) {
        if (this.saveFC.showSaveDialog(this) == 0) {
            try {
                File file = new File(this.saveFC.getSelectedFile().getAbsolutePath());
                String ext = "png";
                if (this.saveFC.getFileFilter() instanceof ImageFileFilter) {
                    ext = ((ImageFileFilter)this.saveFC.getFileFilter()).getExt();
                }
                ImageIO.write((RenderedImage)XBPictureViewerPanel.toBufferedImage(((ImageIcon)this.imageLabel.getIcon()).getImage()), ext, file);
                this.imageLabel.setIcon(new ImageIcon(this.saveFC.getSelectedFile().getAbsolutePath()));
            }
            catch (IOException ex) {
                Logger.getLogger(XBPictureViewerPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = XBPictureViewerPanel.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public Icon getIcon() {
        return this.imageLabel.getIcon();
    }

    public void setIcon(Icon icon) {
        this.imageLabel.setIcon(icon);
    }

    public void serializeFromXB(XBPInputSerialHandler serializationHandler) throws XBProcessingException, IOException {
        XBBufferedImage image = new XBBufferedImage();
        serializationHandler.append((XBSerializable)image);
        ((ImageIcon)this.imageLabel.getIcon()).setImage(image.getImage());
    }

    public void serializeToXB(XBPOutputSerialHandler serializationHandler) throws XBProcessingException, IOException {
        XBBufferedImage bufferedImage = new XBBufferedImage(XBPictureViewerPanel.toBufferedImage(((ImageIcon)this.imageLabel.getIcon()).getImage()));
        serializationHandler.append((XBSerializable)bufferedImage);
    }

    public void attachChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    public void fireChangePerformed() {
        if (this.changeListener != null) {
            this.changeListener.valueChanged();
        }
    }

    public static interface ChangeListener {
        public void valueChanged();
    }
}

