/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.visual.picture;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPInputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPListener;
import org.exbin.xbup.core.serial.param.XBPOutputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProvider;
import org.exbin.xbup.core.serial.param.XBPSerializable;

public class XBWritableRaster
extends WritableRaster
implements XBPSerializable {
    public static long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{0L, 4L, 0L, 0L, 0L};

    public XBWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle aRegion, Point sampleModelTranslate, WritableRaster parent) {
        super(sampleModel, dataBuffer, aRegion, sampleModelTranslate, parent);
    }

    public XBWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point origin) {
        super(sampleModel, dataBuffer, origin);
    }

    public XBWritableRaster(SampleModel sampleModel, Point origin) {
        super(sampleModel, origin);
    }

    public static void serializeXBWritableRasterToXBT(final WritableRaster source, XBPListener serial) throws XBProcessingException, IOException {
        serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
        serial.putData(new InputStream(){
            private int posX;
            private int posY;
            private int val;

            void InputStream(WritableRaster source2) {
                this.posX = 0;
                this.posY = 0;
                this.val = 0;
            }

            @Override
            public int read() throws IOException {
                if (this.posY < 0) {
                    return this.posY;
                }
                int result = source.getSample(this.posX, this.posY, this.val);
                if (this.val == 2) {
                    this.val = 0;
                    if (this.posX == source.getWidth() - 1) {
                        this.posX = 0;
                        this.posY = this.posY == source.getHeight() - 1 ? -1 : ++this.posY;
                    } else {
                        ++this.posX;
                    }
                } else {
                    ++this.val;
                }
                return result;
            }

            @Override
            public int available() throws IOException {
                if (this.posY < 0) {
                    return 0;
                }
                int size = (source.getHeight() - this.posY - 1) * source.getWidth() * 3 + (source.getWidth() - this.posX) * 3 - this.val;
                return size;
            }
        });
        serial.putEnd();
    }

    public static void serializeXBWritableRasterFromXBT(WritableRaster source, XBPProvider serial) throws XBProcessingException, IOException {
        serial.pullBegin();
        int posX = 0;
        int posY = 0;
        int val = 0;
        InputStream stream = serial.pullData();
        while (true) {
            int input = stream.read();
            source.setSample(posX, posY, val, input);
            if (val == 2) {
                val = 0;
                if (posX == source.getWidth() - 1) {
                    posX = 0;
                    if (posY == source.getHeight() - 1) break;
                    ++posY;
                    continue;
                }
                ++posX;
                continue;
            }
            ++val;
        }
        serial.pullEnd();
    }

    public static XBSerializable getXBWritableRasterSerializator(WritableRaster source) {
        return new XBTSerializator(source);
    }

    public void serializeFromXB(XBPInputSerialHandler serializationHandler) throws XBProcessingException, IOException {
        XBWritableRaster.serializeXBWritableRasterFromXBT(this, (XBPProvider)serializationHandler);
    }

    public void serializeToXB(XBPOutputSerialHandler serializationHandler) throws XBProcessingException, IOException {
        XBWritableRaster.serializeXBWritableRasterToXBT(this, (XBPListener)serializationHandler);
    }

    private static class XBTSerializator
    implements XBPSerializable {
        private final WritableRaster source;

        public XBTSerializator(WritableRaster source) {
            this.source = source;
        }

        public void serializeFromXB(XBPInputSerialHandler serializationHandler) throws XBProcessingException, IOException {
            XBWritableRaster.serializeXBWritableRasterFromXBT(this.source, (XBPProvider)serializationHandler);
        }

        public void serializeToXB(XBPOutputSerialHandler serializationHandler) throws XBProcessingException, IOException {
            XBWritableRaster.serializeXBWritableRasterToXBT(this.source, (XBPListener)serializationHandler);
        }
    }
}

