/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class ModifyDataOperation
extends CodeAreaOperation {
    private final long position;
    private final BinaryData data;

    public ModifyDataOperation(CodeAreaCore codeArea, long position, BinaryData data) {
        super(codeArea);
        this.position = position;
        this.data = data;
    }

    @Override
    @Nonnull
    public CodeAreaOperationType getType() {
        return CodeAreaOperationType.MODIFY_DATA;
    }

    @Override
    @Nullable
    protected CodeAreaOperation execute(CodeAreaOperation.ExecutionType executionType) {
        ModifyDataOperation undoOperation = null;
        if (executionType == CodeAreaOperation.ExecutionType.WITH_UNDO) {
            BinaryData undoData = this.codeArea.getContentData().copy(this.position, this.data.getDataSize());
            undoOperation = new ModifyDataOperation(this.codeArea, this.position, undoData);
        }
        ((EditableBinaryData)this.codeArea.getContentData()).replace(this.position, this.data);
        return undoOperation;
    }

    public void appendData(BinaryData appendData) {
        ((EditableBinaryData)this.data).insert(this.data.getDataSize(), appendData);
    }

    @Override
    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        this.data.dispose();
    }
}

