/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.command;

import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.audio.swing.XBWavePanel;
import org.exbin.xbup.operation.AbstractCommand;

@ParametersAreNonnullByDefault
public class WaveDeleteCommand
extends AbstractCommand {
    private final XBWavePanel wave;
    private final int startPosition;
    private final int endPosition;
    private BinaryData deletedData;

    public WaveDeleteCommand(XBWavePanel wave, int startPosition, int endPosition) {
        this.wave = wave;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    @Nonnull
    public String getCaption() {
        return "Wave section deleted";
    }

    public void execute() throws Exception {
        this.deletedData = this.wave.getWave().cutData(this.startPosition, this.endPosition - this.startPosition);
        this.wave.rebuildZoomCache();
    }

    public void redo() throws Exception {
        this.execute();
    }

    public void undo() throws Exception {
        this.wave.getWave().insertData(this.deletedData, this.startPosition);
        this.wave.rebuildZoomCache();
        this.deletedData = null;
    }

    public boolean canUndo() {
        return true;
    }

    public void dispose() throws Exception {
    }

    @Nonnull
    public Optional<Date> getExecutionTime() {
        return Optional.empty();
    }
}

