/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.editor.wave.options.gui.WaveColorPanel;
import org.exbin.framework.editor.wave.service.impl.WaveColorServiceImpl;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;

@ParametersAreNonnullByDefault
public class WaveColorAction
extends AbstractAction {
    public static final String ACTION_ID = "toolsSetColorAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        WaveColorServiceImpl waveColorService = new WaveColorServiceImpl(this.editorProvider);
        WaveColorPanel waveColorPanel = new WaveColorPanel();
        waveColorPanel.setWaveColorService(waveColorService);
        waveColorPanel.setWaveColorsFromArray(audioPanel.getAudioPanelColors());
        DefaultControlPanel controlPanel = new DefaultControlPanel(waveColorPanel.getResourceBundle());
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)waveColorPanel, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), waveColorPanel.getClass(), (ResourceBundle)waveColorPanel.getResourceBundle());
        frameModule.setDialogTitle(dialog, waveColorPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                audioPanel.setAudioPanelColors(waveColorPanel.getWaveColorsAsArray());
            }
            dialog.close();
        });
        dialog.showCentered((Component)e.getSource());
        dialog.dispose();
    }
}

